/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncFilterInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncFilterOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class StreamUtil {
    public static final int BUFFER_SIZE = GetterUtil.getInteger(System.getProperty(StreamUtil.class.getName() + ".buffer.size"), 8192);
    public static final boolean FORCE_TIO = GetterUtil.getBoolean(System.getProperty(StreamUtil.class.getName() + ".force.tio"));
    private static final Log _log = LogFactoryUtil.getLog(StreamUtil.class);

    public static void cleanUp(boolean quite, Closeable ... closeables) {
        IOException ioException = null;
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                if (ioException == null) {
                    ioException = ioe;
                    continue;
                }
                ioException.addSuppressed(ioe);
            }
        }
        if (ioException == null) {
            return;
        }
        if (quite) {
            if (_log.isWarnEnabled()) {
                _log.warn(ioException, ioException);
            }
        } else {
            ReflectionUtil.throwException(ioException);
        }
    }

    public static void cleanUp(Closeable ... closeables) {
        StreamUtil.cleanUp(true, closeables);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, BUFFER_SIZE, true);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, boolean cleanUp) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, BUFFER_SIZE, cleanUp);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, bufferSize, true);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, int bufferSize, boolean cleanUp) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, bufferSize, cleanUp, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transfer(InputStream inputStream, OutputStream outputStream, int bufferSize, boolean cleanUp, long length) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream is null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream is null");
        }
        if (bufferSize <= 0) {
            bufferSize = BUFFER_SIZE;
        }
        try {
            if (!FORCE_TIO && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                FileInputStream fileInputStream = (FileInputStream)inputStream;
                FileOutputStream fileOutputStream = (FileOutputStream)outputStream;
                StreamUtil.transferFileChannel(fileInputStream.getChannel(), fileOutputStream.getChannel(), length);
            } else {
                StreamUtil.transferByteArray(inputStream, outputStream, bufferSize, length);
            }
            if (!cleanUp) return;
        }
        catch (Throwable throwable) {
            if (!cleanUp) throw throwable;
            StreamUtil.cleanUp(false, inputStream, outputStream);
            throw throwable;
        }
        StreamUtil.cleanUp(false, inputStream, outputStream);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, long length) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, BUFFER_SIZE, true, length);
    }

    public static InputStream uncloseable(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return new UnsyncFilterInputStream(inputStream){

            @Override
            public void close() {
            }
        };
    }

    public static OutputStream uncloseable(OutputStream outputStream) {
        if (outputStream == null) {
            return null;
        }
        return new UnsyncFilterOutputStream(outputStream){

            @Override
            public void close() {
            }
        };
    }

    protected static void transferByteArray(InputStream inputStream, OutputStream outputStream, int bufferSize, long length) throws IOException {
        byte[] bytes = new byte[bufferSize];
        if (length > 0L) {
            int readBytes;
            for (long remainingLength = length; remainingLength > 0L && (readBytes = inputStream.read(bytes, 0, (int)Math.min(remainingLength, (long)bufferSize))) != -1; remainingLength -= (long)readBytes) {
                outputStream.write(bytes, 0, readBytes);
            }
        } else {
            int value = -1;
            while ((value = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, value);
            }
        }
    }

    protected static void transferFileChannel(FileChannel inputFileChannel, FileChannel outputFileChannel, long length) throws IOException {
        if (length <= 0L) {
            length = inputFileChannel.size() - inputFileChannel.position();
        }
        for (long count = 0L; count < length; count += inputFileChannel.transferTo(inputFileChannel.position() + count, length - count, outputFileChannel)) {
        }
    }
}

