/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class ServerDetector {
    public static final String GLASSFISH_ID = "glassfish";
    public static final String JBOSS_ID = "jboss";
    public static final String JETTY_ID = "jetty";
    public static final String JONAS_ID = "jonas";
    public static final String OC4J_ID = "oc4j";
    public static final String RESIN_ID = "resin";
    public static final String TOMCAT_ID = "tomcat";
    public static final String WEBLOGIC_ID = "weblogic";
    public static final String WEBSPHERE_ID = "websphere";
    public static final String WILDFLY_ID = "wildfly";
    private static final boolean _SUPPORTS_COMET = false;
    private static final Log _log = LogFactoryUtil.getLog(ServerDetector.class);
    private static ServerDetector _instance;
    private boolean _glassfish;
    private boolean _jBoss;
    private boolean _jetty;
    private boolean _jonas;
    private boolean _oc4j;
    private boolean _resin;
    private String _serverId;
    private boolean _tomcat;
    private boolean _webLogic;
    private boolean _webSphere;
    private boolean _wildfly;

    public static ServerDetector getInstance() {
        if (_instance == null) {
            _instance = new ServerDetector();
            _instance._init();
        }
        return _instance;
    }

    public static String getServerId() {
        return ServerDetector.getInstance()._serverId;
    }

    public static void init(String serverId) {
        ServerDetector serverDetector = new ServerDetector();
        serverDetector._serverId = serverId;
        if (serverId.equals(GLASSFISH_ID)) {
            serverDetector._glassfish = true;
        } else if (serverId.equals(JBOSS_ID)) {
            serverDetector._jBoss = true;
        } else if (serverId.equals(JETTY_ID)) {
            serverDetector._jetty = true;
        } else if (serverId.equals(JONAS_ID)) {
            serverDetector._jonas = true;
        } else if (serverId.equals(OC4J_ID)) {
            serverDetector._oc4j = true;
        } else if (serverId.equals(RESIN_ID)) {
            serverDetector._resin = true;
        } else if (serverId.equals(TOMCAT_ID)) {
            serverDetector._tomcat = true;
        } else if (serverId.equals(WEBLOGIC_ID)) {
            serverDetector._webLogic = true;
        } else if (serverId.equals(WEBSPHERE_ID)) {
            serverDetector._webSphere = true;
        } else if (serverId.equals(WILDFLY_ID)) {
            serverDetector._wildfly = true;
        } else {
            serverDetector._init();
        }
        _instance = serverDetector;
    }

    public static boolean isGlassfish() {
        return ServerDetector.getInstance()._glassfish;
    }

    public static boolean isJBoss() {
        return ServerDetector.getInstance()._jBoss;
    }

    public static boolean isJetty() {
        return ServerDetector.getInstance()._jetty;
    }

    public static boolean isJOnAS() {
        return ServerDetector.getInstance()._jonas;
    }

    public static boolean isOC4J() {
        return ServerDetector.getInstance()._oc4j;
    }

    public static boolean isResin() {
        return ServerDetector.getInstance()._resin;
    }

    public static boolean isSupportsComet() {
        return false;
    }

    @Deprecated
    public static boolean isSupportsHotDeploy() {
        return true;
    }

    public static boolean isTomcat() {
        return ServerDetector.getInstance()._tomcat;
    }

    public static boolean isWebLogic() {
        return ServerDetector.getInstance()._webLogic;
    }

    public static boolean isWebSphere() {
        return ServerDetector.getInstance()._webSphere;
    }

    public static boolean isWildfly() {
        return ServerDetector.getInstance()._wildfly;
    }

    @Deprecated
    public static void setSupportsHotDeploy(boolean supportsHotDeploy) {
    }

    private boolean _detect(String className) {
        try {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            systemClassLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            Class<?> clazz = this.getClass();
            return clazz.getResource(className) != null;
        }
    }

    private boolean _hasSystemProperty(String key) {
        String value = System.getProperty(key);
        return value != null;
    }

    private void _init() {
        if (this._isGlassfish()) {
            this._serverId = GLASSFISH_ID;
            this._glassfish = true;
        } else if (this._isJBoss()) {
            this._serverId = JBOSS_ID;
            this._jBoss = true;
        } else if (this._isJOnAS()) {
            this._serverId = JONAS_ID;
            this._jonas = true;
        } else if (this._isOC4J()) {
            this._serverId = OC4J_ID;
            this._oc4j = true;
        } else if (this._isResin()) {
            this._serverId = RESIN_ID;
            this._resin = true;
        } else if (this._isWebLogic()) {
            this._serverId = WEBLOGIC_ID;
            this._webLogic = true;
        } else if (this._isWebSphere()) {
            this._serverId = WEBSPHERE_ID;
            this._webSphere = true;
        } else if (this._isWildfly()) {
            this._serverId = WILDFLY_ID;
            this._wildfly = true;
        }
        if (this._serverId == null) {
            if (this._isJetty()) {
                this._serverId = JETTY_ID;
                this._jetty = true;
            } else if (this._isTomcat()) {
                this._serverId = TOMCAT_ID;
                this._tomcat = true;
            }
        }
        if (System.getProperty("external-properties") == null && _log.isInfoEnabled()) {
            if (this._serverId != null) {
                _log.info("Detected server " + this._serverId);
            } else {
                _log.info("No server detected");
            }
        }
    }

    private boolean _isGlassfish() {
        return this._hasSystemProperty("com.sun.aas.instanceRoot");
    }

    private boolean _isJBoss() {
        return this._hasSystemProperty("jboss.home.dir");
    }

    private boolean _isJetty() {
        return this._hasSystemProperty("jetty.home");
    }

    private boolean _isJOnAS() {
        return this._hasSystemProperty("jonas.base");
    }

    private boolean _isOC4J() {
        return this._detect("oracle.oc4j.util.ClassUtils");
    }

    private boolean _isResin() {
        return this._hasSystemProperty("resin.home");
    }

    private boolean _isTomcat() {
        return this._hasSystemProperty("catalina.base");
    }

    private boolean _isWebLogic() {
        return this._detect("/weblogic/Server.class");
    }

    private boolean _isWebSphere() {
        return this._detect("/com/ibm/websphere/product/VersionInfo.class");
    }

    private boolean _isWildfly() {
        return this._hasSystemProperty("jboss.home.dir");
    }
}

