/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;

public class MethodParameter {
    private final Class<?>[] _genericTypes;
    private final String _name;
    private final Class<?> _type;

    public MethodParameter(String name, String signatures, Class<?> type) {
        this._name = name;
        this._type = type;
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            this._genericTypes = this._getGenericTypes(contextClassLoader, signatures);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe);
        }
    }

    public Class<?>[] getGenericTypes() {
        return this._genericTypes;
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    private String _getClassName(String signature) {
        String className = signature;
        char c = signature.charAt(0);
        if (this._isPrimitive(c)) {
            if (signature.length() != 1) {
                throw new IllegalArgumentException("Invalid signature " + signature);
            }
        } else if (c == 'L') {
            className = className.substring(1, className.length() - 1);
            className = className.replace('/', '.');
        } else if (c == '[') {
            className = className.replace('/', '.');
        } else {
            throw new IllegalArgumentException("Invalid signature " + signature);
        }
        return className;
    }

    private String _getGenericName(String typeName) {
        if (typeName.equals("*")) {
            return null;
        }
        if (typeName.startsWith("-") || typeName.startsWith("+")) {
            typeName = typeName.substring(1);
        }
        return typeName;
    }

    private Class<?> _getGenericType(ClassLoader contextClassLoader, String signature) throws ClassNotFoundException {
        String className = this._getClassName(signature);
        if (className.startsWith("[")) {
            try {
                return Class.forName(className, true, contextClassLoader);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return contextClassLoader.loadClass(className);
    }

    private Class<?>[] _getGenericTypes(ClassLoader contextClassLoader, String signatures) throws ClassNotFoundException {
        if (signatures == null) {
            return null;
        }
        int leftBracketIndex = signatures.indexOf(60);
        if (leftBracketIndex == -1) {
            return null;
        }
        int rightBracketIndex = signatures.lastIndexOf(62);
        if (rightBracketIndex == -1) {
            return null;
        }
        String generics = signatures.substring(leftBracketIndex + 1, rightBracketIndex);
        ArrayList genericTypeslist = new ArrayList();
        int level = 0;
        int index = 0;
        while (index < generics.length()) {
            int endIndex;
            char c = generics.charAt(index);
            ++index;
            if (c == '<') {
                ++level;
                continue;
            }
            if (c == '>') {
                --level;
                continue;
            }
            if (level != 0) continue;
            String extractedTopLevelGenericName = null;
            if (c == 'L') {
                int bracketIndex = generics.indexOf("<", index);
                endIndex = generics.indexOf(";", index) + 1;
                if (bracketIndex != -1 && bracketIndex < endIndex) {
                    endIndex = bracketIndex;
                    extractedTopLevelGenericName = this._getGenericName(generics.substring(index - 1, endIndex));
                    extractedTopLevelGenericName = extractedTopLevelGenericName.concat(";");
                } else {
                    extractedTopLevelGenericName = this._getGenericName(generics.substring(index - 1, endIndex));
                }
                index = endIndex;
            } else if (c == '[') {
                char nextChar = generics.charAt(index);
                if (this._isPrimitive(nextChar)) {
                    extractedTopLevelGenericName = this._getGenericName(generics.substring(index - 1, index + 1));
                    ++index;
                } else if (nextChar == 'L') {
                    endIndex = generics.indexOf(";", index) + 1;
                    extractedTopLevelGenericName = this._getGenericName(generics.substring(index - 1, endIndex));
                    index = endIndex;
                }
            }
            if (!Validator.isNotNull(extractedTopLevelGenericName)) continue;
            genericTypeslist.add(this._getGenericType(contextClassLoader, extractedTopLevelGenericName));
        }
        if (genericTypeslist.isEmpty()) {
            return null;
        }
        return genericTypeslist.toArray(new Class[genericTypeslist.size()]);
    }

    private boolean _isPrimitive(char c) {
        return c == 'B' || c == 'C' || c == 'D' || c == 'F' || c == 'I' || c == 'J' || c == 'S' || c == 'V' || c == 'Z';
    }
}

