/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;

public class GroupThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(GroupThreadLocal.class);
    private static final ThreadLocal<Boolean> _deleteInProcess = new AutoResetThreadLocal<Boolean>(GroupThreadLocal.class + "._deleteInProcess", false);
    private static final ThreadLocal<Long> _groupId = new AutoResetThreadLocal<Long>(GroupThreadLocal.class + "._groupId", 0L);

    public static Long getGroupId() {
        Long groupId = _groupId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("getGroupId " + groupId);
        }
        return groupId;
    }

    public static boolean isDeleteInProcess() {
        return _deleteInProcess.get();
    }

    public static void setDeleteInProcess(boolean deleteInProcess) {
        _deleteInProcess.set(deleteInProcess);
    }

    public static void setGroupId(Long groupId) {
        if (_log.isDebugEnabled()) {
            _log.debug("setGroupId " + groupId);
        }
        if (groupId > 0L) {
            _groupId.set(groupId);
        } else {
            _groupId.set(0L);
        }
    }
}

