/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PluginContextLifecycleThreadLocal;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class PluginContextListener
extends BasePortalLifecycle
implements ServletContextAttributeListener,
ServletContextListener {
    public static final String PLUGIN_CLASS_LOADER = "PLUGIN_CLASS_LOADER";
    protected ClassLoader pluginClassLoader;
    protected ServletContext servletContext;
    private static final Log _log = LogFactoryUtil.getLog(PluginContextListener.class);
    private boolean _addedPluginClassLoader;

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
        String name = servletContextAttributeEvent.getName();
        if (this._addedPluginClassLoader && name.equals(PLUGIN_CLASS_LOADER) && servletContextAttributeEvent.getValue() != this.pluginClassLoader) {
            if (_log.isWarnEnabled()) {
                _log.warn("Preventing the addition of another plugin class loader");
            }
            this.servletContext.setAttribute(PLUGIN_CLASS_LOADER, (Object)this.pluginClassLoader);
        } else if (!this._addedPluginClassLoader && name.equals(PLUGIN_CLASS_LOADER)) {
            this._addedPluginClassLoader = true;
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
        String name = servletContextAttributeEvent.getName();
        if (this._addedPluginClassLoader && name.equals(PLUGIN_CLASS_LOADER)) {
            if (_log.isWarnEnabled()) {
                _log.warn("Preventing the removal of the plugin class loader");
            }
            this.servletContext.setAttribute(PLUGIN_CLASS_LOADER, (Object)this.pluginClassLoader);
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
        String name = servletContextAttributeEvent.getName();
        if (this._addedPluginClassLoader && name.equals(PLUGIN_CLASS_LOADER)) {
            if (_log.isWarnEnabled()) {
                _log.warn("Preventing the replacement of the plugin class loader");
            }
            this.servletContext.removeAttribute(PLUGIN_CLASS_LOADER);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        ClassLoaderPool.unregister(servletContext.getServletContextName());
        this.portalDestroy();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.servletContext = servletContextEvent.getServletContext();
        Thread currentThread = Thread.currentThread();
        this.pluginClassLoader = currentThread.getContextClassLoader();
        ClassLoaderPool.register(this.servletContext.getServletContextName(), this.pluginClassLoader);
        this.servletContext.setAttribute(PLUGIN_CLASS_LOADER, (Object)this.pluginClassLoader);
        ServletContextPool.put(this.servletContext.getServletContextName(), this.servletContext);
        this.registerPortalLifecycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPortalDestroy() throws Exception {
        PluginContextLifecycleThreadLocal.setDestroying(true);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (contextClassLoader != this.pluginClassLoader) {
            currentThread.setContextClassLoader(this.pluginClassLoader);
        }
        try {
            this.fireUndeployEvent();
        }
        finally {
            PluginContextLifecycleThreadLocal.setDestroying(false);
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPortalInit() throws Exception {
        PluginContextLifecycleThreadLocal.setInitializing(true);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (contextClassLoader != this.pluginClassLoader) {
            currentThread.setContextClassLoader(this.pluginClassLoader);
        }
        try {
            this.fireDeployEvent();
        }
        finally {
            PluginContextLifecycleThreadLocal.setInitializing(false);
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected void fireDeployEvent() {
        HotDeployUtil.fireDeployEvent(new HotDeployEvent(this.servletContext, this.pluginClassLoader));
    }

    protected void fireUndeployEvent() {
        HotDeployUtil.fireUndeployEvent(new HotDeployEvent(this.servletContext, this.pluginClassLoader));
    }
}

