/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.LiferayPortlet;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletConfigurationLayoutUtil;
import com.liferay.portal.kernel.portlet.ResourceServingConfigurationAction;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ValidatorException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public abstract class SettingsConfigurationAction
extends LiferayPortlet
implements ConfigurationAction,
ResourceServingConfigurationAction {
    private String _parameterNamePrefix;

    public SettingsConfigurationAction() {
        this.setParameterNamePrefix("preferences--");
    }

    public String getLocalizedParameter(PortletRequest portletRequest, String name) {
        String languageId = ParamUtil.getString(portletRequest, "languageId");
        return this.getLocalizedParameter(portletRequest, name, languageId);
    }

    public String getLocalizedParameter(PortletRequest portletRequest, String name, String languageId) {
        return this.getParameter(portletRequest, LocalizationUtil.getLocalizedName(name, languageId));
    }

    public String getParameter(PortletRequest portletRequest, String name) {
        name = this._parameterNamePrefix + name + "--";
        return ParamUtil.getString(portletRequest, name);
    }

    @Override
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.updateMultiValuedKeys(actionRequest);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, "cmd");
        if (!cmd.equals("update")) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = PortletConfigurationLayoutUtil.getLayout(themeDisplay);
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, "portletResource");
        PortletPermissionUtil.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), layout, portletResource, "CONFIGURATION");
        UnicodeProperties properties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, this._parameterNamePrefix);
        Settings settings = this.getSettings(actionRequest);
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        for (Map.Entry entry : properties.entrySet()) {
            String oldValue;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringUtil.equalsIgnoreBreakLine(value, oldValue = settings.getValue(name, null))) continue;
            modifiableSettings.setValue(name, value);
        }
        Map portletPreferencesMap = (Map)actionRequest.getAttribute("PORTLET_PREFERENCES_MAP");
        if (portletPreferencesMap != null) {
            for (Map.Entry entry : portletPreferencesMap.entrySet()) {
                String[] oldValues;
                String name = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                if (Objects.equals(values, oldValues = settings.getValues(name, null))) continue;
                modifiableSettings.setValues(name, values);
            }
        }
        this.postProcess(themeDisplay.getCompanyId(), (PortletRequest)actionRequest, settings);
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            try {
                modifiableSettings.store();
            }
            catch (ValidatorException ve) {
                SessionErrors.add((PortletRequest)actionRequest, ValidatorException.class.getName(), (Object)ve);
                return;
            }
            SessionMessages.add((PortletRequest)actionRequest, PortalUtil.getPortletId((PortletRequest)actionRequest) + ".refreshPortlet", (Object)portletResource);
            SessionMessages.add((PortletRequest)actionRequest, PortalUtil.getPortletId((PortletRequest)actionRequest) + ".updatedConfiguration");
            String redirect = PortalUtil.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, "redirect"));
            if (Validator.isNotNull(redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
    }

    @Override
    public void serveResource(PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
    }

    public void setPreference(PortletRequest portletRequest, String name, String value) {
        this.setPreference(portletRequest, name, new String[]{value});
    }

    public void setPreference(PortletRequest portletRequest, String name, String[] values) {
        HashMap<String, String[]> portletPreferencesMap = (HashMap<String, String[]>)portletRequest.getAttribute("PORTLET_PREFERENCES_MAP");
        if (portletPreferencesMap == null) {
            portletPreferencesMap = new HashMap<String, String[]>();
            portletRequest.setAttribute("PORTLET_PREFERENCES_MAP", portletPreferencesMap);
        }
        portletPreferencesMap.put(name, values);
    }

    protected PortletConfig getSelPortletConfig(HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletResource = ParamUtil.getString(request, "portletResource");
        Portlet selPortlet = PortletLocalServiceUtil.getPortletById(themeDisplay.getCompanyId(), portletResource);
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        PortletConfig selPortletConfig = PortletConfigFactoryUtil.create(selPortlet, servletContext);
        return selPortletConfig;
    }

    protected Settings getSettings(ActionRequest actionRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String serviceName = ParamUtil.getString((PortletRequest)actionRequest, "serviceName");
        String settingsScope = ParamUtil.getString((PortletRequest)actionRequest, "settingsScope");
        if (settingsScope.equals("company")) {
            return SettingsFactoryUtil.getSettings(new CompanyServiceSettingsLocator(themeDisplay.getCompanyId(), serviceName));
        }
        if (settingsScope.equals("group")) {
            return SettingsFactoryUtil.getSettings(new GroupServiceSettingsLocator(themeDisplay.getSiteGroupId(), serviceName));
        }
        if (settingsScope.equals("portletInstance")) {
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, "portletResource");
            return SettingsFactoryUtil.getSettings(new PortletInstanceSettingsLocator(themeDisplay.getLayout(), portletResource));
        }
        throw new IllegalArgumentException("Invalid settings scope " + settingsScope);
    }

    protected String getSettingsId(ActionRequest actionRequest) {
        String settingsId = ParamUtil.getString((PortletRequest)actionRequest, "serviceName");
        String settingsScope = ParamUtil.getString((PortletRequest)actionRequest, "settingsScope");
        if (settingsScope.equals("portletInstance")) {
            settingsId = ParamUtil.getString((PortletRequest)actionRequest, "portletResource");
        }
        return settingsId;
    }

    protected void postProcess(long companyId, PortletRequest portletRequest, Settings settings) throws PortalException {
    }

    protected void setParameterNamePrefix(String parameterNamePrefix) {
        this._parameterNamePrefix = parameterNamePrefix;
    }

    protected void updateMultiValuedKeys(ActionRequest actionRequest) {
        String settingsId = this.getSettingsId(actionRequest);
        SettingsDescriptor settingsDescriptor = SettingsFactoryUtil.getSettingsDescriptor(settingsId);
        Set<String> multiValuedKeys = settingsDescriptor.getMultiValuedKeys();
        for (String multiValuedKey : multiValuedKeys) {
            String multiValuedValue = this.getParameter((PortletRequest)actionRequest, multiValuedKey);
            if (multiValuedValue == null) continue;
            this.setPreference((PortletRequest)actionRequest, multiValuedKey, StringUtil.split(multiValuedValue));
        }
    }

    protected void validateEmail(ActionRequest actionRequest, String emailParam) {
        boolean emailEnabled = GetterUtil.getBoolean(this.getParameter((PortletRequest)actionRequest, emailParam + "Enabled"));
        String emailSubject = null;
        String emailBody = null;
        String languageId = LocaleUtil.toLanguageId(LocaleUtil.getSiteDefault());
        emailSubject = this.getLocalizedParameter((PortletRequest)actionRequest, emailParam + "Subject", languageId);
        emailBody = this.getLocalizedParameter((PortletRequest)actionRequest, emailParam + "Body", languageId);
        if (emailEnabled) {
            if (Validator.isNull(emailSubject)) {
                SessionErrors.add((PortletRequest)actionRequest, emailParam + "Subject");
            } else if (Validator.isNull(emailBody)) {
                SessionErrors.add((PortletRequest)actionRequest, emailParam + "Body");
            }
        }
    }

    protected void validateEmailFrom(ActionRequest actionRequest) {
        String emailFromName = this.getParameter((PortletRequest)actionRequest, "emailFromName");
        String emailFromAddress = this.getParameter((PortletRequest)actionRequest, "emailFromAddress");
        if (Validator.isNull(emailFromName)) {
            SessionErrors.add((PortletRequest)actionRequest, "emailFromName");
        } else if (!Validator.isEmailAddress(emailFromAddress) && !Validator.isVariableTerm(emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, "emailFromAddress");
        }
    }
}

