/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.messaging;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.messaging.Message;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class MessageRoutingBag
implements Externalizable {
    public static final String MESSAGE_ROUTING_BAG = "MESSAGE_ROUTING_BAG";
    private String _destinationName;
    private Message _message;
    private byte[] _messageData;
    private boolean _routingDowncast;
    private ArrayList<String> _routingTrace = new ArrayList();
    private boolean _synchronizedBridge;

    public static MessageRoutingBag fromByteArray(byte[] data) throws ClassNotFoundException {
        MessageRoutingBag messageRoutingBag = new MessageRoutingBag();
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(data));
        messageRoutingBag._destinationName = deserializer.readString();
        messageRoutingBag._messageData = (byte[])deserializer.readObject();
        messageRoutingBag._routingDowncast = deserializer.readBoolean();
        messageRoutingBag._routingTrace = (ArrayList)deserializer.readObject();
        messageRoutingBag._synchronizedBridge = deserializer.readBoolean();
        return messageRoutingBag;
    }

    public MessageRoutingBag() {
    }

    public MessageRoutingBag(Message message, boolean synchronizedBridge) {
        this._destinationName = message.getDestinationName();
        this._message = message;
        this._synchronizedBridge = synchronizedBridge;
    }

    public void appendRoutingId(String routingId) {
        this._routingTrace.add(routingId);
    }

    public String getDestinationName() {
        return this._destinationName;
    }

    public Message getMessage() throws ClassNotFoundException {
        if (this._message == null) {
            this._message = Message.fromByteArray(this._messageData);
            this._message.put(MESSAGE_ROUTING_BAG, this);
            this._messageData = null;
        }
        return this._message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMessageData() {
        if (this._messageData == null) {
            this._message.remove(MESSAGE_ROUTING_BAG);
            try {
                this._messageData = this._message.toByteArray();
            }
            finally {
                this._message.put(MESSAGE_ROUTING_BAG, this);
                this._message = null;
            }
        }
        return this._messageData;
    }

    public boolean isRoutingDowncast() {
        return this._routingDowncast;
    }

    public boolean isSynchronizedBridge() {
        return this._synchronizedBridge;
    }

    public boolean isVisited(String routingId) {
        return this._routingTrace.contains(routingId);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._destinationName = objectInput.readUTF();
        this._messageData = (byte[])objectInput.readObject();
        this._routingDowncast = objectInput.readBoolean();
        this._routingTrace = (ArrayList)objectInput.readObject();
        this._synchronizedBridge = objectInput.readBoolean();
    }

    public void setMessage(Message message) {
        this._message = message;
        message.put(MESSAGE_ROUTING_BAG, this);
    }

    public void setRoutingDowncast(boolean routingDowncast) {
        this._routingDowncast = routingDowncast;
    }

    public byte[] toByteArray() {
        Serializer serializer = new Serializer();
        serializer.writeString(this._destinationName);
        serializer.writeObject((Serializable)this.getMessageData());
        serializer.writeBoolean(this._routingDowncast);
        serializer.writeObject(this._routingTrace);
        serializer.writeBoolean(this._synchronizedBridge);
        ByteBuffer byteBuffer = serializer.toByteBuffer();
        return byteBuffer.array();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this._destinationName);
        objectOutput.writeObject(this.getMessageData());
        objectOutput.writeBoolean(this._routingDowncast);
        objectOutput.writeObject(this._routingTrace);
        objectOutput.writeBoolean(this._synchronizedBridge);
    }
}

