/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSenderFactoryUtil;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.security.pacl.permission.PortalMessageBusPermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;

public class MessageBusUtil {
    private static final Log _log = LogFactoryUtil.getLog(MessageBusUtil.class);
    private static final MessageBusUtil _instance = new MessageBusUtil();
    private static SynchronousMessageSender.Mode _synchronousMessageSenderMode;
    private volatile boolean _initialized;
    private final MessageBus _messageBus = ProxyFactory.newServiceTrackedInstance(MessageBus.class);
    private final ServiceTracker<MessageBus, MessageBus> _serviceTracker;

    public static void addDestination(Destination destination) {
        MessageBusUtil.getInstance()._addDestination(destination);
    }

    public static Message createResponseMessage(Message requestMessage) {
        Message responseMessage = new Message();
        responseMessage.setDestinationName(requestMessage.getResponseDestinationName());
        responseMessage.setResponseId(requestMessage.getResponseId());
        return responseMessage;
    }

    public static Message createResponseMessage(Message requestMessage, Object payload) {
        Message responseMessage = MessageBusUtil.createResponseMessage(requestMessage);
        responseMessage.setPayload(payload);
        return responseMessage;
    }

    public static Destination getDestination(String destinationName) {
        return MessageBusUtil.getInstance()._getDestination(destinationName);
    }

    public static MessageBusUtil getInstance() {
        PortalRuntimePermission.checkGetBeanProperty(MessageBusUtil.class);
        return _instance;
    }

    public static MessageBus getMessageBus() {
        return _instance._getMessageBus();
    }

    public static boolean hasMessageListener(String destination) {
        return MessageBusUtil.getInstance()._hasMessageListener(destination);
    }

    public static void registerMessageListener(String destinationName, MessageListener messageListener) {
        MessageBusUtil.getInstance()._registerMessageListener(destinationName, messageListener);
    }

    public static void removeDestination(String destinationName) {
        MessageBusUtil.getInstance()._removeDestination(destinationName);
    }

    public static void sendMessage(String destinationName, Message message) {
        MessageBusUtil.getInstance()._sendMessage(destinationName, message);
    }

    public static void sendMessage(String destinationName, Object payload) {
        MessageBusUtil.getInstance()._sendMessage(destinationName, payload);
    }

    public static Object sendSynchronousMessage(String destinationName, Message message) throws MessageBusException {
        return MessageBusUtil.getInstance()._sendSynchronousMessage(destinationName, message);
    }

    public static Object sendSynchronousMessage(String destinationName, Message message, long timeout) throws MessageBusException {
        return MessageBusUtil.getInstance()._sendSynchronousMessage(destinationName, message, timeout);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload) throws MessageBusException {
        return MessageBusUtil.getInstance()._sendSynchronousMessage(destinationName, payload, null);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload, long timeout) throws MessageBusException {
        return MessageBusUtil.getInstance()._sendSynchronousMessage(destinationName, payload, null, timeout);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName) throws MessageBusException {
        return MessageBusUtil.getInstance()._sendSynchronousMessage(destinationName, payload, responseDestinationName);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName, long timeout) throws MessageBusException {
        return MessageBusUtil.getInstance()._sendSynchronousMessage(destinationName, payload, responseDestinationName, timeout);
    }

    public static void shutdown() {
        MessageBusUtil.getInstance()._shutdown();
    }

    public static void shutdown(boolean force) {
        MessageBusUtil.getInstance()._shutdown(force);
    }

    public static boolean unregisterMessageListener(String destinationName, MessageListener messageListener) {
        PortalMessageBusPermission.checkListen(destinationName);
        return MessageBusUtil.getInstance()._unregisterMessageListener(destinationName, messageListener);
    }

    public MessageBusUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(MessageBus.class, (ServiceTrackerCustomizer)new MessageBusServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void setSynchronousMessageSenderMode(SynchronousMessageSender.Mode synchronousMessageSenderMode) {
        _synchronousMessageSenderMode = synchronousMessageSenderMode;
    }

    private void _addDestination(Destination destination) {
        this._getMessageBus().addDestination(destination);
    }

    private Destination _getDestination(String destinationName) {
        return this._getMessageBus().getDestination(destinationName);
    }

    private MessageBus _getMessageBus() {
        try {
            while (!this._initialized && this._serviceTracker.getService() == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Waiting for a PortalExecutorManager");
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException("Unable to initialize MessageBusUtil", ie);
        }
        return this._messageBus;
    }

    private boolean _hasMessageListener(String destinationName) {
        return this._getMessageBus().hasMessageListener(destinationName);
    }

    private void _registerMessageListener(String destinationName, MessageListener messageListener) {
        PortalMessageBusPermission.checkListen(destinationName);
        this._getMessageBus().registerMessageListener(destinationName, messageListener);
    }

    private void _removeDestination(String destinationName) {
        this._getMessageBus().removeDestination(destinationName);
    }

    private void _sendMessage(String destinationName, Message message) {
        PortalMessageBusPermission.checkSend(destinationName);
        this._getMessageBus().sendMessage(destinationName, message);
    }

    private void _sendMessage(String destinationName, Object payload) {
        PortalMessageBusPermission.checkSend(destinationName);
        Message message = new Message();
        message.setPayload(payload);
        this._sendMessage(destinationName, message);
    }

    private Object _sendSynchronousMessage(String destinationName, Message message) throws MessageBusException {
        PortalMessageBusPermission.checkSend(destinationName);
        SynchronousMessageSender synchronousMessageSender = SingleDestinationMessageSenderFactoryUtil.getSynchronousMessageSender(_synchronousMessageSenderMode);
        return synchronousMessageSender.send(destinationName, message);
    }

    private Object _sendSynchronousMessage(String destinationName, Message message, long timeout) throws MessageBusException {
        PortalMessageBusPermission.checkSend(destinationName);
        SynchronousMessageSender synchronousMessageSender = SingleDestinationMessageSenderFactoryUtil.getSynchronousMessageSender(_synchronousMessageSenderMode);
        return synchronousMessageSender.send(destinationName, message, timeout);
    }

    private Object _sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName) throws MessageBusException {
        PortalMessageBusPermission.checkSend(destinationName);
        Message message = new Message();
        message.setResponseDestinationName(responseDestinationName);
        message.setPayload(payload);
        return this._sendSynchronousMessage(destinationName, message);
    }

    private Object _sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName, long timeout) throws MessageBusException {
        PortalMessageBusPermission.checkSend(destinationName);
        Message message = new Message();
        message.setResponseDestinationName(responseDestinationName);
        message.setPayload(payload);
        return this._sendSynchronousMessage(destinationName, message, timeout);
    }

    private void _shutdown() {
        PortalRuntimePermission.checkGetBeanProperty(MessageBusUtil.class);
        this._getMessageBus().shutdown();
    }

    private void _shutdown(boolean force) {
        PortalRuntimePermission.checkGetBeanProperty(MessageBusUtil.class);
        this._getMessageBus().shutdown(force);
    }

    private boolean _unregisterMessageListener(String destinationName, MessageListener messageListener) {
        return this._getMessageBus().unregisterMessageListener(destinationName, messageListener);
    }

    private class MessageBusServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<MessageBus, MessageBus> {
        private MessageBusServiceTrackerCustomizer() {
        }

        public MessageBus addingService(ServiceReference<MessageBus> serviceReference) {
            MessageBusUtil.this._initialized = true;
            return null;
        }

        public void modifiedService(ServiceReference<MessageBus> serviceReference, MessageBus messageBus) {
        }

        public void removedService(ServiceReference<MessageBus> serviceReference, MessageBus service) {
        }
    }
}

