/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import java.util.Collection;

public class DestinationFactoryUtil {
    private static final DestinationFactoryUtil _instance = new DestinationFactoryUtil();
    private final ServiceTracker<DestinationFactory, DestinationFactory> _serviceTracker;

    public static Destination createDestination(DestinationConfiguration destinationConfiguration) {
        return _instance.getDestinationFactory().createDestination(destinationConfiguration);
    }

    public static Collection<String> getDestinationTypes() {
        return _instance.getDestinationFactory().getDestinationTypes();
    }

    protected DestinationFactory getDestinationFactory() {
        try {
            while (this._serviceTracker.getService() == null) {
                Thread.sleep(500L);
            }
            return (DestinationFactory)this._serviceTracker.getService();
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException("Unable to obtain reference for destination factory", ie);
        }
    }

    private DestinationFactoryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(DestinationFactory.class);
        this._serviceTracker.open();
    }
}

