/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployScanner;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class AutoDeployDir {
    public static final String DEFAULT_NAME = "defaultAutoDeployDir";
    private static final Log _log = LogFactoryUtil.getLog(AutoDeployDir.class);
    private static AutoDeployScanner _autoDeployScanner;
    private static final ServiceTracker<AutoDeployListener, AutoDeployListener> _serviceTracker;
    private final List<AutoDeployListener> _autoDeployListeners;
    private final Map<String, Long> _blacklistFileTimestamps;
    private final File _deployDir;
    private final File _destDir;
    private final long _interval;
    private final String _name;

    public static void deploy(AutoDeploymentContext autoDeploymentContext, List<AutoDeployListener> autoDeployListeners) throws AutoDeployException {
        AutoDeployListener autoDeployListener = (AutoDeployListener)_serviceTracker.getService();
        if (autoDeployListener != null && autoDeployListener.isDeployable(autoDeploymentContext)) {
            autoDeployListener.deploy(autoDeploymentContext);
            File file = autoDeploymentContext.getFile();
            file.delete();
            return;
        }
        Object[] dirNames = PropsUtil.getArray("module.framework.auto.deploy.dirs");
        if (ArrayUtil.isEmpty(dirNames)) {
            throw new AutoDeployException("The portal property \"module.framework.auto.deploy.dirs\" is not set");
        }
        Object dirName = dirNames[0];
        File file = autoDeploymentContext.getFile();
        String fileName = file.getName();
        if (StringUtil.endsWith(fileName, ".cfg")) {
            for (Object curDirName : dirNames) {
                if (!((String)curDirName).endsWith("/configs")) continue;
                dirName = curDirName;
                break;
            }
        } else if (StringUtil.endsWith(fileName, ".lpkg")) {
            for (Object curDirName : dirNames) {
                if (!((String)curDirName).endsWith("/marketplace")) continue;
                dirName = curDirName;
                break;
            }
        } else if (StringUtil.endsWith(fileName, ".war")) {
            for (Object curDirName : dirNames) {
                if (!((String)curDirName).endsWith("/war")) continue;
                dirName = curDirName;
                break;
            }
        } else {
            for (Object curDirName : dirNames) {
                if (!((String)curDirName).endsWith("/modules")) continue;
                dirName = curDirName;
                break;
            }
        }
        FileUtil.move(file, new File((String)dirName, fileName));
    }

    public AutoDeployDir(String name, File deployDir, File destDir, long interval, List<AutoDeployListener> autoDeployListeners) {
        this._name = name;
        this._deployDir = deployDir;
        this._destDir = destDir;
        this._interval = interval;
        this._autoDeployListeners = new CopyOnWriteArrayList<AutoDeployListener>(autoDeployListeners);
        this._blacklistFileTimestamps = new HashMap<String, Long>();
    }

    public File getDeployDir() {
        return this._deployDir;
    }

    public File getDestDir() {
        return this._destDir;
    }

    public long getInterval() {
        return this._interval;
    }

    public List<AutoDeployListener> getListeners() {
        return this._autoDeployListeners;
    }

    public String getName() {
        return this._name;
    }

    public void registerListener(AutoDeployListener listener) {
        this._autoDeployListeners.add(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (!this._deployDir.exists()) {
            boolean created;
            if (_log.isInfoEnabled()) {
                _log.info("Creating missing directory " + this._deployDir);
            }
            if (!(created = this._deployDir.mkdirs())) {
                _log.error("Directory " + this._deployDir + " could not be created");
            }
        }
        if (!(this._interval <= 0L || _autoDeployScanner != null && _autoDeployScanner.isAlive())) {
            try {
                this.scanDirectory();
                Thread currentThread = Thread.currentThread();
                _autoDeployScanner = new AutoDeployScanner(currentThread.getThreadGroup(), AutoDeployScanner.class.getName(), this);
                _autoDeployScanner.start();
                if (!_log.isInfoEnabled()) return;
                _log.info("Auto deploy scanner started for " + this._deployDir);
                return;
            }
            catch (Exception e) {
                _log.error(e, e);
                this.stop();
                return;
            }
        } else {
            if (!_log.isInfoEnabled()) return;
            _log.info("Auto deploy scanning is disabled for " + this._deployDir);
        }
    }

    public void stop() {
        if (_autoDeployScanner != null) {
            _autoDeployScanner.pause();
        }
        _serviceTracker.close();
    }

    public void unregisterListener(AutoDeployListener autoDeployListener) {
        this._autoDeployListeners.remove(autoDeployListener);
    }

    protected AutoDeploymentContext buildAutoDeploymentContext(File file) {
        AutoDeploymentContext autoDeploymentContext = new AutoDeploymentContext();
        autoDeploymentContext.setFile(file);
        return autoDeploymentContext;
    }

    protected void processFile(File file) {
        String fileName = file.getName();
        if (!file.canRead()) {
            _log.error("Unable to read " + fileName);
            return;
        }
        if (!file.canWrite()) {
            _log.error("Unable to write " + fileName);
            return;
        }
        if (this._blacklistFileTimestamps.containsKey(fileName) && this._blacklistFileTimestamps.get(fileName).longValue() == file.lastModified()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Skip processing of " + fileName + " because it is " + "blacklisted");
            }
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("Processing " + fileName);
        }
        try {
            AutoDeploymentContext autoDeploymentContext = this.buildAutoDeploymentContext(file);
            AutoDeployDir.deploy(autoDeploymentContext, this._autoDeployListeners);
            return;
        }
        catch (Exception e) {
            _log.error(e, e);
            if (_log.isInfoEnabled()) {
                _log.info("Add " + fileName + " to the blacklist");
            }
            this._blacklistFileTimestamps.put(fileName, file.lastModified());
            return;
        }
    }

    protected void scanDirectory() {
        File[] files = this._deployDir.listFiles();
        if (files == null) {
            return;
        }
        Set<String> blacklistedFileNames = this._blacklistFileTimestamps.keySet();
        Iterator<String> iterator = blacklistedFileNames.iterator();
        while (iterator.hasNext()) {
            String blacklistedFileName = iterator.next();
            boolean blacklistedFileExists = false;
            for (File file : files) {
                if (!StringUtil.equalsIgnoreCase(blacklistedFileName, file.getName())) continue;
                blacklistedFileExists = true;
            }
            if (blacklistedFileExists) continue;
            if (_log.isDebugEnabled()) {
                _log.debug("Remove blacklisted file " + blacklistedFileName + " because it was deleted");
            }
            iterator.remove();
        }
        for (File file : files) {
            String fileName = file.getName();
            fileName = StringUtil.toLowerCase(fileName);
            if (!file.isFile() || !fileName.endsWith(".jar") && !fileName.endsWith(".lpkg") && !fileName.endsWith(".war") && !fileName.endsWith(".xml") && !fileName.endsWith(".zip")) continue;
            this.processFile(file);
        }
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(AutoDeployListener.class);
        _serviceTracker.open();
    }
}

