/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManager;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import javax.sql.DataSource;

public class DBManagerUtil {
    private static DBManager _dbManager;

    public static DB getDB() {
        return DBManagerUtil.getDBManager().getDB();
    }

    public static DB getDB(DBType dbType, DataSource dataSource) {
        return DBManagerUtil.getDBManager().getDB(dbType, dataSource);
    }

    public static DB getDB(Object dialect, DataSource dataSource) {
        DBManager dbManager = DBManagerUtil.getDBManager();
        return dbManager.getDB(dbManager.getDBType(dialect), dataSource);
    }

    public static DBManager getDBManager() {
        PortalRuntimePermission.checkGetBeanProperty(DBManagerUtil.class);
        return _dbManager;
    }

    public static DBType getDBType(Object dialect) {
        return DBManagerUtil.getDBManager().getDBType(dialect);
    }

    public static void reset() {
        DBManagerUtil.setDBManager(null);
    }

    public static void setDB(DBType dbType, DataSource dataSource) {
        DBManager dbManager = DBManagerUtil.getDBManager();
        dbManager.setDB(dbManager.getDB(dbType, dataSource));
    }

    public static void setDB(Object dialect, DataSource dataSource) {
        DBManager dbManager = DBManagerUtil.getDBManager();
        dbManager.setDB(dbManager.getDB(dbManager.getDBType(dialect), dataSource));
    }

    public static void setDBManager(DBManager dbManager) {
        PortalRuntimePermission.checkSetBeanProperty(DBManagerUtil.class);
        _dbManager = dbManager;
    }
}

