/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;

public abstract class BaseDBProcess
implements DBProcess {
    protected Connection connection;

    @Override
    public void runSQL(Connection connection, String template) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        db.runSQL(connection, template);
    }

    @Override
    public void runSQL(String template) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(template);
        } else {
            db.runSQL(this.connection, template);
        }
    }

    @Override
    public void runSQL(String[] templates) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(templates);
        } else {
            db.runSQL(this.connection, templates);
        }
    }

    @Override
    public void runSQLTemplate(String path) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer(path);){
            DB db = DBManagerUtil.getDB();
            db.runSQLTemplate(path);
        }
    }

    @Override
    public void runSQLTemplate(String path, boolean failOnError) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer(path);){
            DB db = DBManagerUtil.getDB();
            db.runSQLTemplate(path, failOnError);
        }
    }

    @Override
    public void runSQLTemplateString(String template, boolean evaluate, boolean failOnError) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DB db = DBManagerUtil.getDB();
            if (this.connection == null) {
                db.runSQLTemplateString(template, evaluate, failOnError);
            } else {
                db.runSQLTemplateString(this.connection, template, evaluate, failOnError);
            }
        }
    }

    protected boolean doHasTable(String tableName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasTable(tableName, true);
    }

    protected boolean hasColumn(String tableName, String columnName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasColumn(tableName, columnName);
    }

    protected boolean hasColumnType(Class<?> tableClass, String columnName, String columnType) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasColumnType(tableClass, columnName, columnType);
    }

    protected boolean hasRows(Connection connection, String tableName) {
        DBInspector dbInspector = new DBInspector(connection);
        return dbInspector.hasRows(tableName);
    }

    protected boolean hasRows(String tableName) throws Exception {
        return this.hasRows(this.connection, tableName);
    }

    protected boolean hasTable(String tableName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasTable(tableName);
    }
}

