/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.ProxyFactory;

public class ClusterLinkUtil {
    private static final String _ADDRESS = "CLUSTER_ADDRESS";
    private static final Log _log = LogFactoryUtil.getLog(ClusterLinkUtil.class);
    private static final ClusterLink _clusterLink = ProxyFactory.newServiceTrackedInstance(ClusterLink.class);

    public static Address getAddress(Message message) {
        return (Address)message.get(_ADDRESS);
    }

    public static ClusterLink getClusterLink() {
        PortalRuntimePermission.checkGetBeanProperty(ClusterLinkUtil.class);
        if (_clusterLink == null || !_clusterLink.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterLinkUtil is not initialized");
            }
            return null;
        }
        return _clusterLink;
    }

    public static void sendMulticastMessage(Message message, Priority priority) {
        ClusterLink clusterLink = ClusterLinkUtil.getClusterLink();
        if (clusterLink == null) {
            return;
        }
        clusterLink.sendMulticastMessage(message, priority);
    }

    public static void sendMulticastMessage(Object payload, Priority priority) {
        Message message = new Message();
        message.setPayload(payload);
        ClusterLinkUtil.sendMulticastMessage(message, priority);
    }

    public static void sendUnicastMessage(Address address, Message message, Priority priority) {
        ClusterLink clusterLink = ClusterLinkUtil.getClusterLink();
        if (clusterLink == null) {
            return;
        }
        clusterLink.sendUnicastMessage(address, message, priority);
    }

    public static Message setAddress(Message message, Address address) {
        message.put(_ADDRESS, address);
        return message;
    }
}

