/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.staging;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.HashUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MergeLayoutPrototypesThreadLocal {
    private static final ThreadLocal<Boolean> _inProgress = new AutoResetThreadLocal<Boolean>(MergeLayoutPrototypesThreadLocal.class + "._inProgress", false);
    private static final ThreadLocal<Set<MethodKey>> _mergeComplete = new AutoResetThreadLocal(MergeLayoutPrototypesThreadLocal.class + "._mergeComplete", new HashSet());

    public static void clearMergeComplete() {
        _mergeComplete.remove();
    }

    public static boolean isInProgress() {
        return _inProgress.get();
    }

    public static boolean isMergeComplete(Method method, Object[] arguments) {
        Set<MethodKey> methodKeys = _mergeComplete.get();
        return methodKeys.contains(new MethodKey(method, arguments));
    }

    public static void setInProgress(boolean inProgress) {
        _inProgress.set(inProgress);
    }

    public static void setMergeComplete(Method method, Object[] arguments) {
        Set<MethodKey> methodKeys = _mergeComplete.get();
        methodKeys.add(new MethodKey(method, arguments));
        MergeLayoutPrototypesThreadLocal.setInProgress(false);
    }

    private static class MethodKey {
        private final Object[] _arguments;
        private final Method _method;

        public MethodKey(Method method, Object[] arguments) {
            this._method = method;
            this._arguments = arguments;
        }

        public boolean equals(Object obj) {
            MethodKey methodKey = (MethodKey)obj;
            return Objects.equals(this._method, methodKey._method) && Arrays.equals(this._arguments, methodKey._arguments);
        }

        public int hashCode() {
            int hashCode = this._method.hashCode();
            if (this._arguments != null) {
                for (Object obj : this._arguments) {
                    hashCode = obj == null ? HashUtil.hash(hashCode, 0) : HashUtil.hash(hashCode, obj.hashCode());
                }
            }
            return hashCode;
        }
    }
}

