/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.webdav.methods.MethodFactory;
import com.liferay.portal.kernel.webdav.methods.MethodFactoryRegistry;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodFactoryRegistryImpl
implements MethodFactoryRegistry {
    private static final Log _log = LogFactoryUtil.getLog(MethodFactoryRegistryImpl.class);
    private MethodFactory _defaultMethodFactory;
    private final Map<String, MethodFactory> _methodFactories = new ConcurrentHashMap<String, MethodFactory>();

    public MethodFactory getDefaultMethodFactory() {
        return this._defaultMethodFactory;
    }

    public List<MethodFactory> getMethodFactories() {
        return ListUtil.fromMapValues(this._methodFactories);
    }

    public MethodFactory getMethodFactory(String className) {
        return this._methodFactories.get(className);
    }

    public void registerMethodFactory(MethodFactory methodFactory) {
        Class<?> clazz = methodFactory.getClass();
        MethodFactory previousMethodFactory = this._methodFactories.put(clazz.getName(), methodFactory);
        if (previousMethodFactory == this._defaultMethodFactory) {
            this._defaultMethodFactory = methodFactory;
        }
        if (_log.isWarnEnabled() && previousMethodFactory != null) {
            _log.warn((Object)("Replacing " + previousMethodFactory + " for class name " + clazz.getName() + " with " + methodFactory));
        }
    }

    public void setDefaultMethodFactory(MethodFactory defaultMethodFactory) {
        this._defaultMethodFactory = defaultMethodFactory;
    }

    public void unregisterMethodFactory(MethodFactory methodFactory) {
        Class<?> clazz = methodFactory.getClass();
        this._methodFactories.remove(clazz.getName());
    }
}

