/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import javax.servlet.http.HttpServletRequest;

public class CopyMethodImpl
implements Method {
    private static final Log _log = LogFactoryUtil.getLog(CopyMethodImpl.class);

    public int process(WebDAVRequest webDAVRequest) throws WebDAVException {
        WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
        HttpServletRequest request = webDAVRequest.getHttpServletRequest();
        long companyId = webDAVRequest.getCompanyId();
        String destination = WebDAVUtil.getDestination((HttpServletRequest)request, (String)storage.getRootPath());
        StringBundler sb = null;
        if (_log.isInfoEnabled()) {
            sb = new StringBundler(6);
            sb.append("Destination is ");
            sb.append(destination);
        }
        if (!destination.equals(webDAVRequest.getPath()) && WebDAVUtil.getGroupId((long)companyId, (String)destination) == webDAVRequest.getGroupId()) {
            Resource resource = storage.getResource(webDAVRequest);
            if (resource == null) {
                return 404;
            }
            if (resource.isCollection()) {
                boolean overwrite = WebDAVUtil.isOverwrite((HttpServletRequest)request);
                long depth = WebDAVUtil.getDepth((HttpServletRequest)request);
                if (_log.isInfoEnabled()) {
                    sb.append(", overwrite is ");
                    sb.append(overwrite);
                    sb.append(", depth is ");
                    sb.append(depth);
                    _log.info((Object)sb.toString());
                }
                return storage.copyCollectionResource(webDAVRequest, resource, destination, overwrite, depth);
            }
            boolean overwrite = WebDAVUtil.isOverwrite((HttpServletRequest)request);
            if (_log.isInfoEnabled()) {
                sb.append(", overwrite is ");
                sb.append(overwrite);
                _log.info((Object)sb.toString());
            }
            return storage.copySimpleResource(webDAVRequest, resource, destination, overwrite);
        }
        return 403;
    }
}

