/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class VerifyAsset
extends VerifyProcess {
    protected void deleteOrphanedAssetEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long classNameId = PortalUtil.getClassNameId((String)DLFileEntryConstants.getClassName());
            StringBundler sb = new StringBundler(5);
            sb.append("select classPK, entryId from AssetEntry where ");
            sb.append("classNameId = ");
            sb.append(classNameId);
            sb.append(" and classPK not in (select fileVersionId from ");
            sb.append("DLFileVersion)");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long classPK = rs.getLong("classPK");
                    long entryId = rs.getLong("entryId");
                    DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchDLFileEntry((long)classPK);
                    if (dlFileEntry != null) continue;
                    AssetEntryLocalServiceUtil.deleteAssetEntry((long)entryId);
                }
            }
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteOrphanedAssetEntries();
        this.rebuildTree();
    }

    protected void rebuildTree() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select distinct groupId from AssetCategory where (leftCategoryId is null) or (rightCategoryId is null)");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                AssetCategoryLocalServiceUtil.rebuildTree((long)groupId, (boolean)true);
            }
        }
    }
}

