/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.UserBagFactory;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.UserBagImpl;
import com.liferay.portal.util.PropsValues;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class UserBagFactoryImpl
implements UserBagFactory {
    public UserBag create(long userId) throws PortalException {
        UserBag userBag = PermissionCacheUtil.getUserBag(userId);
        if (userBag != null) {
            return userBag;
        }
        try {
            List userGroups = GroupLocalServiceUtil.getUserGroups((long)userId, (boolean)true);
            Collection<Organization> userOrgs = this.getUserOrgs(userId);
            HashSet<Group> userOrgGroups = new HashSet<Group>(userOrgs.size());
            for (Organization organization : userOrgs) {
                userOrgGroups.add(organization.getGroup());
            }
            if (userGroups.isEmpty()) {
                long[] userRoleIds = UserLocalServiceUtil.getRolePrimaryKeys((long)userId);
                userBag = new UserBagImpl(userId, (Collection<Group>)userGroups, userOrgs, userOrgGroups, userRoleIds);
            } else {
                List userRoles = RoleLocalServiceUtil.getUserRelatedRoles((long)userId, (List)userGroups);
                userBag = new UserBagImpl(userId, (Collection<Group>)userGroups, userOrgs, userOrgGroups, userRoles);
            }
            PermissionCacheUtil.putUserBag(userId, userBag);
            return userBag;
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserBag(userId);
            throw e;
        }
    }

    protected Collection<Organization> getUserOrgs(long userId) throws PortalException {
        List userOrgs = OrganizationLocalServiceUtil.getUserOrganizations((long)userId);
        if (userOrgs.isEmpty()) {
            return Collections.emptyList();
        }
        if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) {
            return userOrgs;
        }
        LinkedHashSet<Organization> organizations = new LinkedHashSet<Organization>();
        for (Organization organization : userOrgs) {
            if (!organizations.add(organization)) continue;
            List ancestorOrganizations = OrganizationLocalServiceUtil.getParentOrganizations((long)organization.getOrganizationId());
            organizations.addAll(ancestorOrganizations);
        }
        return organizations;
    }
}

