/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.events.ShutdownHook;
import com.liferay.portal.fabric.server.FabricServerUtil;
import com.liferay.portal.jericho.CachedLoggerProvider;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.executor.PortalExecutorManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.nio.intraband.DatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.mailbox.MailboxDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.messaging.MessageDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.proxy.IntrabandProxyDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.rpc.RPCDatagramReceiveHandler;
import com.liferay.portal.kernel.patcher.PatcherUtil;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.DistributedRegistry;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.MatchType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.plugin.PluginPackageIndexer;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.util.MBMessageIndexer;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import com.liferay.taglib.servlet.JspFactorySwapper;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

public class StartupAction
extends SimpleAction {
    private static final Log _log = LogFactoryUtil.getLog(StartupAction.class);

    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(ids);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    protected void doRun(String[] ids) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("com/liferay/portal/events/dependencies/startup.txt");){
            System.out.println(IOUtils.toString((InputStream)inputStream));
        }
        System.out.println("Starting " + ReleaseInfo.getReleaseInfo() + "\n");
        if (_log.isInfoEnabled() && !PatcherUtil.hasInconsistentPatchLevels()) {
            String installedPatches = StringUtil.merge((Object[])PatcherUtil.getInstalledPatches(), (String)", ");
            if (Validator.isNull((String)installedPatches)) {
                _log.info((Object)"There are no patches installed");
            } else {
                _log.info((Object)("The following patches are installed: " + installedPatches));
            }
        }
        ServiceDependencyManager portalResiliencyServiceDependencyManager = new ServiceDependencyManager();
        portalResiliencyServiceDependencyManager.addServiceDependencyListener((ServiceDependencyListener)new PortalResiliencyServiceDependencyLister());
        portalResiliencyServiceDependencyManager.registerDependencies(new Class[]{MessageBus.class, PortalExecutorManager.class});
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Add shutdown hook");
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(new ShutdownHook()));
        ServiceDependencyManager indexerRegistryServiceDependencyManager = new ServiceDependencyManager();
        indexerRegistryServiceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            public void dependenciesFulfilled() {
                IndexerRegistryUtil.register((Indexer)new MBMessageIndexer());
                IndexerRegistryUtil.register((Indexer)new PluginPackageIndexer());
            }

            public void destroy() {
            }
        });
        indexerRegistryServiceDependencyManager.registerDependencies(new Class[]{IndexerRegistry.class});
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.MYSQL && GetterUtil.getFloat((String)db.getVersionString()) < 5.6f) {
            _log.error((Object)"Please upgrade to at least MySQL 5.6.4. The portal no longer supports older versions of MySQL.");
            System.exit(1);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check required build number");
        }
        DBUpgrader.checkRequiredBuildNumber(ReleaseInfo.getParentBuildNumber());
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("module.service.lifecycle", "database.initialized");
        properties.put("service.vendor", ReleaseInfo.getVendor());
        properties.put("service.version", ReleaseInfo.getVersion());
        final ServiceRegistration moduleServiceLifecycleServiceRegistration = registry.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, properties);
        PortalLifecycleUtil.register((PortalLifecycle)new BasePortalLifecycle(){

            protected void doPortalDestroy() {
                moduleServiceLifecycleServiceRegistration.unregister();
            }

            protected void doPortalInit() {
            }
        }, (int)1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check class names");
        }
        ClassNameLocalServiceUtil.checkClassNames();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check resource actions");
        }
        ResourceActionLocalServiceUtil.checkResourceActions();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Verify database");
        }
        DBUpgrader.verify();
        JspFactorySwapper.swap();
        CachedLoggerProvider.install();
    }

    private static class PortalResiliencyServiceDependencyLister
    implements ServiceDependencyListener {
        private PortalResiliencyServiceDependencyLister() {
        }

        public void dependenciesFulfilled() {
            Registry registry = RegistryUtil.getRegistry();
            MessageBus messageBus = (MessageBus)registry.getService(MessageBus.class);
            try {
                DistributedRegistry.registerDistributed((String)"org.apache.struts.taglib.tiles.CompContext", (Direction)Direction.DUPLEX, (MatchType)MatchType.POSTFIX);
                DistributedRegistry.registerDistributed((String)"javax.portlet.markup.head.element", (Direction)Direction.DUPLEX, (MatchType)MatchType.EXACT);
                DistributedRegistry.registerDistributed((String)"javax.portlet.lifecycle_phase", (Direction)Direction.DUPLEX, (MatchType)MatchType.EXACT);
                DistributedRegistry.registerDistributed(WebKeys.class);
                Intraband intraband = MPIHelperUtil.getIntraband();
                intraband.registerDatagramReceiveHandler(SystemDataType.MAILBOX.getValue(), (DatagramReceiveHandler)new MailboxDatagramReceiveHandler());
                intraband.registerDatagramReceiveHandler(SystemDataType.MESSAGE.getValue(), (DatagramReceiveHandler)new MessageDatagramReceiveHandler(messageBus));
                intraband.registerDatagramReceiveHandler(SystemDataType.PROXY.getValue(), (DatagramReceiveHandler)new IntrabandProxyDatagramReceiveHandler());
                intraband.registerDatagramReceiveHandler(SystemDataType.RPC.getValue(), (DatagramReceiveHandler)new RPCDatagramReceiveHandler());
                if (PropsValues.PORTAL_FABRIC_ENABLED) {
                    FabricServerUtil.start();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to initialize portal resiliency", e);
            }
        }

        public void destroy() {
        }
    }
}

