/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;

public abstract class BasePortalLifecycle
implements PortalLifecycle {
    private static final Log _log = LogFactoryUtil.getLog(BasePortalLifecycle.class);
    private boolean _calledPortalDestroy;

    @Override
    public void portalDestroy() {
        if (!this._calledPortalDestroy) {
            PortalLifecycleUtil.removeDestroy(this);
            try {
                this.doPortalDestroy();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            this._calledPortalDestroy = true;
        }
    }

    @Override
    public void portalInit() {
        try {
            this.doPortalInit();
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new IllegalStateException("Unable to initialize portal", e);
        }
    }

    public void registerPortalLifecycle() {
        PortalLifecycleUtil.register(this);
    }

    public void registerPortalLifecycle(int method) {
        PortalLifecycleUtil.register(this, method);
    }

    protected abstract void doPortalDestroy() throws Exception;

    protected abstract void doPortalInit() throws Exception;
}

