/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.trash;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.trash.BaseTrashRenderer;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseJSPTrashRenderer
extends BaseTrashRenderer {
    private static final Log _log = LogFactoryUtil.getLog(BaseJSPTrashRenderer.class);
    private ServletContext _servletContext;

    public abstract String getJspPath(HttpServletRequest var1, String var2);

    @Override
    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        ServletContext servletContext = this.getServletContext(request);
        String jspPath = this.getJspPath(request, template);
        if (Validator.isNull(jspPath)) {
            return false;
        }
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(jspPath);
        try {
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        catch (ServletException se) {
            _log.error("Unable to include JSP " + jspPath, se);
            throw new IOException("Unable to include " + jspPath, se);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected ServletContext getServletContext(HttpServletRequest request) {
        if (this._servletContext != null) {
            return this._servletContext;
        }
        return (ServletContext)request.getAttribute("CTX");
    }
}

