/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.spi.remote;

import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCUtil;
import com.liferay.portal.kernel.nio.intraband.welder.Welder;
import com.liferay.portal.kernel.nio.intraband.welder.WelderFactoryUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.local.LocalProcessLauncher;
import com.liferay.portal.kernel.process.log.ProcessOutputStream;
import com.liferay.portal.kernel.resiliency.mpi.MPI;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIConfiguration;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgentFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.provider.SPISynchronousQueueUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class RemoteSPI
implements ProcessCallable<SPI>,
Remote,
SPI {
    protected transient CountDownLatch countDownLatch;
    protected final MPI mpi;
    protected RegistrationReference registrationReference;
    protected volatile transient SPIAgent spiAgent;
    protected final SPIConfiguration spiConfiguration;
    protected final String uuid;
    protected final Welder welder;
    private static final Log _log = LogFactoryUtil.getLog(RemoteSPI.class);

    public RemoteSPI(SPIConfiguration spiConfiguration) {
        this.spiConfiguration = spiConfiguration;
        this.mpi = MPIHelperUtil.getMPI();
        UUID uuidObject = UUID.randomUUID();
        this.uuid = uuidObject.toString();
        this.welder = WelderFactoryUtil.createWelder();
    }

    @Override
    public SPI call() throws ProcessException {
        try {
            SPIShutdownHook spiShutdownHook = new SPIShutdownHook();
            LocalProcessLauncher.ProcessContext.attach(this.spiConfiguration.getSPIId(), this.spiConfiguration.getPingInterval(), spiShutdownHook);
            Runtime runtime = Runtime.getRuntime();
            runtime.addShutdownHook(spiShutdownHook);
            SPI spi = (SPI)UnicastRemoteObject.exportObject((Remote)this, 0);
            RegisterCallback registerCallback = new RegisterCallback(this.uuid, spi);
            ProcessOutputStream processOutputStream = LocalProcessLauncher.ProcessContext.getProcessOutputStream();
            processOutputStream.writeProcessCallable(registerCallback);
            this.registrationReference = this.welder.weld(MPIHelperUtil.getIntraband());
            ConcurrentMap<String, Object> attributes = LocalProcessLauncher.ProcessContext.getAttributes();
            attributes.put("SPI_INSTANCE_PUBLICATION_KEY", this);
            return spi;
        }
        catch (RemoteException re) {
            throw new ProcessException("Failed to export SPI as RMI stub.", re);
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws RemoteException {
        try {
            this.doDestroy();
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
        finally {
            UnicastRemoteObject.unexportObject(this, true);
        }
    }

    @Override
    public MPI getMPI() {
        return this.mpi;
    }

    @Override
    public RegistrationReference getRegistrationReference() {
        return this.registrationReference;
    }

    @Override
    public SPIAgent getSPIAgent() {
        if (this.spiAgent == null) {
            this.spiAgent = SPIAgentFactoryUtil.createSPIAgent(this.spiConfiguration, this.registrationReference);
        }
        return this.spiAgent;
    }

    @Override
    public SPIConfiguration getSPIConfiguration() {
        return this.spiConfiguration;
    }

    public String getUUID() {
        return this.uuid;
    }

    public Welder getWelder() {
        return this.welder;
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    protected abstract void doDestroy() throws RemoteException;

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        System.setProperty("intraband.impl", objectInputStream.readUTF());
        System.setProperty("intraband.timeout.default", objectInputStream.readUTF());
        System.setProperty("intraband.welder.impl", objectInputStream.readUTF());
        System.setProperty("portal:liferay.home", objectInputStream.readUTF());
        System.setProperty("portal:auto.deploy.enabled", "false");
        System.setProperty("portal:cluster.link.enabled", "false");
        System.setProperty("portal:hot.deploy.dependency.management.enabled", "false");
        System.setProperty("spi.id", "-" + this.spiConfiguration.getSPIId());
        this.countDownLatch = new CountDownLatch(1);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(System.getProperty("intraband.impl"));
        objectOutputStream.writeUTF(System.getProperty("intraband.timeout.default"));
        objectOutputStream.writeUTF(System.getProperty("intraband.welder.impl"));
        objectOutputStream.writeUTF(System.getProperty("liferay.home"));
    }

    protected class SPIShutdownHook
    extends Thread
    implements LocalProcessLauncher.ShutdownHook {
        public SPIShutdownHook() {
            this.setDaemon(true);
            this.setName(SPIShutdownHook.class.getSimpleName());
        }

        @Override
        public void run() {
            boolean unregistered;
            block4: {
                if (RemoteSPI.this.countDownLatch.getCount() == 0L) {
                    return;
                }
                unregistered = false;
                try {
                    NoticeableFuture<Boolean> future = IntrabandRPCUtil.execute(RemoteSPI.this.registrationReference, new UnregisterSPIProcessCallable(RemoteSPI.this.getSPIProviderName(), RemoteSPI.this.spiConfiguration.getSPIId()));
                    unregistered = (Boolean)future.get();
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn("Unable to unregister SPI from MPI", e);
                }
            }
            if (unregistered || !this._waitForMPI()) {
                this._doShutdown();
            }
        }

        @Override
        public boolean shutdown(int shutdownCode, Throwable shutdownThrowable) {
            Runtime runtime = Runtime.getRuntime();
            runtime.removeShutdownHook(this);
            this._doShutdown();
            return true;
        }

        private void _doShutdown() {
            try {
                RemoteSPI.this.stop();
            }
            catch (RemoteException re) {
                _log.error("Unable to stop SPI", re);
            }
            try {
                RemoteSPI.this.destroy();
            }
            catch (RemoteException re) {
                _log.error("Unable to destroy SPI", re);
            }
        }

        private boolean _waitForMPI() {
            if (_log.isInfoEnabled()) {
                _log.info("Wait up to " + RemoteSPI.this.spiConfiguration.getShutdownTimeout() + " ms for MPI shutdown request");
            }
            try {
                if (RemoteSPI.this.countDownLatch.await(RemoteSPI.this.spiConfiguration.getShutdownTimeout(), TimeUnit.MILLISECONDS)) {
                    if (_log.isInfoEnabled()) {
                        _log.info("MPI shutdown request received");
                    }
                    return true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (_log.isInfoEnabled()) {
                _log.info("Proceed with SPI shutdown");
            }
            return false;
        }
    }

    protected static class UnregisterSPIProcessCallable
    implements ProcessCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final String _spiId;
        private final String _spiProviderName;

        public UnregisterSPIProcessCallable(String spiProviderName, String spiId) {
            this._spiProviderName = spiProviderName;
            this._spiId = spiId;
        }

        @Override
        public Boolean call() {
            SPI spi = MPIHelperUtil.getSPI(this._spiProviderName, this._spiId);
            if (spi != null) {
                return MPIHelperUtil.unregisterSPI(spi);
            }
            return false;
        }
    }

    protected static class RegisterCallback
    implements ProcessCallable<SPI> {
        private static final long serialVersionUID = 1L;
        private final SPI _spi;
        private final String _spiUUID;

        public RegisterCallback(String spiUUID, SPI spi) {
            this._spiUUID = spiUUID;
            this._spi = spi;
        }

        @Override
        public SPI call() throws ProcessException {
            try {
                SPISynchronousQueueUtil.notifySynchronousQueue(this._spiUUID, this._spi);
            }
            catch (InterruptedException ie) {
                throw new ProcessException(ie);
            }
            return this._spi;
        }
    }
}

