/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.bridges.mvc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import com.liferay.registry.util.StringPlus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MVCCommandCache {
    private static final Log _log = LogFactoryUtil.getLog(MVCCommandCache.class);
    private static final List<Class<? extends MVCCommand>> _mvcCommandClasses = Arrays.asList(MVCActionCommand.class, MVCRenderCommand.class, MVCResourceCommand.class);
    private final MVCCommand _emptyMVCCommand;
    private final String _mvcComandPostFix;
    private final Map<String, MVCCommand> _mvcCommandCache = new ConcurrentHashMap<String, MVCCommand>();
    private final Map<String, List<String>> _mvcCommandKeys = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<MVCCommand>> _mvcCommands = new ConcurrentHashMap<String, List<MVCCommand>>();
    private final String _packagePrefix;
    private final ServiceTrackerMap<String, ? extends MVCCommand> _serviceTrackerMap;

    public MVCCommandCache(MVCCommand emptyMVCCommand, String packagePrefix, String portletName, Class<? extends MVCCommand> mvcCommandClass, String mvcCommandPostFix) {
        this._emptyMVCCommand = emptyMVCCommand;
        this._mvcComandPostFix = mvcCommandPostFix;
        if (Validator.isNotNull(packagePrefix) && !packagePrefix.endsWith(".")) {
            packagePrefix = packagePrefix + ".";
        }
        this._packagePrefix = packagePrefix;
        this._serviceTrackerMap = ServiceTrackerCollections.openSingleValueMap(mvcCommandClass, (String)("(&(javax.portlet.name=" + portletName + ")(mvc.command.name=*))"), (ServiceReferenceMapper)new ServiceReferenceMapper<String, MVCCommand>(){

            public void map(ServiceReference<MVCCommand> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
                List mvcCommandNames = StringPlus.asList((Object)serviceReference.getProperty("mvc.command.name"));
                for (String mvcCommandName : mvcCommandNames) {
                    emitter.emit((Object)mvcCommandName);
                }
            }
        });
    }

    @Deprecated
    public MVCCommandCache(MVCCommand emptyMVCCommand, String packagePrefix, String portletName, String mvcCommandClassName, String mvcCommandPostFix) {
        this(emptyMVCCommand, packagePrefix, portletName, MVCCommandCache._getMVCCommandClass(mvcCommandClassName), mvcCommandPostFix);
    }

    public void close() {
        this._serviceTrackerMap.close();
    }

    public MVCCommand getMVCCommand(String mvcCommandName) {
        String className = null;
        MVCCommand mvcCommand = (MVCCommand)this._serviceTrackerMap.getService((Object)mvcCommandName);
        if (mvcCommand != null) {
            return mvcCommand;
        }
        try {
            mvcCommand = this._mvcCommandCache.get(mvcCommandName);
            if (mvcCommand != null) {
                return mvcCommand;
            }
            if (Validator.isNull(this._packagePrefix)) {
                return this._emptyMVCCommand;
            }
            StringBundler sb = new StringBundler(4);
            sb.append(this._packagePrefix);
            sb.append(Character.toUpperCase(mvcCommandName.charAt(0)));
            sb.append(mvcCommandName.substring(1));
            sb.append(this._mvcComandPostFix);
            className = sb.toString();
            mvcCommand = (MVCCommand)InstanceFactory.newInstance(className);
            this._mvcCommandCache.put(mvcCommandName, mvcCommand);
            return mvcCommand;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to instantiate MVCCommand " + className);
            }
            this._mvcCommandCache.put(mvcCommandName, this._emptyMVCCommand);
            return this._emptyMVCCommand;
        }
    }

    public List<? extends MVCCommand> getMVCCommands(String key) {
        List<MVCCommand> mvcCommands = this._mvcCommands.get(key);
        String[] mvcCommandNames = StringUtil.split(key);
        if (mvcCommands != null && mvcCommands.size() == mvcCommandNames.length) {
            return mvcCommands;
        }
        mvcCommands = new ArrayList<MVCCommand>();
        for (String mvcCommandName : mvcCommandNames) {
            MVCCommand mvcCommand = this.getMVCCommand(mvcCommandName);
            if (mvcCommand != this._emptyMVCCommand) {
                mvcCommands.add(mvcCommand);
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn("Unable to find MVCCommand " + key);
        }
        this._mvcCommands.put(key, mvcCommands);
        for (MVCCommand mvcCommand : mvcCommands) {
            String mvcCommandClassName = ClassUtil.getClassName(mvcCommand);
            List<String> keys = this._mvcCommandKeys.get(mvcCommandClassName);
            if (keys == null) {
                keys = new ArrayList<String>();
                this._mvcCommandKeys.put(mvcCommandClassName, keys);
            }
            keys.add(key);
        }
        return mvcCommands;
    }

    public boolean isEmpty() {
        return this._mvcCommandCache.isEmpty();
    }

    private static Class<? extends MVCCommand> _getMVCCommandClass(String mvcCommandClassName) {
        Class<? extends MVCCommand> mvcCommandClass = null;
        for (Class<? extends MVCCommand> curMVCCommandClass : _mvcCommandClasses) {
            if (!mvcCommandClassName.equals(curMVCCommandClass.getName())) continue;
            mvcCommandClass = curMVCCommandClass;
            break;
        }
        if (mvcCommandClass == null) {
            throw new IllegalArgumentException();
        }
        return mvcCommandClass;
    }
}

