/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.comment;

import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.DiscussionStagingHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.ProxyFactory;

public class CommentManagerUtil {
    private static final CommentManager _commentManager = ProxyFactory.newServiceTrackedInstance(CommentManager.class);

    public static long addComment(long userId, long groupId, String className, long classPK, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil.getCommentManager().addComment(userId, groupId, className, classPK, body, serviceContextFunction);
    }

    public static long addComment(long userId, long groupId, String className, long classPK, String userName, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil.getCommentManager().addComment(userId, groupId, className, classPK, userName, subject, body, serviceContextFunction);
    }

    public static long addComment(long userId, String className, long classPK, String userName, long parentCommentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil.getCommentManager().addComment(userId, className, classPK, userName, parentCommentId, subject, body, serviceContextFunction);
    }

    public static void addDiscussion(long userId, long groupId, String className, long classPK, String userName) throws PortalException {
        CommentManagerUtil.getCommentManager().addDiscussion(userId, groupId, className, classPK, userName);
    }

    public static void deleteComment(long commentId) throws PortalException {
        CommentManagerUtil.getCommentManager().deleteComment(commentId);
    }

    public static void deleteDiscussion(String className, long classPK) throws PortalException {
        CommentManagerUtil.getCommentManager().deleteDiscussion(className, classPK);
    }

    public static void deleteGroupComments(long groupId) throws PortalException {
        CommentManagerUtil.getCommentManager().deleteGroupComments(groupId);
    }

    public static Comment fetchComment(long commentId) {
        return CommentManagerUtil.getCommentManager().fetchComment(commentId);
    }

    public static CommentManager getCommentManager() {
        PortalRuntimePermission.checkGetBeanProperty(CommentManagerUtil.class);
        return _commentManager;
    }

    public static int getCommentsCount(String className, long classPK) {
        return CommentManagerUtil.getCommentManager().getCommentsCount(className, classPK);
    }

    public static Discussion getDiscussion(long userId, long groupId, String className, long classPK, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil.getCommentManager().getDiscussion(userId, groupId, className, classPK, serviceContextFunction);
    }

    public static DiscussionPermission getDiscussionPermission(PermissionChecker permissionChecker) {
        return CommentManagerUtil.getCommentManager().getDiscussionPermission(permissionChecker);
    }

    public static DiscussionStagingHandler getDiscussionStagingHandler() {
        return CommentManagerUtil.getCommentManager().getDiscussionStagingHandler();
    }

    public static boolean hasDiscussion(String className, long classPK) throws PortalException {
        return CommentManagerUtil.getCommentManager().hasDiscussion(className, classPK);
    }

    public static void moveDiscussionToTrash(String className, long classPK) {
        CommentManagerUtil.getCommentManager().moveDiscussionToTrash(className, classPK);
    }

    public static void restoreDiscussionFromTrash(String className, long classPK) {
        CommentManagerUtil.getCommentManager().restoreDiscussionFromTrash(className, classPK);
    }

    public static void subscribeDiscussion(long userId, long groupId, String className, long classPK) throws PortalException {
        CommentManagerUtil.getCommentManager().subscribeDiscussion(userId, groupId, className, classPK);
    }

    public static void unsubscribeDiscussion(long userId, String className, long classPK) throws PortalException {
        CommentManagerUtil.getCommentManager().unsubscribeDiscussion(userId, className, classPK);
    }

    public static long updateComment(long userId, String className, long classPK, long commentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        return CommentManagerUtil.getCommentManager().updateComment(userId, className, classPK, commentId, subject, body, serviceContextFunction);
    }
}

