/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.service.KBCommentLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKBCommentUADAnonymizer
extends DynamicQueryUADAnonymizer<KBComment> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected KBCommentLocalService kbCommentLocalService;

    public void autoAnonymize(KBComment kbComment, long userId, User anonymousUser) throws PortalException {
        if (kbComment.getUserId() == userId) {
            kbComment.setUserId(anonymousUser.getUserId());
            kbComment.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(kbComment, anonymousUser);
        }
        this.kbCommentLocalService.updateKBComment(kbComment);
    }

    public void delete(KBComment kbComment) throws PortalException {
        this.kbCommentLocalService.deleteKBComment(kbComment);
    }

    public Class<KBComment> getTypeClass() {
        return KBComment.class;
    }

    protected void autoAnonymizeAssetEntry(KBComment kbComment, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(kbComment);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.kbCommentLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return KBUADConstants.USER_ID_FIELD_NAMES_KB_COMMENT;
    }

    protected AssetEntry fetchAssetEntry(KBComment kbComment) {
        return this.assetEntryLocalService.fetchEntry(KBComment.class.getName(), kbComment.getKbCommentId());
    }
}

