/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKBArticleUADAnonymizer
extends DynamicQueryUADAnonymizer<KBArticle> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected KBArticleLocalService kbArticleLocalService;

    public void autoAnonymize(KBArticle kbArticle, long userId, User anonymousUser) throws PortalException {
        if (kbArticle.getUserId() == userId) {
            kbArticle.setUserId(anonymousUser.getUserId());
            kbArticle.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(kbArticle, anonymousUser);
        }
        if (kbArticle.getStatusByUserId() == userId) {
            kbArticle.setStatusByUserId(anonymousUser.getUserId());
            kbArticle.setStatusByUserName(anonymousUser.getFullName());
        }
        this.kbArticleLocalService.updateKBArticle(kbArticle);
    }

    public void delete(KBArticle kbArticle) throws PortalException {
        this.kbArticleLocalService.deleteKBArticle(kbArticle);
    }

    public Class<KBArticle> getTypeClass() {
        return KBArticle.class;
    }

    protected void autoAnonymizeAssetEntry(KBArticle kbArticle, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(kbArticle);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.kbArticleLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return KBUADConstants.USER_ID_FIELD_NAMES_KB_ARTICLE;
    }

    protected AssetEntry fetchAssetEntry(KBArticle kbArticle) {
        return this.assetEntryLocalService.fetchEntry(KBArticle.class.getName(), kbArticle.getKbArticleId());
    }
}

