/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.knowledge.base.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;

import org.osgi.service.component.annotations.Component;

/**
 * @author Balázs Sáfrány-Kovalik
 */
@Component(service = UADAnonymizer.class)
public class KBArticleUADAnonymizer extends BaseKBArticleUADAnonymizer {

	@Override
	protected AssetEntry fetchAssetEntry(KBArticle kbArticle) {
		return assetEntryLocalService.fetchEntry(
			KBArticle.class.getName(), kbArticle.getResourcePrimKey());
	}

}