/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.knowledge.base.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the kb article UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link KBArticleUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseKBArticleUADAnonymizer
	extends DynamicQueryUADAnonymizer<KBArticle> {

	@Override
	public void autoAnonymize(
			KBArticle kbArticle, long userId, User anonymousUser)
		throws PortalException {

		if (kbArticle.getUserId() == userId) {
			kbArticle.setUserId(anonymousUser.getUserId());
			kbArticle.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(kbArticle, anonymousUser);
		}

		if (kbArticle.getStatusByUserId() == userId) {
			kbArticle.setStatusByUserId(anonymousUser.getUserId());
			kbArticle.setStatusByUserName(anonymousUser.getFullName());
		}

		kbArticleLocalService.updateKBArticle(kbArticle);
	}

	@Override
	public void delete(KBArticle kbArticle) throws PortalException {
		kbArticleLocalService.deleteKBArticle(kbArticle);
	}

	@Override
	public Class<KBArticle> getTypeClass() {
		return KBArticle.class;
	}

	protected void autoAnonymizeAssetEntry(
		KBArticle kbArticle, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(kbArticle);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return kbArticleLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return KBUADConstants.USER_ID_FIELD_NAMES_KB_ARTICLE;
	}

	protected AssetEntry fetchAssetEntry(KBArticle kbArticle) {
		return assetEntryLocalService.fetchEntry(
			KBArticle.class.getName(), kbArticle.getKbArticleId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected KBArticleLocalService kbArticleLocalService;

}