/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_1_0.util;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.InputStream;

public class KBArticleAttachmentsHelper {
    private static final Log _log = LogFactoryUtil.getLog(KBArticleAttachmentsHelper.class);
    private final Store _store;

    public KBArticleAttachmentsHelper(Store store) {
        this._store = store;
    }

    public void deleteAttachmentsDirectory(long companyId) {
        try {
            String[] fileNames = this._store.getFileNames(companyId, 0L, "knowledgebase/articles");
            if (fileNames.length > 0) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to delete knowledgebase/articles");
                }
                return;
            }
            this._store.deleteDirectory(companyId, 0L, "knowledgebase/articles");
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public void updateAttachments(KBArticle kbArticle) {
        try {
            long folderId = kbArticle.getClassPK();
            String oldDirName = "knowledgebase/articles/" + folderId;
            String newDirName = "knowledgebase/kbarticles/" + folderId;
            String[] fileNames = this._store.getFileNames(kbArticle.getCompanyId(), 0L, oldDirName);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(kbArticle.getCompanyId());
            serviceContext.setScopeGroupId(kbArticle.getGroupId());
            for (String fileName : fileNames) {
                String shortFileName = FileUtil.getShortFileName((String)fileName);
                try (InputStream inputStream = this._store.getFileAsStream(kbArticle.getCompanyId(), 0L, fileName, "");){
                    this._store.addFile(kbArticle.getCompanyId(), 0L, newDirName + "/" + shortFileName, "1.0", inputStream);
                }
            }
            this._store.deleteDirectory(kbArticle.getCompanyId(), 0L, oldDirName);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Added attachments for " + folderId));
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }
}

