/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.trash;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.internal.trash.BaseKBTrashHandler;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.trash.TrashHelper;
import jakarta.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBArticle"}, service={TrashHandler.class})
public class KBArticleTrashHandler
extends BaseKBTrashHandler {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBArticle)")
    private ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBFolder)")
    private ModelResourcePermission<KBFolder> _kbFolderModelResourcePermission;
    @Reference
    private TrashHelper _trashHelper;

    public void deleteTrashEntry(long classPK) throws PortalException {
        this.kbArticleLocalService.deleteKBArticle(this.kbArticleLocalService.getLatestKBArticle(classPK));
    }

    public String getClassName() {
        return KBArticle.class.getName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(classPK);
        long parentKBFolderId = kbArticle.getKbFolderId();
        if (parentKBFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentKBFolderId);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException {
        KBArticle kbArticle = (KBArticle)trashedModel;
        return this.getContainerModel(kbArticle.getKbFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(classPK);
        if (!kbArticle.hasParentKBArticle()) {
            return KnowledgeBaseUtil.getKBFolderControlPanelLink((PortletRequest)portletRequest, (long)kbArticle.getKbFolderId());
        }
        return KnowledgeBaseUtil.getKBArticleControlPanelLink((PortletRequest)portletRequest, (long)kbArticle.getParentResourcePrimKey());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        return KnowledgeBaseUtil.getKBArticleAbsolutePath((PortletRequest)portletRequest, (long)classPK);
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this.kbArticleLocalService.fetchLatestKBArticle(classPK, -1);
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getClassName());
        return (TrashRenderer)assetRendererFactory.getAssetRenderer((Object)((KBArticle)this.getTrashedModel(classPK)), 1);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return ModelResourcePermissionUtil.contains(this._kbFolderModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_KB_ARTICLE");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isMovable(long classPK) throws PortalException {
        KBFolder parentKBFolder;
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(classPK);
        return kbArticle.getKbFolderId() > 0L && ((parentKBFolder = this.kbFolderLocalService.fetchKBFolder(kbArticle.getKbFolderId())) == null || parentKBFolder.isInTrash());
    }

    public boolean isRestorable(long classPK) throws PortalException {
        KBFolder kbFolder;
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(classPK);
        if (kbArticle.getKbFolderId() > 0L && (kbFolder = this.kbFolderLocalService.fetchKBFolder(kbArticle.getKbFolderId())) == null) {
            return false;
        }
        return this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), kbArticle.getGroupId(), classPK, "RESTORE") && !this._trashHelper.isInTrashContainer((TrashedModel)kbArticle);
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(classPK);
        this.kbArticleLocalService.moveKBArticle(userId, kbArticle.getResourcePrimKey(), this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName()), containerModelId, kbArticle.getPriority());
    }

    public void moveTrashEntry(long userId, long classPK, long containerId, ServiceContext serviceContext) throws PortalException {
        this.kbArticleLocalService.moveKBArticleFromTrash(userId, classPK, this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName()), containerId);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        this.kbArticleLocalService.restoreKBArticleFromTrash(userId, classPK);
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(classPK);
        return kbArticle.getGroupId();
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return this._kbArticleModelResourcePermission.contains(permissionChecker, (ClassedModel)this.kbArticleLocalService.getLatestKBArticle(classPK), actionId);
    }
}

