/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_1_0;

import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.CamelCaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import jakarta.portlet.PortletPreferences;
import java.util.Collections;
import java.util.Map;

public class UpgradePortletPreferences
extends CamelCaseUpgradePortletPreferences {
    private static final String[] _PORTLET_IDS = new String[]{"1_WAR_knowledgebaseportlet", "2_WAR_knowledgebaseportlet", "3_WAR_knowledgebaseportlet_INSTANCE_%"};
    private static final Map<String, String> _adminDefaultPreferencesMap = HashMapBuilder.put((Object)"enableKBArticleAssetCategories", (Object)"false").put((Object)"enableKBArticleAssetTags", (Object)"true").put((Object)"enableKBArticleDescription", (Object)"false").put((Object)"enableKBArticleKBComments", (Object)"true").put((Object)"enableKBArticleRatings", (Object)"false").put((Object)"enableKBArticleViewCountIncrement", (Object)"true").put((Object)"enableKBStructureKBComments", (Object)"true").put((Object)"enableKBTemplateKBComments", (Object)"true").put((Object)"kbArticlesOrderByCol", (Object)"priority").put((Object)"kbArticlesOrderByType", (Object)"desc").put((Object)"showKBArticleAssetEntries", (Object)"true").put((Object)"showKBArticleKBComments", (Object)"true").put((Object)"showKBStructureKBComments", (Object)"true").put((Object)"showKBTemplateKBComments", (Object)"true").build();
    private static final Map<String, String> _articleDefaultPreferencesMap = HashMapBuilder.put((Object)"enableKBArticleAssetCategories", (Object)"false").put((Object)"enableKBArticleAssetTags", (Object)"true").put((Object)"enableKBArticleDescription", (Object)"false").put((Object)"enableKBArticleKBComments", (Object)"true").put((Object)"enableKBArticleRatings", (Object)"false").put((Object)"enableKBArticleViewCountIncrement", (Object)"true").put((Object)"resourcePrimKey", (Object)"0").put((Object)"rssDelta", (Object)"20").put((Object)"rssDisplayStyle", (Object)"full-content").put((Object)"rssFormat", (Object)"atom10").put((Object)"showKBArticleAssetEntries", (Object)"true").put((Object)"showKBArticleKBComments", (Object)"true").build();
    private static final Map<String, String> _displayDefaultPreferencesMap = HashMapBuilder.put((Object)"enableKBArticleAssetCategories", (Object)"false").put((Object)"enableKBArticleAssetTags", (Object)"true").put((Object)"enableKBArticleDescription", (Object)"false").put((Object)"enableKBArticleKBComments", (Object)"true").put((Object)"enableKBArticleRatings", (Object)"false").put((Object)"enableKBArticleViewCountIncrement", (Object)"true").put((Object)"enableKBTemplateKBComments", (Object)"true").put((Object)"kbArticlesOrderByCol", (Object)"priority").put((Object)"kbArticlesOrderByType", (Object)"desc").put((Object)"rssDelta", (Object)"20").put((Object)"rssDisplayStyle", (Object)"full-content").put((Object)"rssFormat", (Object)"atom10").put((Object)"showKBArticleAssetEntries", (Object)"true").put((Object)"showKBArticleAuthorColumn", (Object)"true").put((Object)"showKBArticleCreateDateColumn", (Object)"true").put((Object)"showKBArticleKBComments", (Object)"true").put((Object)"showKBArticleModifiedDateColumn", (Object)"true").put((Object)"showKBArticlePriorityColumn", (Object)"true").put((Object)"showKBArticleStatusColumn", (Object)"true").put((Object)"showKBArticleViewsColumn", (Object)"true").put((Object)"showKBTemplateKBComments", (Object)"true").build();
    private static final Map<String, String> _oldAdminPreferenceNamesMap = HashMapBuilder.put((Object)"articlesOrderByCol", (Object)"kbArticlesOrderByCol").put((Object)"articlesOrderByType", (Object)"kbArticlesOrderByType").put((Object)"enableArticleAssetCategories", (Object)"enableKBArticleAssetCategories").put((Object)"enableArticleAssetTags", (Object)"enableKBArticleAssetTags").put((Object)"enableArticleComments", (Object)"enableKBArticleKBComments").put((Object)"enableArticleDescription", (Object)"enableKBArticleDescription").put((Object)"enableArticleRatings", (Object)"enableKBArticleRatings").put((Object)"enableArticleViewCountIncrement", (Object)"enableKBArticleViewCountIncrement").put((Object)"enableTemplateComments", (Object)"enableKBTemplateKBComments").put((Object)"showArticleComments", (Object)"showKBArticleKBComments").put((Object)"showTemplateComments", (Object)"showKBTemplateKBComments").build();
    private static final Map<String, String> _oldArticlePreferenceNamesMap = HashMapBuilder.put((Object)"enableArticleAssetCategories", (Object)"enableKBArticleAssetCategories").put((Object)"enableArticleAssetTags", (Object)"enableKBArticleAssetTags").put((Object)"enableArticleComments", (Object)"enableKBArticleKBComments").put((Object)"enableArticleDescription", (Object)"enableKBArticleDescription").put((Object)"enableArticleRatings", (Object)"enableKBArticleRatings").put((Object)"enableArticleViewCountIncrement", (Object)"enableKBArticleViewCountIncrement").put((Object)"showArticleComments", (Object)"showKBArticleKBComments").build();
    private static final Map<String, String> _oldDisplayPreferenceNamesMap = HashMapBuilder.put((Object)"articlesOrderByCol", (Object)"kbArticlesOrderByCol").put((Object)"articlesOrderByType", (Object)"kbArticlesOrderByType").put((Object)"enableArticleAssetCategories", (Object)"enableKBArticleAssetCategories").put((Object)"enableArticleAssetTags", (Object)"enableKBArticleAssetTags").put((Object)"enableArticleComments", (Object)"enableKBArticleKBComments").put((Object)"enableArticleDescription", (Object)"enableKBArticleDescription").put((Object)"enableArticleRatings", (Object)"enableKBArticleRatings").put((Object)"enableArticleViewCountIncrement", (Object)"enableKBArticleViewCountIncrement").put((Object)"enableTemplateComments", (Object)"enableKBTemplateKBComments").put((Object)"showArticleComments", (Object)"showKBArticleKBComments").put((Object)"showTemplateComments", (Object)"showKBTemplateKBComments").build();

    protected String getName(String rootPortletId, String oldName) {
        if (rootPortletId.equals("1_WAR_knowledgebaseportlet")) {
            return _oldAdminPreferenceNamesMap.get(oldName);
        }
        if (rootPortletId.equals("2_WAR_knowledgebaseportlet")) {
            return _oldDisplayPreferenceNamesMap.get(oldName);
        }
        if (rootPortletId.equals("3_WAR_knowledgebaseportlet")) {
            return _oldArticlePreferenceNamesMap.get(oldName);
        }
        return null;
    }

    protected String[] getPortletIds() {
        return _PORTLET_IDS;
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        String preferences = super.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, xml);
        return this._updatePreferences(companyId, ownerId, ownerType, plid, portletId, preferences);
    }

    private Map<String, String> _getDefaultPreferencesMap(String rootPortletId) {
        if (rootPortletId.equals("1_WAR_knowledgebaseportlet")) {
            return _adminDefaultPreferencesMap;
        }
        if (rootPortletId.equals("2_WAR_knowledgebaseportlet")) {
            return _displayDefaultPreferencesMap;
        }
        if (rootPortletId.equals("3_WAR_knowledgebaseportlet")) {
            return _articleDefaultPreferencesMap;
        }
        return Collections.emptyMap();
    }

    private String _updatePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Map preferencesMap = portletPreferences.getMap();
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        for (Map.Entry entry : preferencesMap.entrySet()) {
            String oldName = (String)entry.getKey();
            String newName = this.getName(rootPortletId, oldName);
            portletPreferences.reset(oldName);
            if (newName == null) continue;
            portletPreferences.setValues(newName, (String[])entry.getValue());
        }
        Map<String, String> defaultPreferencesMap = this._getDefaultPreferencesMap(rootPortletId);
        for (Map.Entry<String, String> entry : defaultPreferencesMap.entrySet()) {
            String name = entry.getKey();
            if (portletPreferences.getValues(name, null) != null) continue;
            portletPreferences.setValues(name, StringUtil.split((String)entry.getValue()));
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }
}

