/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class KBServicePreAction
extends Action {
    private static final boolean _PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"portlet.add.default.resource.check.enabled"));
    private static final Log _log = LogFactoryUtil.getLog(KBServicePreAction.class);
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            this._run(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private void _run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!_PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isLifecycleRender()) {
            return;
        }
        String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
        if (Validator.isNull((String)portletId) || !portletId.equals("com_liferay_knowledge_base_web_portlet_ArticlePortlet_INSTANCE_0000")) {
            return;
        }
        String request_p_p_auth = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_auth");
        if (Validator.isNull((String)request_p_p_auth)) {
            return;
        }
        String actual_p_p_auth = AuthTokenUtil.getToken((HttpServletRequest)httpServletRequest, (long)themeDisplay.getPlid(), (String)portletId);
        if (request_p_p_auth.equals(actual_p_p_auth)) {
            return;
        }
        String redirect = this._portal.escapeRedirect(themeDisplay.getURLCurrent());
        if (Validator.isNull((String)redirect)) {
            return;
        }
        redirect = HttpComponentsUtil.setParameter((String)redirect, (String)"p_p_auth", (String)actual_p_p_auth);
        httpServletResponse.sendRedirect(redirect);
    }
}

