/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.security.permission.resource;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.model.KBCommentModel;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBCommentLocalService;
import com.liferay.knowledge.base.service.KBTemplateLocalService;
import com.liferay.portal.kernel.security.permission.resource.BaseModelResourcePermissionWrapper;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBComment"}, service={ModelResourcePermission.class})
public class KBCommentModelResourcePermissionWrapper
extends BaseModelResourcePermissionWrapper<KBComment> {
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    @Reference
    private KBCommentLocalService _kbCommentLocalService;
    @Reference
    private KBTemplateLocalService _kbTemplateLocalService;
    @Reference(target="(resource.name=com.liferay.knowledge.base.admin)")
    private PortletResourcePermission _portletResourcePermission;

    protected ModelResourcePermission<KBComment> doGetModelResourcePermission() {
        return ModelResourcePermissionFactory.create(KBComment.class, KBCommentModel::getKbCommentId, arg_0 -> ((KBCommentLocalService)this._kbCommentLocalService).getKBComment(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> consumer.accept((permissionChecker, name, kbComment, actionId) -> {
            if (permissionChecker.getUserId() == kbComment.getUserId()) {
                return true;
            }
            if (actionId.equals("VIEW")) {
                return this._portletResourcePermission.contains(permissionChecker, kbComment.getGroupId(), "VIEW_SUGGESTIONS");
            }
            if (!actionId.equals("DELETE") && !actionId.equals("UPDATE")) {
                return false;
            }
            String className = kbComment.getClassName();
            if (className.equals(KBArticle.class.getName())) {
                KBArticle kbArticle = this._kbArticleLocalService.getLatestKBArticle(kbComment.getClassPK(), -1);
                return permissionChecker.hasPermission(kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), "UPDATE");
            }
            if (className.equals(KBTemplate.class.getName())) {
                KBTemplate kbTemplate = this._kbTemplateLocalService.getKBTemplate(kbComment.getClassPK());
                return permissionChecker.hasPermission(kbTemplate.getGroupId(), KBTemplate.class.getName(), kbTemplate.getPrimaryKey(), "UPDATE");
            }
            return false;
        }));
    }
}

