/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.importer.util;

import com.liferay.knowledge.base.configuration.KBGroupServiceConfiguration;
import com.liferay.knowledge.base.exception.KBArticleImportException;
import com.liferay.knowledge.base.internal.importer.KBArchive;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class KBArchiveFactoryUtil {
    public static KBArchive createKBArchive(ConfigurationProvider configurationProvider, long groupId, ZipReader zipReader) throws PortalException {
        List entries = zipReader.getEntries();
        if (entries == null) {
            throw new KBArticleImportException("The uploaded file is not a ZIP archive or it is corrupted");
        }
        KBGroupServiceConfiguration kbGroupServiceConfiguration = (KBGroupServiceConfiguration)configurationProvider.getConfiguration(KBGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.knowledge.base"));
        Collections.sort(entries);
        KBArchiveState kbArchiveState = new KBArchiveState(zipReader);
        for (String entry : entries) {
            Object[] articleExtensions = kbGroupServiceConfiguration.markdownImporterArticleExtensions();
            if (!ArrayUtil.exists((Object[])articleExtensions, entry::endsWith)) continue;
            Path entryPath = Paths.get(entry, new String[0]);
            Path entryParentPath = entryPath.getParent();
            kbArchiveState.setCurrentFolder(entryParentPath);
            String markdownImporterArticleIntro = kbGroupServiceConfiguration.markdownImporterArticleIntro();
            String entryFileName = String.valueOf(entryPath.getFileName());
            if (entryFileName.endsWith(markdownImporterArticleIntro)) {
                kbArchiveState.setCurrentFolderIntroFile(entryPath);
                continue;
            }
            kbArchiveState.addCurrentFolderFile(entryPath);
        }
        return new KBArchiveImpl(kbArchiveState.getFolders());
    }

    private static final class KBArchiveState {
        private static final Path _ROOT_FOLDER_PATH = Paths.get("/", new String[0]);
        private Collection<KBArchive.File> _currentFolderFiles;
        private KBArchive.File _currentFolderIntroFile;
        private Path _currentFolderPath;
        private final Map<Path, KBArchive.Folder> _folders = new TreeMap<Path, KBArchive.Folder>();
        private final ZipReader _zipReader;

        public KBArchiveState(ZipReader zipReader) {
            this._zipReader = zipReader;
        }

        public void addCurrentFolderFile(Path path) {
            this._currentFolderFiles.add(new FileImpl(path.toString(), this._zipReader));
        }

        public Collection<KBArchive.Folder> getFolders() {
            this._saveCurrentFolderState();
            return this._folders.values();
        }

        public void setCurrentFolder(Path folderPath) {
            if (folderPath == null) {
                folderPath = _ROOT_FOLDER_PATH;
            }
            if (folderPath.equals(this._currentFolderPath)) {
                return;
            }
            this._saveCurrentFolderState();
            this._restoreFolderState(folderPath);
        }

        public void setCurrentFolderIntroFile(Path path) {
            this._currentFolderIntroFile = new FileImpl(path.toString(), this._zipReader);
        }

        private void _restoreFolderState(Path folderPath) {
            this._currentFolderPath = folderPath;
            KBArchive.Folder folder = this._folders.get(folderPath);
            if (folder != null) {
                this._currentFolderIntroFile = folder.getIntroFile();
                this._currentFolderFiles = folder.getFiles();
            } else {
                this._currentFolderIntroFile = null;
                this._currentFolderFiles = new ArrayList<KBArchive.File>();
            }
        }

        private void _saveCurrentFolderState() {
            if (this._currentFolderPath == null || this._currentFolderIntroFile == null && this._currentFolderFiles.isEmpty()) {
                return;
            }
            Path currentFolderParentPath = this._currentFolderPath.getParent();
            KBArchive.Folder parentFolder = null;
            if (currentFolderParentPath != null) {
                parentFolder = this._folders.get(currentFolderParentPath);
            }
            FolderImpl folder = new FolderImpl(this._currentFolderPath.toString(), parentFolder, this._currentFolderIntroFile, this._currentFolderFiles);
            this._folders.put(this._currentFolderPath, folder);
        }
    }

    private static final class KBArchiveImpl
    implements KBArchive {
        private final Collection<KBArchive.Folder> _folders;

        public KBArchiveImpl(Collection<KBArchive.Folder> folders) {
            this._folders = folders;
        }

        @Override
        public Collection<KBArchive.Folder> getFolders() {
            return this._folders;
        }
    }

    private static final class FolderImpl
    implements KBArchive.Folder {
        private final Collection<KBArchive.File> _files;
        private final KBArchive.File _introFile;
        private final String _name;
        private final KBArchive.Folder _parentFolder;

        public FolderImpl(String name, KBArchive.Folder parentFolder, KBArchive.File introFile, Collection<KBArchive.File> files) {
            this._name = StringUtil.replace((String)name, (char)File.separatorChar, (char)'/');
            this._parentFolder = parentFolder;
            this._introFile = introFile;
            this._files = files;
        }

        @Override
        public Collection<KBArchive.File> getFiles() {
            return this._files;
        }

        @Override
        public KBArchive.File getIntroFile() {
            return this._introFile;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public KBArchive.File getParentFolderIntroFile() {
            if (this._parentFolder == null) {
                return null;
            }
            return this._parentFolder.getIntroFile();
        }
    }

    private static final class FileImpl
    implements KBArchive.File {
        private final String _name;
        private final ZipReader _zipReader;

        public FileImpl(String name, ZipReader zipReader) {
            this._name = StringUtil.replace((String)name, (char)File.separatorChar, (char)'/');
            this._zipReader = zipReader;
        }

        @Override
        public String getContent() {
            return this._zipReader.getEntryAsString(this.getName());
        }

        @Override
        public String getName() {
            return this._name;
        }
    }
}

