/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.journal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.model.JournalFeedModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the JournalFeed service. Represents a row in the &quot;JournalFeed&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>JournalFeedModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link JournalFeedImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see JournalFeedImpl
 * @generated
 */
@JSON(strict = true)
public class JournalFeedModelImpl
	extends BaseModelImpl<JournalFeed> implements JournalFeedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a journal feed model instance should use the <code>JournalFeed</code> interface instead.
	 */
	public static final String TABLE_NAME = "JournalFeed";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"id_", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"feedId", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"DDMStructureId", Types.BIGINT},
		{"DDMTemplateKey", Types.VARCHAR},
		{"DDMRendererTemplateKey", Types.VARCHAR}, {"delta", Types.INTEGER},
		{"orderByCol", Types.VARCHAR}, {"orderByType", Types.VARCHAR},
		{"targetLayoutFriendlyUrl", Types.VARCHAR},
		{"targetPortletId", Types.VARCHAR}, {"contentField", Types.VARCHAR},
		{"feedFormat", Types.VARCHAR}, {"feedVersion", Types.DOUBLE},
		{"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("id_", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("feedId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("DDMStructureId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("DDMTemplateKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("DDMRendererTemplateKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("delta", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("orderByCol", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("orderByType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("targetLayoutFriendlyUrl", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("targetPortletId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("contentField", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("feedFormat", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("feedVersion", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table JournalFeed (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,id_ LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,feedId VARCHAR(75) null,name VARCHAR(75) null,description STRING null,DDMStructureId LONG,DDMTemplateKey VARCHAR(75) null,DDMRendererTemplateKey VARCHAR(75) null,delta INTEGER,orderByCol VARCHAR(75) null,orderByType VARCHAR(75) null,targetLayoutFriendlyUrl VARCHAR(255) null,targetPortletId VARCHAR(200) null,contentField VARCHAR(75) null,feedFormat VARCHAR(75) null,feedVersion DOUBLE,lastPublishDate DATE null,primary key (id_, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table JournalFeed";

	public static final String ORDER_BY_JPQL =
		" ORDER BY journalFeed.feedId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY JournalFeed.feedId ASC";

	public static final String ORDER_BY_SQL_INLINE_DISTINCT =
		" ORDER BY journalFeed.feedId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FEEDID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public JournalFeedModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _id;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _id;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return JournalFeed.class;
	}

	@Override
	public String getModelClassName() {
		return JournalFeed.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<JournalFeed, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<JournalFeed, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<JournalFeed, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((JournalFeed)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<JournalFeed, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<JournalFeed, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(JournalFeed)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<JournalFeed, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<JournalFeed, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<JournalFeed, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<JournalFeed, Object>>
				attributeGetterFunctions =
					new LinkedHashMap<String, Function<JournalFeed, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", JournalFeed::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", JournalFeed::getCtCollectionId);
			attributeGetterFunctions.put("uuid", JournalFeed::getUuid);
			attributeGetterFunctions.put("id", JournalFeed::getId);
			attributeGetterFunctions.put("groupId", JournalFeed::getGroupId);
			attributeGetterFunctions.put(
				"companyId", JournalFeed::getCompanyId);
			attributeGetterFunctions.put("userId", JournalFeed::getUserId);
			attributeGetterFunctions.put("userName", JournalFeed::getUserName);
			attributeGetterFunctions.put(
				"createDate", JournalFeed::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", JournalFeed::getModifiedDate);
			attributeGetterFunctions.put("feedId", JournalFeed::getFeedId);
			attributeGetterFunctions.put("name", JournalFeed::getName);
			attributeGetterFunctions.put(
				"description", JournalFeed::getDescription);
			attributeGetterFunctions.put(
				"DDMStructureId", JournalFeed::getDDMStructureId);
			attributeGetterFunctions.put(
				"DDMTemplateKey", JournalFeed::getDDMTemplateKey);
			attributeGetterFunctions.put(
				"DDMRendererTemplateKey",
				JournalFeed::getDDMRendererTemplateKey);
			attributeGetterFunctions.put("delta", JournalFeed::getDelta);
			attributeGetterFunctions.put(
				"orderByCol", JournalFeed::getOrderByCol);
			attributeGetterFunctions.put(
				"orderByType", JournalFeed::getOrderByType);
			attributeGetterFunctions.put(
				"targetLayoutFriendlyUrl",
				JournalFeed::getTargetLayoutFriendlyUrl);
			attributeGetterFunctions.put(
				"targetPortletId", JournalFeed::getTargetPortletId);
			attributeGetterFunctions.put(
				"contentField", JournalFeed::getContentField);
			attributeGetterFunctions.put(
				"feedFormat", JournalFeed::getFeedFormat);
			attributeGetterFunctions.put(
				"feedVersion", JournalFeed::getFeedVersion);
			attributeGetterFunctions.put(
				"lastPublishDate", JournalFeed::getLastPublishDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<JournalFeed, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<JournalFeed, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<JournalFeed, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<JournalFeed, Long>)JournalFeed::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<JournalFeed, Long>)JournalFeed::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<JournalFeed, String>)JournalFeed::setUuid);
			attributeSetterBiConsumers.put(
				"id", (BiConsumer<JournalFeed, Long>)JournalFeed::setId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<JournalFeed, Long>)JournalFeed::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<JournalFeed, Long>)JournalFeed::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<JournalFeed, Long>)JournalFeed::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<JournalFeed, String>)JournalFeed::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<JournalFeed, Date>)JournalFeed::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<JournalFeed, Date>)JournalFeed::setModifiedDate);
			attributeSetterBiConsumers.put(
				"feedId",
				(BiConsumer<JournalFeed, String>)JournalFeed::setFeedId);
			attributeSetterBiConsumers.put(
				"name", (BiConsumer<JournalFeed, String>)JournalFeed::setName);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<JournalFeed, String>)JournalFeed::setDescription);
			attributeSetterBiConsumers.put(
				"DDMStructureId",
				(BiConsumer<JournalFeed, Long>)JournalFeed::setDDMStructureId);
			attributeSetterBiConsumers.put(
				"DDMTemplateKey",
				(BiConsumer<JournalFeed, String>)
					JournalFeed::setDDMTemplateKey);
			attributeSetterBiConsumers.put(
				"DDMRendererTemplateKey",
				(BiConsumer<JournalFeed, String>)
					JournalFeed::setDDMRendererTemplateKey);
			attributeSetterBiConsumers.put(
				"delta",
				(BiConsumer<JournalFeed, Integer>)JournalFeed::setDelta);
			attributeSetterBiConsumers.put(
				"orderByCol",
				(BiConsumer<JournalFeed, String>)JournalFeed::setOrderByCol);
			attributeSetterBiConsumers.put(
				"orderByType",
				(BiConsumer<JournalFeed, String>)JournalFeed::setOrderByType);
			attributeSetterBiConsumers.put(
				"targetLayoutFriendlyUrl",
				(BiConsumer<JournalFeed, String>)
					JournalFeed::setTargetLayoutFriendlyUrl);
			attributeSetterBiConsumers.put(
				"targetPortletId",
				(BiConsumer<JournalFeed, String>)
					JournalFeed::setTargetPortletId);
			attributeSetterBiConsumers.put(
				"contentField",
				(BiConsumer<JournalFeed, String>)JournalFeed::setContentField);
			attributeSetterBiConsumers.put(
				"feedFormat",
				(BiConsumer<JournalFeed, String>)JournalFeed::setFeedFormat);
			attributeSetterBiConsumers.put(
				"feedVersion",
				(BiConsumer<JournalFeed, Double>)JournalFeed::setFeedVersion);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<JournalFeed, Date>)JournalFeed::setLastPublishDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getId() {
		return _id;
	}

	@Override
	public void setId(long id) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_id = id;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getFeedId() {
		if (_feedId == null) {
			return "";
		}
		else {
			return _feedId;
		}
	}

	@Override
	public void setFeedId(String feedId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_feedId = feedId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFeedId() {
		return getColumnOriginalValue("feedId");
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public long getDDMStructureId() {
		return _DDMStructureId;
	}

	@Override
	public void setDDMStructureId(long DDMStructureId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_DDMStructureId = DDMStructureId;
	}

	@JSON
	@Override
	public String getDDMTemplateKey() {
		if (_DDMTemplateKey == null) {
			return "";
		}
		else {
			return _DDMTemplateKey;
		}
	}

	@Override
	public void setDDMTemplateKey(String DDMTemplateKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_DDMTemplateKey = DDMTemplateKey;
	}

	@JSON
	@Override
	public String getDDMRendererTemplateKey() {
		if (_DDMRendererTemplateKey == null) {
			return "";
		}
		else {
			return _DDMRendererTemplateKey;
		}
	}

	@Override
	public void setDDMRendererTemplateKey(String DDMRendererTemplateKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_DDMRendererTemplateKey = DDMRendererTemplateKey;
	}

	@JSON
	@Override
	public int getDelta() {
		return _delta;
	}

	@Override
	public void setDelta(int delta) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_delta = delta;
	}

	@JSON
	@Override
	public String getOrderByCol() {
		if (_orderByCol == null) {
			return "";
		}
		else {
			return _orderByCol;
		}
	}

	@Override
	public void setOrderByCol(String orderByCol) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_orderByCol = orderByCol;
	}

	@JSON
	@Override
	public String getOrderByType() {
		if (_orderByType == null) {
			return "";
		}
		else {
			return _orderByType;
		}
	}

	@Override
	public void setOrderByType(String orderByType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_orderByType = orderByType;
	}

	@JSON
	@Override
	public String getTargetLayoutFriendlyUrl() {
		if (_targetLayoutFriendlyUrl == null) {
			return "";
		}
		else {
			return _targetLayoutFriendlyUrl;
		}
	}

	@Override
	public void setTargetLayoutFriendlyUrl(String targetLayoutFriendlyUrl) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_targetLayoutFriendlyUrl = targetLayoutFriendlyUrl;
	}

	@JSON
	@Override
	public String getTargetPortletId() {
		if (_targetPortletId == null) {
			return "";
		}
		else {
			return _targetPortletId;
		}
	}

	@Override
	public void setTargetPortletId(String targetPortletId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_targetPortletId = targetPortletId;
	}

	@JSON
	@Override
	public String getContentField() {
		if (_contentField == null) {
			return "";
		}
		else {
			return _contentField;
		}
	}

	@Override
	public void setContentField(String contentField) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_contentField = contentField;
	}

	@JSON
	@Override
	public String getFeedFormat() {
		if (_feedFormat == null) {
			return "";
		}
		else {
			return _feedFormat;
		}
	}

	@Override
	public void setFeedFormat(String feedFormat) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_feedFormat = feedFormat;
	}

	@JSON
	@Override
	public double getFeedVersion() {
		return _feedVersion;
	}

	@Override
	public void setFeedVersion(double feedVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_feedVersion = feedVersion;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(JournalFeed.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), JournalFeed.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public JournalFeed toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, JournalFeed>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		JournalFeedImpl journalFeedImpl = new JournalFeedImpl();

		journalFeedImpl.setMvccVersion(getMvccVersion());
		journalFeedImpl.setCtCollectionId(getCtCollectionId());
		journalFeedImpl.setUuid(getUuid());
		journalFeedImpl.setId(getId());
		journalFeedImpl.setGroupId(getGroupId());
		journalFeedImpl.setCompanyId(getCompanyId());
		journalFeedImpl.setUserId(getUserId());
		journalFeedImpl.setUserName(getUserName());
		journalFeedImpl.setCreateDate(getCreateDate());
		journalFeedImpl.setModifiedDate(getModifiedDate());
		journalFeedImpl.setFeedId(getFeedId());
		journalFeedImpl.setName(getName());
		journalFeedImpl.setDescription(getDescription());
		journalFeedImpl.setDDMStructureId(getDDMStructureId());
		journalFeedImpl.setDDMTemplateKey(getDDMTemplateKey());
		journalFeedImpl.setDDMRendererTemplateKey(getDDMRendererTemplateKey());
		journalFeedImpl.setDelta(getDelta());
		journalFeedImpl.setOrderByCol(getOrderByCol());
		journalFeedImpl.setOrderByType(getOrderByType());
		journalFeedImpl.setTargetLayoutFriendlyUrl(
			getTargetLayoutFriendlyUrl());
		journalFeedImpl.setTargetPortletId(getTargetPortletId());
		journalFeedImpl.setContentField(getContentField());
		journalFeedImpl.setFeedFormat(getFeedFormat());
		journalFeedImpl.setFeedVersion(getFeedVersion());
		journalFeedImpl.setLastPublishDate(getLastPublishDate());

		journalFeedImpl.resetOriginalValues();

		return journalFeedImpl;
	}

	@Override
	public JournalFeed cloneWithOriginalValues() {
		JournalFeedImpl journalFeedImpl = new JournalFeedImpl();

		journalFeedImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		journalFeedImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		journalFeedImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		journalFeedImpl.setId(this.<Long>getColumnOriginalValue("id_"));
		journalFeedImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		journalFeedImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		journalFeedImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		journalFeedImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		journalFeedImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		journalFeedImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		journalFeedImpl.setFeedId(
			this.<String>getColumnOriginalValue("feedId"));
		journalFeedImpl.setName(this.<String>getColumnOriginalValue("name"));
		journalFeedImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		journalFeedImpl.setDDMStructureId(
			this.<Long>getColumnOriginalValue("DDMStructureId"));
		journalFeedImpl.setDDMTemplateKey(
			this.<String>getColumnOriginalValue("DDMTemplateKey"));
		journalFeedImpl.setDDMRendererTemplateKey(
			this.<String>getColumnOriginalValue("DDMRendererTemplateKey"));
		journalFeedImpl.setDelta(this.<Integer>getColumnOriginalValue("delta"));
		journalFeedImpl.setOrderByCol(
			this.<String>getColumnOriginalValue("orderByCol"));
		journalFeedImpl.setOrderByType(
			this.<String>getColumnOriginalValue("orderByType"));
		journalFeedImpl.setTargetLayoutFriendlyUrl(
			this.<String>getColumnOriginalValue("targetLayoutFriendlyUrl"));
		journalFeedImpl.setTargetPortletId(
			this.<String>getColumnOriginalValue("targetPortletId"));
		journalFeedImpl.setContentField(
			this.<String>getColumnOriginalValue("contentField"));
		journalFeedImpl.setFeedFormat(
			this.<String>getColumnOriginalValue("feedFormat"));
		journalFeedImpl.setFeedVersion(
			this.<Double>getColumnOriginalValue("feedVersion"));
		journalFeedImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));

		return journalFeedImpl;
	}

	@Override
	public int compareTo(JournalFeed journalFeed) {
		int value = 0;

		value = getFeedId().compareTo(journalFeed.getFeedId());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof JournalFeed)) {
			return false;
		}

		JournalFeed journalFeed = (JournalFeed)object;

		long primaryKey = journalFeed.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<JournalFeed> toCacheModel() {
		JournalFeedCacheModel journalFeedCacheModel =
			new JournalFeedCacheModel();

		journalFeedCacheModel.mvccVersion = getMvccVersion();

		journalFeedCacheModel.ctCollectionId = getCtCollectionId();

		journalFeedCacheModel.uuid = getUuid();

		String uuid = journalFeedCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			journalFeedCacheModel.uuid = null;
		}

		journalFeedCacheModel.id = getId();

		journalFeedCacheModel.groupId = getGroupId();

		journalFeedCacheModel.companyId = getCompanyId();

		journalFeedCacheModel.userId = getUserId();

		journalFeedCacheModel.userName = getUserName();

		String userName = journalFeedCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			journalFeedCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			journalFeedCacheModel.createDate = createDate.getTime();
		}
		else {
			journalFeedCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			journalFeedCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			journalFeedCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		journalFeedCacheModel.feedId = getFeedId();

		String feedId = journalFeedCacheModel.feedId;

		if ((feedId != null) && (feedId.length() == 0)) {
			journalFeedCacheModel.feedId = null;
		}

		journalFeedCacheModel.name = getName();

		String name = journalFeedCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			journalFeedCacheModel.name = null;
		}

		journalFeedCacheModel.description = getDescription();

		String description = journalFeedCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			journalFeedCacheModel.description = null;
		}

		journalFeedCacheModel.DDMStructureId = getDDMStructureId();

		journalFeedCacheModel.DDMTemplateKey = getDDMTemplateKey();

		String DDMTemplateKey = journalFeedCacheModel.DDMTemplateKey;

		if ((DDMTemplateKey != null) && (DDMTemplateKey.length() == 0)) {
			journalFeedCacheModel.DDMTemplateKey = null;
		}

		journalFeedCacheModel.DDMRendererTemplateKey =
			getDDMRendererTemplateKey();

		String DDMRendererTemplateKey =
			journalFeedCacheModel.DDMRendererTemplateKey;

		if ((DDMRendererTemplateKey != null) &&
			(DDMRendererTemplateKey.length() == 0)) {

			journalFeedCacheModel.DDMRendererTemplateKey = null;
		}

		journalFeedCacheModel.delta = getDelta();

		journalFeedCacheModel.orderByCol = getOrderByCol();

		String orderByCol = journalFeedCacheModel.orderByCol;

		if ((orderByCol != null) && (orderByCol.length() == 0)) {
			journalFeedCacheModel.orderByCol = null;
		}

		journalFeedCacheModel.orderByType = getOrderByType();

		String orderByType = journalFeedCacheModel.orderByType;

		if ((orderByType != null) && (orderByType.length() == 0)) {
			journalFeedCacheModel.orderByType = null;
		}

		journalFeedCacheModel.targetLayoutFriendlyUrl =
			getTargetLayoutFriendlyUrl();

		String targetLayoutFriendlyUrl =
			journalFeedCacheModel.targetLayoutFriendlyUrl;

		if ((targetLayoutFriendlyUrl != null) &&
			(targetLayoutFriendlyUrl.length() == 0)) {

			journalFeedCacheModel.targetLayoutFriendlyUrl = null;
		}

		journalFeedCacheModel.targetPortletId = getTargetPortletId();

		String targetPortletId = journalFeedCacheModel.targetPortletId;

		if ((targetPortletId != null) && (targetPortletId.length() == 0)) {
			journalFeedCacheModel.targetPortletId = null;
		}

		journalFeedCacheModel.contentField = getContentField();

		String contentField = journalFeedCacheModel.contentField;

		if ((contentField != null) && (contentField.length() == 0)) {
			journalFeedCacheModel.contentField = null;
		}

		journalFeedCacheModel.feedFormat = getFeedFormat();

		String feedFormat = journalFeedCacheModel.feedFormat;

		if ((feedFormat != null) && (feedFormat.length() == 0)) {
			journalFeedCacheModel.feedFormat = null;
		}

		journalFeedCacheModel.feedVersion = getFeedVersion();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			journalFeedCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			journalFeedCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return journalFeedCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<JournalFeed, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<JournalFeed, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<JournalFeed, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((JournalFeed)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, JournalFeed>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					JournalFeed.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _id;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _feedId;
	private String _name;
	private String _description;
	private long _DDMStructureId;
	private String _DDMTemplateKey;
	private String _DDMRendererTemplateKey;
	private int _delta;
	private String _orderByCol;
	private String _orderByType;
	private String _targetLayoutFriendlyUrl;
	private String _targetPortletId;
	private String _contentField;
	private String _feedFormat;
	private double _feedVersion;
	private Date _lastPublishDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<JournalFeed, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((JournalFeed)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("id_", _id);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("feedId", _feedId);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("DDMStructureId", _DDMStructureId);
		_columnOriginalValues.put("DDMTemplateKey", _DDMTemplateKey);
		_columnOriginalValues.put(
			"DDMRendererTemplateKey", _DDMRendererTemplateKey);
		_columnOriginalValues.put("delta", _delta);
		_columnOriginalValues.put("orderByCol", _orderByCol);
		_columnOriginalValues.put("orderByType", _orderByType);
		_columnOriginalValues.put(
			"targetLayoutFriendlyUrl", _targetLayoutFriendlyUrl);
		_columnOriginalValues.put("targetPortletId", _targetPortletId);
		_columnOriginalValues.put("contentField", _contentField);
		_columnOriginalValues.put("feedFormat", _feedFormat);
		_columnOriginalValues.put("feedVersion", _feedVersion);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("id_", "id");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("id_", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("feedId", 1024L);

		columnBitmasks.put("name", 2048L);

		columnBitmasks.put("description", 4096L);

		columnBitmasks.put("DDMStructureId", 8192L);

		columnBitmasks.put("DDMTemplateKey", 16384L);

		columnBitmasks.put("DDMRendererTemplateKey", 32768L);

		columnBitmasks.put("delta", 65536L);

		columnBitmasks.put("orderByCol", 131072L);

		columnBitmasks.put("orderByType", 262144L);

		columnBitmasks.put("targetLayoutFriendlyUrl", 524288L);

		columnBitmasks.put("targetPortletId", 1048576L);

		columnBitmasks.put("contentField", 2097152L);

		columnBitmasks.put("feedFormat", 4194304L);

		columnBitmasks.put("feedVersion", 8388608L);

		columnBitmasks.put("lastPublishDate", 16777216L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private JournalFeed _escapedModel;

}