/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.journal.model.impl;

import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.JournalArticleResourceLocalServiceUtil;

/**
 * The extended model base implementation for the JournalArticleResource service. Represents a row in the &quot;JournalArticleResource&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link JournalArticleResourceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see JournalArticleResourceImpl
 * @see JournalArticleResource
 * @generated
 */
public abstract class JournalArticleResourceBaseImpl
	extends JournalArticleResourceModelImpl implements JournalArticleResource {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a journal article resource model instance should use the <code>JournalArticleResource</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			JournalArticleResourceLocalServiceUtil.addJournalArticleResource(
				this);
		}
		else {
			JournalArticleResourceLocalServiceUtil.updateJournalArticleResource(
				this);
		}
	}

}