/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.journal.model.impl;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;

/**
 * The extended model base implementation for the JournalArticle service. Represents a row in the &quot;JournalArticle&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link JournalArticleImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see JournalArticleImpl
 * @see JournalArticle
 * @generated
 */
public abstract class JournalArticleBaseImpl
	extends JournalArticleModelImpl implements JournalArticle {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a journal article model instance should use the <code>JournalArticle</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			JournalArticleLocalServiceUtil.addJournalArticle(this);
		}
		else {
			JournalArticleLocalServiceUtil.updateJournalArticle(this);
		}
	}

	@Override
	public void updateTreePath(String treePath) {
		JournalArticle journalArticle = this;

		journalArticle.setTreePath(treePath);

		JournalArticleLocalServiceUtil.updateJournalArticle(journalArticle);
	}

}