/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.journal.model.impl;

import com.liferay.journal.model.JournalContentSearch;
import com.liferay.journal.service.JournalContentSearchLocalServiceUtil;

/**
 * The extended model base implementation for the JournalContentSearch service. Represents a row in the &quot;JournalContentSearch&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link JournalContentSearchImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see JournalContentSearchImpl
 * @see JournalContentSearch
 * @generated
 */
public abstract class JournalContentSearchBaseImpl
	extends JournalContentSearchModelImpl implements JournalContentSearch {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a journal content search model instance should use the <code>JournalContentSearch</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			JournalContentSearchLocalServiceUtil.addJournalContentSearch(this);
		}
		else {
			JournalContentSearchLocalServiceUtil.updateJournalContentSearch(
				this);
		}
	}

}