/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.journal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the JournalArticle service. Represents a row in the &quot;JournalArticle&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>JournalArticleModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link JournalArticleImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see JournalArticleImpl
 * @generated
 */
@JSON(strict = true)
public class JournalArticleModelImpl
	extends BaseModelImpl<JournalArticle> implements JournalArticleModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a journal article model instance should use the <code>JournalArticle</code> interface instead.
	 */
	public static final String TABLE_NAME = "JournalArticle";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"id_", Types.BIGINT},
		{"resourcePrimKey", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP},
		{"externalReferenceCode", Types.VARCHAR}, {"folderId", Types.BIGINT},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"treePath", Types.VARCHAR}, {"articleId", Types.VARCHAR},
		{"version", Types.DOUBLE}, {"urlTitle", Types.VARCHAR},
		{"DDMStructureId", Types.BIGINT}, {"DDMTemplateKey", Types.VARCHAR},
		{"defaultLanguageId", Types.VARCHAR}, {"layoutUuid", Types.VARCHAR},
		{"displayDate", Types.TIMESTAMP}, {"expirationDate", Types.TIMESTAMP},
		{"reviewDate", Types.TIMESTAMP}, {"indexable", Types.BOOLEAN},
		{"smallImage", Types.BOOLEAN}, {"smallImageId", Types.BIGINT},
		{"smallImageSource", Types.INTEGER}, {"smallImageURL", Types.VARCHAR},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("id_", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("resourcePrimKey", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("folderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("treePath", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("articleId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("version", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("urlTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("DDMStructureId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("DDMTemplateKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("defaultLanguageId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("layoutUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("reviewDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("indexable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("smallImage", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("smallImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("smallImageSource", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("smallImageURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table JournalArticle (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,id_ LONG not null,resourcePrimKey LONG,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,externalReferenceCode VARCHAR(75) null,folderId LONG,classNameId LONG,classPK LONG,treePath STRING null,articleId VARCHAR(75) null,version DOUBLE,urlTitle VARCHAR(255) null,DDMStructureId LONG,DDMTemplateKey VARCHAR(75) null,defaultLanguageId VARCHAR(75) null,layoutUuid VARCHAR(75) null,displayDate DATE null,expirationDate DATE null,reviewDate DATE null,indexable BOOLEAN,smallImage BOOLEAN,smallImageId LONG,smallImageSource INTEGER,smallImageURL STRING null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (id_, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table JournalArticle";

	public static final String ORDER_BY_JPQL =
		" ORDER BY journalArticle.articleId ASC, journalArticle.version DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY JournalArticle.articleId ASC, JournalArticle.version DESC";

	public static final String ORDER_BY_SQL_INLINE_DISTINCT =
		" ORDER BY journalArticle.articleId ASC, journalArticle.version DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DDMSTRUCTUREID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DDMTEMPLATEKEY_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ARTICLEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DISPLAYDATE_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FOLDERID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long INDEXABLE_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTUUID_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long RESOURCEPRIMKEY_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SMALLIMAGEID_COLUMN_BITMASK = 8192L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 16384L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long URLTITLE_COLUMN_BITMASK = 32768L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 65536L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 131072L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 262144L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public JournalArticleModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _id;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _id;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return JournalArticle.class;
	}

	@Override
	public String getModelClassName() {
		return JournalArticle.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<JournalArticle, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<JournalArticle, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<JournalArticle, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((JournalArticle)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<JournalArticle, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<JournalArticle, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(JournalArticle)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<JournalArticle, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<JournalArticle, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<JournalArticle, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<JournalArticle, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<JournalArticle, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", JournalArticle::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", JournalArticle::getCtCollectionId);
			attributeGetterFunctions.put("uuid", JournalArticle::getUuid);
			attributeGetterFunctions.put("id", JournalArticle::getId);
			attributeGetterFunctions.put(
				"resourcePrimKey", JournalArticle::getResourcePrimKey);
			attributeGetterFunctions.put("groupId", JournalArticle::getGroupId);
			attributeGetterFunctions.put(
				"companyId", JournalArticle::getCompanyId);
			attributeGetterFunctions.put("userId", JournalArticle::getUserId);
			attributeGetterFunctions.put(
				"userName", JournalArticle::getUserName);
			attributeGetterFunctions.put(
				"createDate", JournalArticle::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", JournalArticle::getModifiedDate);
			attributeGetterFunctions.put(
				"externalReferenceCode",
				JournalArticle::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"folderId", JournalArticle::getFolderId);
			attributeGetterFunctions.put(
				"classNameId", JournalArticle::getClassNameId);
			attributeGetterFunctions.put("classPK", JournalArticle::getClassPK);
			attributeGetterFunctions.put(
				"treePath", JournalArticle::getTreePath);
			attributeGetterFunctions.put(
				"articleId", JournalArticle::getArticleId);
			attributeGetterFunctions.put("version", JournalArticle::getVersion);
			attributeGetterFunctions.put(
				"urlTitle", JournalArticle::getUrlTitle);
			attributeGetterFunctions.put(
				"DDMStructureId", JournalArticle::getDDMStructureId);
			attributeGetterFunctions.put(
				"DDMTemplateKey", JournalArticle::getDDMTemplateKey);
			attributeGetterFunctions.put(
				"defaultLanguageId", JournalArticle::getDefaultLanguageId);
			attributeGetterFunctions.put(
				"layoutUuid", JournalArticle::getLayoutUuid);
			attributeGetterFunctions.put(
				"displayDate", JournalArticle::getDisplayDate);
			attributeGetterFunctions.put(
				"expirationDate", JournalArticle::getExpirationDate);
			attributeGetterFunctions.put(
				"reviewDate", JournalArticle::getReviewDate);
			attributeGetterFunctions.put(
				"indexable", JournalArticle::getIndexable);
			attributeGetterFunctions.put(
				"smallImage", JournalArticle::getSmallImage);
			attributeGetterFunctions.put(
				"smallImageId", JournalArticle::getSmallImageId);
			attributeGetterFunctions.put(
				"smallImageSource", JournalArticle::getSmallImageSource);
			attributeGetterFunctions.put(
				"smallImageURL", JournalArticle::getSmallImageURL);
			attributeGetterFunctions.put(
				"lastPublishDate", JournalArticle::getLastPublishDate);
			attributeGetterFunctions.put("status", JournalArticle::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", JournalArticle::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName", JournalArticle::getStatusByUserName);
			attributeGetterFunctions.put(
				"statusDate", JournalArticle::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<JournalArticle, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<JournalArticle, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<JournalArticle, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<JournalArticle, Long>)
					JournalArticle::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<JournalArticle, Long>)
					JournalArticle::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<JournalArticle, String>)JournalArticle::setUuid);
			attributeSetterBiConsumers.put(
				"id", (BiConsumer<JournalArticle, Long>)JournalArticle::setId);
			attributeSetterBiConsumers.put(
				"resourcePrimKey",
				(BiConsumer<JournalArticle, Long>)
					JournalArticle::setResourcePrimKey);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<JournalArticle, Long>)JournalArticle::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<JournalArticle, Long>)JournalArticle::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<JournalArticle, Long>)JournalArticle::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<JournalArticle, Date>)
					JournalArticle::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<JournalArticle, Date>)
					JournalArticle::setModifiedDate);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"folderId",
				(BiConsumer<JournalArticle, Long>)JournalArticle::setFolderId);
			attributeSetterBiConsumers.put(
				"classNameId",
				(BiConsumer<JournalArticle, Long>)
					JournalArticle::setClassNameId);
			attributeSetterBiConsumers.put(
				"classPK",
				(BiConsumer<JournalArticle, Long>)JournalArticle::setClassPK);
			attributeSetterBiConsumers.put(
				"treePath",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setTreePath);
			attributeSetterBiConsumers.put(
				"articleId",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setArticleId);
			attributeSetterBiConsumers.put(
				"version",
				(BiConsumer<JournalArticle, Double>)JournalArticle::setVersion);
			attributeSetterBiConsumers.put(
				"urlTitle",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setUrlTitle);
			attributeSetterBiConsumers.put(
				"DDMStructureId",
				(BiConsumer<JournalArticle, Long>)
					JournalArticle::setDDMStructureId);
			attributeSetterBiConsumers.put(
				"DDMTemplateKey",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setDDMTemplateKey);
			attributeSetterBiConsumers.put(
				"defaultLanguageId",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setDefaultLanguageId);
			attributeSetterBiConsumers.put(
				"layoutUuid",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setLayoutUuid);
			attributeSetterBiConsumers.put(
				"displayDate",
				(BiConsumer<JournalArticle, Date>)
					JournalArticle::setDisplayDate);
			attributeSetterBiConsumers.put(
				"expirationDate",
				(BiConsumer<JournalArticle, Date>)
					JournalArticle::setExpirationDate);
			attributeSetterBiConsumers.put(
				"reviewDate",
				(BiConsumer<JournalArticle, Date>)
					JournalArticle::setReviewDate);
			attributeSetterBiConsumers.put(
				"indexable",
				(BiConsumer<JournalArticle, Boolean>)
					JournalArticle::setIndexable);
			attributeSetterBiConsumers.put(
				"smallImage",
				(BiConsumer<JournalArticle, Boolean>)
					JournalArticle::setSmallImage);
			attributeSetterBiConsumers.put(
				"smallImageId",
				(BiConsumer<JournalArticle, Long>)
					JournalArticle::setSmallImageId);
			attributeSetterBiConsumers.put(
				"smallImageSource",
				(BiConsumer<JournalArticle, Integer>)
					JournalArticle::setSmallImageSource);
			attributeSetterBiConsumers.put(
				"smallImageURL",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setSmallImageURL);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<JournalArticle, Date>)
					JournalArticle::setLastPublishDate);
			attributeSetterBiConsumers.put(
				"status",
				(BiConsumer<JournalArticle, Integer>)JournalArticle::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<JournalArticle, Long>)
					JournalArticle::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<JournalArticle, String>)
					JournalArticle::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<JournalArticle, Date>)
					JournalArticle::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getId() {
		return _id;
	}

	@Override
	public void setId(long id) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_id = id;
	}

	@JSON
	@Override
	public long getResourcePrimKey() {
		return _resourcePrimKey;
	}

	@Override
	public void setResourcePrimKey(long resourcePrimKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_resourcePrimKey = resourcePrimKey;
	}

	@Override
	public boolean isResourceMain() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalResourcePrimKey() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("resourcePrimKey"));
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getFolderId() {
		return _folderId;
	}

	@Override
	public void setFolderId(long folderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_folderId = folderId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFolderId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("folderId"));
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public String getTreePath() {
		if (_treePath == null) {
			return "";
		}
		else {
			return _treePath;
		}
	}

	@Override
	public void setTreePath(String treePath) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_treePath = treePath;
	}

	@JSON
	@Override
	public String getArticleId() {
		if (_articleId == null) {
			return "";
		}
		else {
			return _articleId;
		}
	}

	@Override
	public void setArticleId(String articleId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_articleId = articleId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalArticleId() {
		return getColumnOriginalValue("articleId");
	}

	@JSON
	@Override
	public double getVersion() {
		return _version;
	}

	@Override
	public void setVersion(double version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public double getOriginalVersion() {
		return GetterUtil.getDouble(
			this.<Double>getColumnOriginalValue("version"));
	}

	@JSON
	@Override
	public String getUrlTitle() {
		if (_urlTitle == null) {
			return "";
		}
		else {
			return _urlTitle;
		}
	}

	@Override
	public void setUrlTitle(String urlTitle) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_urlTitle = urlTitle;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUrlTitle() {
		return getColumnOriginalValue("urlTitle");
	}

	@JSON
	@Override
	public long getDDMStructureId() {
		return _DDMStructureId;
	}

	@Override
	public void setDDMStructureId(long DDMStructureId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_DDMStructureId = DDMStructureId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalDDMStructureId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("DDMStructureId"));
	}

	@JSON
	@Override
	public String getDDMTemplateKey() {
		if (_DDMTemplateKey == null) {
			return "";
		}
		else {
			return _DDMTemplateKey;
		}
	}

	@Override
	public void setDDMTemplateKey(String DDMTemplateKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_DDMTemplateKey = DDMTemplateKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalDDMTemplateKey() {
		return getColumnOriginalValue("DDMTemplateKey");
	}

	@JSON
	@Override
	public String getDefaultLanguageId() {
		if (_defaultLanguageId == null) {
			return "";
		}
		else {
			return _defaultLanguageId;
		}
	}

	@Override
	public void setDefaultLanguageId(String defaultLanguageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultLanguageId = defaultLanguageId;
	}

	@JSON
	@Override
	public String getLayoutUuid() {
		if (_layoutUuid == null) {
			return "";
		}
		else {
			return _layoutUuid;
		}
	}

	@Override
	public void setLayoutUuid(String layoutUuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutUuid = layoutUuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalLayoutUuid() {
		return getColumnOriginalValue("layoutUuid");
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalDisplayDate() {
		return getColumnOriginalValue("displayDate");
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	@JSON
	@Override
	public Date getReviewDate() {
		return _reviewDate;
	}

	@Override
	public void setReviewDate(Date reviewDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reviewDate = reviewDate;
	}

	@JSON
	@Override
	public boolean getIndexable() {
		return _indexable;
	}

	@JSON
	@Override
	public boolean isIndexable() {
		return _indexable;
	}

	@Override
	public void setIndexable(boolean indexable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_indexable = indexable;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalIndexable() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("indexable"));
	}

	@JSON
	@Override
	public boolean getSmallImage() {
		return _smallImage;
	}

	@JSON
	@Override
	public boolean isSmallImage() {
		return _smallImage;
	}

	@Override
	public void setSmallImage(boolean smallImage) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_smallImage = smallImage;
	}

	@JSON
	@Override
	public long getSmallImageId() {
		return _smallImageId;
	}

	@Override
	public void setSmallImageId(long smallImageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_smallImageId = smallImageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalSmallImageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("smallImageId"));
	}

	@JSON
	@Override
	public int getSmallImageSource() {
		return _smallImageSource;
	}

	@Override
	public void setSmallImageSource(int smallImageSource) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_smallImageSource = smallImageSource;
	}

	@JSON
	@Override
	public String getSmallImageURL() {
		if (_smallImageURL == null) {
			return "";
		}
		else {
			return _smallImageURL;
		}
	}

	@Override
	public void setSmallImageURL(String smallImageURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_smallImageURL = smallImageURL;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(JournalArticle.class.getName()),
			getClassNameId());
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), JournalArticle.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public JournalArticle toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, JournalArticle>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		JournalArticleImpl journalArticleImpl = new JournalArticleImpl();

		journalArticleImpl.setMvccVersion(getMvccVersion());
		journalArticleImpl.setCtCollectionId(getCtCollectionId());
		journalArticleImpl.setUuid(getUuid());
		journalArticleImpl.setId(getId());
		journalArticleImpl.setResourcePrimKey(getResourcePrimKey());
		journalArticleImpl.setGroupId(getGroupId());
		journalArticleImpl.setCompanyId(getCompanyId());
		journalArticleImpl.setUserId(getUserId());
		journalArticleImpl.setUserName(getUserName());
		journalArticleImpl.setCreateDate(getCreateDate());
		journalArticleImpl.setModifiedDate(getModifiedDate());
		journalArticleImpl.setExternalReferenceCode(getExternalReferenceCode());
		journalArticleImpl.setFolderId(getFolderId());
		journalArticleImpl.setClassNameId(getClassNameId());
		journalArticleImpl.setClassPK(getClassPK());
		journalArticleImpl.setTreePath(getTreePath());
		journalArticleImpl.setArticleId(getArticleId());
		journalArticleImpl.setVersion(getVersion());
		journalArticleImpl.setUrlTitle(getUrlTitle());
		journalArticleImpl.setDDMStructureId(getDDMStructureId());
		journalArticleImpl.setDDMTemplateKey(getDDMTemplateKey());
		journalArticleImpl.setDefaultLanguageId(getDefaultLanguageId());
		journalArticleImpl.setLayoutUuid(getLayoutUuid());
		journalArticleImpl.setDisplayDate(getDisplayDate());
		journalArticleImpl.setExpirationDate(getExpirationDate());
		journalArticleImpl.setReviewDate(getReviewDate());
		journalArticleImpl.setIndexable(isIndexable());
		journalArticleImpl.setSmallImage(isSmallImage());
		journalArticleImpl.setSmallImageId(getSmallImageId());
		journalArticleImpl.setSmallImageSource(getSmallImageSource());
		journalArticleImpl.setSmallImageURL(getSmallImageURL());
		journalArticleImpl.setLastPublishDate(getLastPublishDate());
		journalArticleImpl.setStatus(getStatus());
		journalArticleImpl.setStatusByUserId(getStatusByUserId());
		journalArticleImpl.setStatusByUserName(getStatusByUserName());
		journalArticleImpl.setStatusDate(getStatusDate());

		journalArticleImpl.resetOriginalValues();

		return journalArticleImpl;
	}

	@Override
	public JournalArticle cloneWithOriginalValues() {
		JournalArticleImpl journalArticleImpl = new JournalArticleImpl();

		journalArticleImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		journalArticleImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		journalArticleImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		journalArticleImpl.setId(this.<Long>getColumnOriginalValue("id_"));
		journalArticleImpl.setResourcePrimKey(
			this.<Long>getColumnOriginalValue("resourcePrimKey"));
		journalArticleImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		journalArticleImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		journalArticleImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		journalArticleImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		journalArticleImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		journalArticleImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		journalArticleImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		journalArticleImpl.setFolderId(
			this.<Long>getColumnOriginalValue("folderId"));
		journalArticleImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		journalArticleImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		journalArticleImpl.setTreePath(
			this.<String>getColumnOriginalValue("treePath"));
		journalArticleImpl.setArticleId(
			this.<String>getColumnOriginalValue("articleId"));
		journalArticleImpl.setVersion(
			this.<Double>getColumnOriginalValue("version"));
		journalArticleImpl.setUrlTitle(
			this.<String>getColumnOriginalValue("urlTitle"));
		journalArticleImpl.setDDMStructureId(
			this.<Long>getColumnOriginalValue("DDMStructureId"));
		journalArticleImpl.setDDMTemplateKey(
			this.<String>getColumnOriginalValue("DDMTemplateKey"));
		journalArticleImpl.setDefaultLanguageId(
			this.<String>getColumnOriginalValue("defaultLanguageId"));
		journalArticleImpl.setLayoutUuid(
			this.<String>getColumnOriginalValue("layoutUuid"));
		journalArticleImpl.setDisplayDate(
			this.<Date>getColumnOriginalValue("displayDate"));
		journalArticleImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));
		journalArticleImpl.setReviewDate(
			this.<Date>getColumnOriginalValue("reviewDate"));
		journalArticleImpl.setIndexable(
			this.<Boolean>getColumnOriginalValue("indexable"));
		journalArticleImpl.setSmallImage(
			this.<Boolean>getColumnOriginalValue("smallImage"));
		journalArticleImpl.setSmallImageId(
			this.<Long>getColumnOriginalValue("smallImageId"));
		journalArticleImpl.setSmallImageSource(
			this.<Integer>getColumnOriginalValue("smallImageSource"));
		journalArticleImpl.setSmallImageURL(
			this.<String>getColumnOriginalValue("smallImageURL"));
		journalArticleImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		journalArticleImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		journalArticleImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		journalArticleImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		journalArticleImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return journalArticleImpl;
	}

	@Override
	public int compareTo(JournalArticle journalArticle) {
		int value = 0;

		value = getArticleId().compareTo(journalArticle.getArticleId());

		if (value != 0) {
			return value;
		}

		if (getVersion() < journalArticle.getVersion()) {
			value = -1;
		}
		else if (getVersion() > journalArticle.getVersion()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof JournalArticle)) {
			return false;
		}

		JournalArticle journalArticle = (JournalArticle)object;

		long primaryKey = journalArticle.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<JournalArticle> toCacheModel() {
		JournalArticleCacheModel journalArticleCacheModel =
			new JournalArticleCacheModel();

		journalArticleCacheModel.mvccVersion = getMvccVersion();

		journalArticleCacheModel.ctCollectionId = getCtCollectionId();

		journalArticleCacheModel.uuid = getUuid();

		String uuid = journalArticleCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			journalArticleCacheModel.uuid = null;
		}

		journalArticleCacheModel.id = getId();

		journalArticleCacheModel.resourcePrimKey = getResourcePrimKey();

		journalArticleCacheModel.groupId = getGroupId();

		journalArticleCacheModel.companyId = getCompanyId();

		journalArticleCacheModel.userId = getUserId();

		journalArticleCacheModel.userName = getUserName();

		String userName = journalArticleCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			journalArticleCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			journalArticleCacheModel.createDate = createDate.getTime();
		}
		else {
			journalArticleCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			journalArticleCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			journalArticleCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		journalArticleCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			journalArticleCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			journalArticleCacheModel.externalReferenceCode = null;
		}

		journalArticleCacheModel.folderId = getFolderId();

		journalArticleCacheModel.classNameId = getClassNameId();

		journalArticleCacheModel.classPK = getClassPK();

		journalArticleCacheModel.treePath = getTreePath();

		String treePath = journalArticleCacheModel.treePath;

		if ((treePath != null) && (treePath.length() == 0)) {
			journalArticleCacheModel.treePath = null;
		}

		journalArticleCacheModel.articleId = getArticleId();

		String articleId = journalArticleCacheModel.articleId;

		if ((articleId != null) && (articleId.length() == 0)) {
			journalArticleCacheModel.articleId = null;
		}

		journalArticleCacheModel.version = getVersion();

		journalArticleCacheModel.urlTitle = getUrlTitle();

		String urlTitle = journalArticleCacheModel.urlTitle;

		if ((urlTitle != null) && (urlTitle.length() == 0)) {
			journalArticleCacheModel.urlTitle = null;
		}

		journalArticleCacheModel.DDMStructureId = getDDMStructureId();

		journalArticleCacheModel.DDMTemplateKey = getDDMTemplateKey();

		String DDMTemplateKey = journalArticleCacheModel.DDMTemplateKey;

		if ((DDMTemplateKey != null) && (DDMTemplateKey.length() == 0)) {
			journalArticleCacheModel.DDMTemplateKey = null;
		}

		journalArticleCacheModel.defaultLanguageId = getDefaultLanguageId();

		String defaultLanguageId = journalArticleCacheModel.defaultLanguageId;

		if ((defaultLanguageId != null) && (defaultLanguageId.length() == 0)) {
			journalArticleCacheModel.defaultLanguageId = null;
		}

		journalArticleCacheModel.layoutUuid = getLayoutUuid();

		String layoutUuid = journalArticleCacheModel.layoutUuid;

		if ((layoutUuid != null) && (layoutUuid.length() == 0)) {
			journalArticleCacheModel.layoutUuid = null;
		}

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			journalArticleCacheModel.displayDate = displayDate.getTime();
		}
		else {
			journalArticleCacheModel.displayDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			journalArticleCacheModel.expirationDate = expirationDate.getTime();
		}
		else {
			journalArticleCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date reviewDate = getReviewDate();

		if (reviewDate != null) {
			journalArticleCacheModel.reviewDate = reviewDate.getTime();
		}
		else {
			journalArticleCacheModel.reviewDate = Long.MIN_VALUE;
		}

		journalArticleCacheModel.indexable = isIndexable();

		journalArticleCacheModel.smallImage = isSmallImage();

		journalArticleCacheModel.smallImageId = getSmallImageId();

		journalArticleCacheModel.smallImageSource = getSmallImageSource();

		journalArticleCacheModel.smallImageURL = getSmallImageURL();

		String smallImageURL = journalArticleCacheModel.smallImageURL;

		if ((smallImageURL != null) && (smallImageURL.length() == 0)) {
			journalArticleCacheModel.smallImageURL = null;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			journalArticleCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			journalArticleCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		journalArticleCacheModel.status = getStatus();

		journalArticleCacheModel.statusByUserId = getStatusByUserId();

		journalArticleCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = journalArticleCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			journalArticleCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			journalArticleCacheModel.statusDate = statusDate.getTime();
		}
		else {
			journalArticleCacheModel.statusDate = Long.MIN_VALUE;
		}

		return journalArticleCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<JournalArticle, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<JournalArticle, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<JournalArticle, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((JournalArticle)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, JournalArticle>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					JournalArticle.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _id;
	private long _resourcePrimKey;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _externalReferenceCode;
	private long _folderId;
	private long _classNameId;
	private long _classPK;
	private String _treePath;
	private String _articleId;
	private double _version;
	private String _urlTitle;
	private long _DDMStructureId;
	private String _DDMTemplateKey;
	private String _defaultLanguageId;
	private String _layoutUuid;
	private Date _displayDate;
	private Date _expirationDate;
	private Date _reviewDate;
	private boolean _indexable;
	private boolean _smallImage;
	private long _smallImageId;
	private int _smallImageSource;
	private String _smallImageURL;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<JournalArticle, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((JournalArticle)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("id_", _id);
		_columnOriginalValues.put("resourcePrimKey", _resourcePrimKey);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("folderId", _folderId);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("treePath", _treePath);
		_columnOriginalValues.put("articleId", _articleId);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("urlTitle", _urlTitle);
		_columnOriginalValues.put("DDMStructureId", _DDMStructureId);
		_columnOriginalValues.put("DDMTemplateKey", _DDMTemplateKey);
		_columnOriginalValues.put("defaultLanguageId", _defaultLanguageId);
		_columnOriginalValues.put("layoutUuid", _layoutUuid);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("reviewDate", _reviewDate);
		_columnOriginalValues.put("indexable", _indexable);
		_columnOriginalValues.put("smallImage", _smallImage);
		_columnOriginalValues.put("smallImageId", _smallImageId);
		_columnOriginalValues.put("smallImageSource", _smallImageSource);
		_columnOriginalValues.put("smallImageURL", _smallImageURL);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("id_", "id");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("id_", 8L);

		columnBitmasks.put("resourcePrimKey", 16L);

		columnBitmasks.put("groupId", 32L);

		columnBitmasks.put("companyId", 64L);

		columnBitmasks.put("userId", 128L);

		columnBitmasks.put("userName", 256L);

		columnBitmasks.put("createDate", 512L);

		columnBitmasks.put("modifiedDate", 1024L);

		columnBitmasks.put("externalReferenceCode", 2048L);

		columnBitmasks.put("folderId", 4096L);

		columnBitmasks.put("classNameId", 8192L);

		columnBitmasks.put("classPK", 16384L);

		columnBitmasks.put("treePath", 32768L);

		columnBitmasks.put("articleId", 65536L);

		columnBitmasks.put("version", 131072L);

		columnBitmasks.put("urlTitle", 262144L);

		columnBitmasks.put("DDMStructureId", 524288L);

		columnBitmasks.put("DDMTemplateKey", 1048576L);

		columnBitmasks.put("defaultLanguageId", 2097152L);

		columnBitmasks.put("layoutUuid", 4194304L);

		columnBitmasks.put("displayDate", 8388608L);

		columnBitmasks.put("expirationDate", 16777216L);

		columnBitmasks.put("reviewDate", 33554432L);

		columnBitmasks.put("indexable", 67108864L);

		columnBitmasks.put("smallImage", 134217728L);

		columnBitmasks.put("smallImageId", 268435456L);

		columnBitmasks.put("smallImageSource", 536870912L);

		columnBitmasks.put("smallImageURL", 1073741824L);

		columnBitmasks.put("lastPublishDate", 2147483648L);

		columnBitmasks.put("status", 4294967296L);

		columnBitmasks.put("statusByUserId", 8589934592L);

		columnBitmasks.put("statusByUserName", 17179869184L);

		columnBitmasks.put("statusDate", 34359738368L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private JournalArticle _escapedModel;

}