/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.base.JournalFolderServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=journal", "json.web.service.context.path=JournalFolder"}, service={AopService.class})
public class JournalFolderServiceImpl
extends JournalFolderServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure)")
    private ModelResourcePermission<DDMStructure> _ddmStructureModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalFolder)")
    private ModelResourcePermission<JournalFolder> _journalFolderModelResourcePermission;

    public JournalFolder addFolder(long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionHelper.check(this._journalFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)parentFolderId, (String)"ADD_FOLDER");
        return this.journalFolderLocalService.addFolder(this.getUserId(), groupId, parentFolderId, name, description, serviceContext);
    }

    public void deleteFolder(long folderId) throws PortalException {
        this._journalFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.journalFolderLocalService.getFolder(folderId), "DELETE");
        this.journalFolderLocalService.deleteFolder(folderId);
    }

    public void deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        this._journalFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.journalFolderLocalService.getFolder(folderId), "DELETE");
        this.journalFolderLocalService.deleteFolder(folderId, includeTrashedEntries);
    }

    public JournalFolder fetchFolder(long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.fetchFolder(folderId);
        if (folder != null) {
            this._journalFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)folder, "VIEW");
        }
        return folder;
    }

    public List<DDMStructure> getDDMStructures(long[] groupIds, long folderId, int restrictionType) throws PortalException {
        return this.filterStructures(this.journalFolderLocalService.getDDMStructures(groupIds, folderId, restrictionType));
    }

    public List<DDMStructure> getDDMStructures(long[] groupIds, long folderId, int restrictionType, OrderByComparator<DDMStructure> orderByComparator) throws PortalException {
        return this.filterStructures(this.journalFolderLocalService.getDDMStructures(groupIds, folderId, restrictionType, orderByComparator));
    }

    public JournalFolder getFolder(long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.getFolder(folderId);
        this._journalFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)folder, "VIEW");
        return folder;
    }

    public List<Long> getFolderIds(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionHelper.check(this._journalFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW");
        List<Long> folderIds = this.getSubfolderIds(groupId, folderId, true);
        folderIds.add(0, folderId);
        return folderIds;
    }

    public List<JournalFolder> getFolders(long groupId) {
        return this.journalFolderPersistence.filterFindByGroupId(groupId);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId) {
        return this.getFolders(groupId, parentFolderId, 0);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status) {
        return this.journalFolderPersistence.filterFindByG_P_S(groupId, parentFolderId, status);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int start, int end) {
        return this.getFolders(groupId, parentFolderId, 0, start, end);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status, int start, int end) {
        return this.journalFolderPersistence.filterFindByG_P_S(groupId, parentFolderId, status, start, end);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int status, int start, int end, OrderByComparator<?> obc) {
        return this.getFoldersAndArticles(groupId, 0L, folderId, status, start, end, obc);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int start, int end, OrderByComparator<?> obc) {
        return this.getFoldersAndArticles(groupId, folderId, -1, start, end, obc);
    }

    public List<Object> getFoldersAndArticles(long groupId, long userId, long folderId, int status, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, true, start, end, obc);
        return this.journalFolderFinder.filterFindF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndArticles(long groupId, long userId, long folderId, int status, Locale locale, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, true, start, end, obc);
        return this.journalFolderFinder.filterFindF_A_ByG_F_L(groupId, folderId, locale, queryDefinition);
    }

    public int getFoldersAndArticlesCount(long groupId, List<Long> folderIds, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.journalArticleFinder.filterCountByG_F(groupId, folderIds, queryDefinition);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int articlesCount = this.journalArticleFinder.filterCountByG_F(groupId, folderIds.subList(start, end), queryDefinition);
        List<Long> sublist = folderIds.subList(start, end);
        sublist.clear();
        return articlesCount += this.getFoldersAndArticlesCount(groupId, folderIds, status);
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId) {
        return this.getFoldersAndArticlesCount(groupId, folderId, -1);
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId, int status) {
        return this.getFoldersAndArticlesCount(groupId, 0L, folderId, status);
    }

    public int getFoldersAndArticlesCount(long groupId, long userId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, true);
        return this.journalFolderFinder.filterCountF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) {
        return this.getFoldersCount(groupId, parentFolderId, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status) {
        if (status == -1) {
            return this.journalFolderPersistence.filterCountByG_P_NotS(groupId, parentFolderId, 8);
        }
        return this.journalFolderPersistence.filterCountByG_P_S(groupId, parentFolderId, status);
    }

    @Deprecated
    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) {
        this.getSubfolderIds(folderIds, groupId, folderId, true);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId, boolean recurse) {
        List folders = this.journalFolderPersistence.filterFindByG_P_NotS(groupId, folderId, 8);
        for (JournalFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            if (!recurse) continue;
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId(), recurse);
        }
    }

    public List<Long> getSubfolderIds(long groupId, long folderId, boolean recurse) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        this.getSubfolderIds(folderIds, groupId, folderId, recurse);
        return folderIds;
    }

    public JournalFolder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        this._journalFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.journalFolderLocalService.getFolder(folderId), "UPDATE");
        return this.journalFolderLocalService.moveFolder(folderId, parentFolderId, serviceContext);
    }

    public JournalFolder moveFolderFromTrash(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        this._journalFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.journalFolderLocalService.getFolder(folderId), "UPDATE");
        return this.journalFolderLocalService.moveFolderFromTrash(this.getUserId(), folderId, parentFolderId, serviceContext);
    }

    public JournalFolder moveFolderToTrash(long folderId) throws PortalException {
        this._journalFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.journalFolderLocalService.getFolder(folderId), "DELETE");
        return this.journalFolderLocalService.moveFolderToTrash(this.getUserId(), folderId);
    }

    public void restoreFolderFromTrash(long folderId) throws PortalException {
        this._journalFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.journalFolderLocalService.getFolder(folderId), "UPDATE");
        this.journalFolderLocalService.restoreFolderFromTrash(this.getUserId(), folderId);
    }

    public List<DDMStructure> searchDDMStructures(long companyId, long[] groupIds, long folderId, int restrictionType, String keywords, int start, int end, OrderByComparator<DDMStructure> obc) throws PortalException {
        return this.filterStructures(this.journalFolderLocalService.searchDDMStructures(companyId, groupIds, folderId, restrictionType, keywords, start, end, obc));
    }

    public void subscribe(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionHelper.check(this._journalFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"SUBSCRIBE");
        this.journalFolderLocalService.subscribe(this.getUserId(), groupId, folderId);
    }

    public void unsubscribe(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionHelper.check(this._journalFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"SUBSCRIBE");
        this.journalFolderLocalService.unsubscribe(this.getUserId(), groupId, folderId);
    }

    public JournalFolder updateFolder(long groupId, long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        this._journalFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.journalFolderLocalService.getFolder(folderId), "UPDATE");
        return this.journalFolderLocalService.updateFolder(this.getUserId(), groupId, folderId, parentFolderId, name, description, mergeWithParentFolder, serviceContext);
    }

    public JournalFolder updateFolder(long groupId, long folderId, long parentFolderId, String name, String description, long[] ddmStructureIds, int restrictionType, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionHelper.check(this._journalFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"UPDATE");
        return this.journalFolderLocalService.updateFolder(this.getUserId(), groupId, folderId, parentFolderId, name, description, ddmStructureIds, restrictionType, mergeWithParentFolder, serviceContext);
    }

    protected List<DDMStructure> filterStructures(List<DDMStructure> ddmStructures) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        ddmStructures = ListUtil.copy(ddmStructures);
        Iterator itr = ddmStructures.iterator();
        while (itr.hasNext()) {
            DDMStructure ddmStructure = (DDMStructure)itr.next();
            if (this._ddmStructureModelResourcePermission.contains(permissionChecker, (ClassedModel)ddmStructure, "VIEW")) continue;
            itr.remove();
        }
        return ddmStructures;
    }
}

