/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.model.DDMStructureLinkModel;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.exception.NoSuchFolderException;
import com.liferay.journal.internal.util.JournalTreePathUtil;
import com.liferay.journal.internal.validation.JournalFolderModelValidator;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.base.JournalFolderLocalServiceBaseImpl;
import com.liferay.journal.util.JournalValidator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.validation.ModelValidator;
import com.liferay.portal.validation.ModelValidatorRegistryUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.model.TrashVersion;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalFolder"}, service={AopService.class})
public class JournalFolderLocalServiceImpl
extends JournalFolderLocalServiceBaseImpl {
    @Deprecated
    @Reference
    protected com.liferay.portal.kernel.service.SubscriptionLocalService subscriptionLocalService;
    @Reference
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalValidator _journalValidator;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashHelper _trashHelper;

    public JournalFolder addFolder(long userId, long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        this.validateFolder(0L, groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        JournalFolder folder = this.journalFolderPersistence.create(folderId);
        folder.setUuid(serviceContext.getUuid());
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setUserName(user.getFullName());
        folder.setParentFolderId(parentFolderId);
        folder.setTreePath(folder.buildTreePath());
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        folder = (JournalFolder)this.journalFolderPersistence.update((BaseModel)folder);
        this.resourceLocalService.addModelResources((AuditedModel)folder, serviceContext);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public JournalFolder deleteFolder(JournalFolder folder) throws PortalException {
        return this.deleteFolder(folder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public JournalFolder deleteFolder(JournalFolder folder, boolean includeTrashedEntries) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink;
        List folders = this.journalFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
        for (JournalFolder curFolder : folders) {
            if (!includeTrashedEntries && curFolder.isInTrashExplicitly()) continue;
            this.journalFolderLocalService.deleteFolder(curFolder, includeTrashedEntries);
        }
        this.journalFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource((AuditedModel)folder, 4);
        this._journalArticleLocalService.deleteArticles(folder.getGroupId(), folder.getFolderId(), includeTrashedEntries);
        this.assetEntryLocalService.deleteEntry(JournalFolder.class.getName(), folder.getFolderId());
        this.expandoValueLocalService.deleteValues(JournalFolder.class.getName(), folder.getFolderId());
        this.ratingsStatsLocalService.deleteStats(JournalFolder.class.getName(), folder.getFolderId());
        if (folder.isInTrashExplicitly()) {
            this.trashEntryLocalService.deleteEntry(JournalFolder.class.getName(), folder.getFolderId());
        } else {
            this.trashVersionLocalService.deleteTrashVersion(JournalFolder.class.getName(), folder.getFolderId());
        }
        List ddmStructureLinks = this._ddmStructureLinkLocalService.getStructureLinks(this.classNameLocalService.getClassNameId(JournalFolder.class), folder.getFolderId());
        if (ddmStructureLinks.isEmpty() && (workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(folder.getCompanyId(), folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), -1L)) != null) {
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
        for (DDMStructureLink ddmStructureLink : ddmStructureLinks) {
            this._ddmStructureLinkLocalService.deleteStructureLink(ddmStructureLink.getStructureLinkId());
            WorkflowDefinitionLink workflowDefinitionLink2 = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(folder.getCompanyId(), folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), ddmStructureLink.getStructureId());
            if (workflowDefinitionLink2 == null) continue;
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink2);
        }
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    public JournalFolder deleteFolder(long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        return this.journalFolderLocalService.deleteFolder(folder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    public JournalFolder deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        return this.journalFolderLocalService.deleteFolder(folder, includeTrashedEntries);
    }

    public void deleteFolders(long groupId) throws PortalException {
        List folders = this.journalFolderPersistence.findByGroupId(groupId);
        for (JournalFolder folder : folders) {
            this.journalFolderLocalService.deleteFolder(folder);
        }
    }

    public JournalFolder fetchFolder(long folderId) {
        return this.journalFolderPersistence.fetchByPrimaryKey(folderId);
    }

    public JournalFolder fetchFolder(long groupId, long parentFolderId, String name) {
        return this.journalFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
    }

    public JournalFolder fetchFolder(long groupId, String name) {
        return this.journalFolderPersistence.fetchByG_N(groupId, name);
    }

    public List<JournalFolder> getCompanyFolders(long companyId, int start, int end) {
        return this.journalFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) {
        return this.journalFolderPersistence.countByCompanyId(companyId);
    }

    public List<DDMStructure> getDDMStructures(long[] groupIds, long folderId, int restrictionType) throws PortalException {
        return this.getDDMStructures(groupIds, folderId, restrictionType, null);
    }

    public List<DDMStructure> getDDMStructures(long[] groupIds, long folderId, int restrictionType, OrderByComparator<DDMStructure> orderByComparator) throws PortalException {
        if (restrictionType == 1) {
            return this._ddmStructureLinkLocalService.getStructureLinkStructures(this.classNameLocalService.getClassNameId(JournalFolder.class), folderId);
        }
        if ((folderId = this.getOverridedDDMStructuresFolderId(folderId)) != 0L) {
            return this._ddmStructureLinkLocalService.getStructureLinkStructures(this.classNameLocalService.getClassNameId(JournalFolder.class), folderId);
        }
        long classNameId = this.classNameLocalService.getClassNameId(JournalArticle.class);
        return this._ddmStructureLocalService.getStructures(groupIds, classNameId, orderByComparator);
    }

    public JournalFolder getFolder(long folderId) throws PortalException {
        return this.journalFolderPersistence.findByPrimaryKey(folderId);
    }

    public List<JournalFolder> getFolders(long groupId) {
        return this.journalFolderPersistence.findByGroupId(groupId);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId) {
        return this.getFolders(groupId, parentFolderId, 0);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status) {
        return this.journalFolderPersistence.findByG_P_S(groupId, parentFolderId, status);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int start, int end) {
        return this.getFolders(groupId, parentFolderId, 0, start, end);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status, int start, int end) {
        return this.journalFolderPersistence.findByG_P_S(groupId, parentFolderId, status, start, end);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.journalFolderFinder.findF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.journalFolderFinder.findF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int status, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalFolderFinder.findF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int start, int end, OrderByComparator<?> obc) {
        return this.getFoldersAndArticles(groupId, folderId, -1, start, end, obc);
    }

    public int getFoldersAndArticlesCount(long groupId, List<Long> folderIds, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int articlesCount = this.journalArticleFinder.countByG_F(groupId, folderIds.subList(start, end), queryDefinition);
        List<Long> sublist = folderIds.subList(start, end);
        sublist.clear();
        return articlesCount += this.getFoldersAndArticlesCount(groupId, folderIds, status);
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.journalFolderFinder.countF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status, 0L, false);
        return this.journalFolderFinder.countF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) {
        return this.getFoldersCount(groupId, parentFolderId, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status) {
        return this.journalFolderPersistence.countByG_P_S(groupId, parentFolderId, status);
    }

    public long getInheritedWorkflowFolderId(long folderId) throws NoSuchFolderException {
        JournalFolder folder;
        while (folderId != 0L && (folder = this.journalFolderPersistence.findByPrimaryKey(folderId)).getRestrictionType() == 0) {
            folderId = folder.getParentFolderId();
        }
        return folderId;
    }

    public List<JournalFolder> getNoAssetFolders() {
        return this.journalFolderFinder.findF_ByNoAssets();
    }

    public long getOverridedDDMStructuresFolderId(long folderId) throws NoSuchFolderException {
        JournalFolder folder;
        while (folderId != 0L && (folder = this.journalFolderPersistence.findByPrimaryKey(folderId)).getRestrictionType() != 1) {
            folderId = folder.getParentFolderId();
        }
        return folderId;
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) {
        List folders = this.journalFolderPersistence.findByG_P(groupId, folderId);
        for (JournalFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    @Deprecated
    public com.liferay.portal.kernel.service.SubscriptionLocalService getSubscriptionLocalService() {
        return this.subscriptionLocalService;
    }

    public String getUniqueFolderName(String uuid, long groupId, long parentFolderId, String name, int count) {
        JournalFolder folder = this.journalFolderLocalService.fetchFolder(groupId, parentFolderId, name);
        if (folder == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(folder.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getUniqueFolderName(uuid, groupId, parentFolderId, name, ++count);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalFolder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        this.validateParentFolder(folder, parentFolderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        if (folder.getParentFolderId() == parentFolderId) {
            return folder;
        }
        this.validateFolderDDMStructures(folder.getFolderId(), parentFolderId);
        this.validateFolder(folder.getFolderId(), folder.getGroupId(), parentFolderId, folder.getName());
        folder.setParentFolderId(parentFolderId);
        folder.setTreePath(folder.buildTreePath());
        folder.setExpandoBridgeAttributes(serviceContext);
        folder = (JournalFolder)this.journalFolderPersistence.update((BaseModel)folder);
        this.rebuildTree(folder.getCompanyId(), folderId, folder.getTreePath(), true);
        return folder;
    }

    public JournalFolder moveFolderFromTrash(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        if (!folder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (folder.isInTrashExplicitly()) {
            this.restoreFolderFromTrash(userId, folderId);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(JournalFolder.class.getName(), folderId);
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, folder, status);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            List foldersAndArticles = this.journalFolderLocalService.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId(), 8);
            this.restoreDependentsFromTrash(foldersAndArticles);
        }
        return this.journalFolderLocalService.moveFolder(folderId, parentFolderId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalFolder moveFolderToTrash(long userId, long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        if (folder.isInTrash()) {
            throw new TrashEntryException();
        }
        String title = folder.getName();
        folder = this.updateStatus(userId, folder, 8);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", folder.getName());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), folder.getUuid(), null, 0, null, typeSettingsProperties);
        folder.setName(this._trashHelper.getTrashTitle(trashEntry.getEntryId()));
        folder = (JournalFolder)this.journalFolderPersistence.update((BaseModel)folder);
        List foldersAndArticles = this.journalFolderLocalService.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId());
        this.moveDependentsToTrash(foldersAndArticles, trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)title);
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)folder, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        return folder;
    }

    public void rebuildTree(long companyId) throws PortalException {
        this.rebuildTree(companyId, 0L, "/", false);
    }

    public void rebuildTree(long companyId, long parentFolderId, String parentTreePath, boolean reindex) throws PortalException {
        JournalTreePathUtil.rebuildTree(companyId, parentFolderId, parentTreePath, this.journalFolderPersistence, this._journalArticleLocalService);
    }

    public void restoreFolderFromTrash(long userId, long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        if (!folder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        String originalName = this._trashHelper.getOriginalTitle(folder.getName());
        folder.setName(this.journalFolderLocalService.getUniqueFolderName(folder.getUuid(), folder.getGroupId(), folder.getParentFolderId(), originalName, 2));
        folder = (JournalFolder)this.journalFolderPersistence.update((BaseModel)folder);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(JournalFolder.class.getName(), folderId);
        this.updateStatus(userId, folder, trashEntry.getStatus());
        List foldersAndArticles = this.journalFolderLocalService.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId(), 8);
        this.restoreDependentsFromTrash(foldersAndArticles);
        this.trashEntryLocalService.deleteEntry(JournalFolder.class.getName(), folder.getFolderId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)folder.getName());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)folder, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
    }

    public List<DDMStructure> searchDDMStructures(long companyId, long[] groupIds, long folderId, int restrictionType, String keywords, int start, int end, OrderByComparator<DDMStructure> obc) throws PortalException {
        if (restrictionType == 1) {
            return this._ddmStructureLocalService.search(companyId, groupIds, this.classNameLocalService.getClassNameId(JournalFolder.class), folderId, keywords, start, end, obc);
        }
        if ((folderId = this.getOverridedDDMStructuresFolderId(folderId)) != 0L) {
            return this._ddmStructureLocalService.search(companyId, groupIds, this.classNameLocalService.getClassNameId(JournalFolder.class), folderId, keywords, start, end, obc);
        }
        return this._ddmStructureLocalService.search(companyId, groupIds, this.classNameLocalService.getClassNameId(JournalArticle.class), keywords, -1, start, end, obc);
    }

    @Deprecated
    public void setSubscriptionLocalService(com.liferay.portal.kernel.service.SubscriptionLocalService subscriptionLocalService) {
        this.subscriptionLocalService = subscriptionLocalService;
    }

    public void subscribe(long userId, long groupId, long folderId) throws PortalException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this._subscriptionLocalService.addSubscription(userId, groupId, JournalFolder.class.getName(), folderId);
    }

    public void unsubscribe(long userId, long groupId, long folderId) throws PortalException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this._subscriptionLocalService.deleteSubscription(userId, JournalFolder.class.getName(), folderId);
    }

    public void updateAsset(long userId, JournalFolder folder, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, folder.getGroupId(), folder.getCreateDate(), folder.getModifiedDate(), JournalFolder.class.getName(), folder.getFolderId(), folder.getUuid(), 0L, assetCategoryIds, assetTagNames, true, true, null, null, folder.getCreateDate(), null, "text/plain", folder.getName(), folder.getDescription(), null, null, null, 0, 0, priority);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalFolder updateFolder(long userId, long groupId, long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        return this.updateFolder(userId, groupId, folderId, parentFolderId, name, description, new long[0], 0, mergeWithParentFolder, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalFolder updateFolder(long userId, long groupId, long folderId, long parentFolderId, String name, String description, long[] ddmStructureIds, int restrictionType, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        JournalFolder folder = null;
        Set<Object> originalDDMStructureIds = new HashSet();
        if (folderId > 0L) {
            originalDDMStructureIds = this.getDDMStructureIds(this._ddmStructureLinkLocalService.getStructureLinks(this.classNameLocalService.getClassNameId(JournalFolder.class), folderId));
            folder = this.doUpdateFolder(userId, folderId, parentFolderId, name, description, ddmStructureIds, restrictionType, mergeWithParentFolder, serviceContext);
        }
        ArrayList<ObjectValuePair> workflowDefinitionOVPs = new ArrayList<ObjectValuePair>();
        if (restrictionType == 1) {
            workflowDefinitionOVPs.add(new ObjectValuePair((Object)-1L, (Object)""));
            for (long ddmStructureId : ddmStructureIds) {
                String workflowDefinition = ParamUtil.getString((ServiceContext)serviceContext, (String)("workflowDefinition" + ddmStructureId));
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)ddmStructureId, (Object)workflowDefinition));
            }
        } else if (restrictionType == 0) {
            if (originalDDMStructureIds.isEmpty()) {
                originalDDMStructureIds.add(-1L);
            }
            Iterator<Object> iterator = originalDDMStructureIds.iterator();
            while (iterator.hasNext()) {
                long originalDDMStructureId = (Long)iterator.next();
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)originalDDMStructureId, (Object)""));
            }
        } else if (restrictionType == 2) {
            String workflowDefinition = ParamUtil.getString((ServiceContext)serviceContext, (String)"workflowDefinition-1");
            workflowDefinitionOVPs.add(new ObjectValuePair((Object)-1L, (Object)workflowDefinition));
            Iterator<Object> iterator = originalDDMStructureIds.iterator();
            while (iterator.hasNext()) {
                long originalDDMStructureId = (Long)iterator.next();
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)originalDDMStructureId, (Object)""));
            }
        }
        this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLinks(userId, serviceContext.getCompanyId(), groupId, JournalFolder.class.getName(), folderId, workflowDefinitionOVPs);
        return folder;
    }

    public void updateFolderDDMStructures(JournalFolder folder, long[] ddmStructureIdsArray) throws PortalException {
        List ddmStructureLinks;
        Set<Long> originalDDMStructureIds;
        Set ddmStructureIds = SetUtil.fromArray((long[])ddmStructureIdsArray);
        if (ddmStructureIds.equals(originalDDMStructureIds = this.getDDMStructureIds(ddmStructureLinks = this._ddmStructureLinkLocalService.getStructureLinks(this.classNameLocalService.getClassNameId(JournalFolder.class), folder.getFolderId())))) {
            return;
        }
        for (Long ddmStructureId : ddmStructureIds) {
            if (originalDDMStructureIds.contains(ddmStructureId)) continue;
            this._ddmStructureLinkLocalService.addStructureLink(this.classNameLocalService.getClassNameId(JournalFolder.class), folder.getFolderId(), ddmStructureId.longValue());
        }
        for (Long originalDDMStructureId : originalDDMStructureIds) {
            if (ddmStructureIds.contains(originalDDMStructureId)) continue;
            this._ddmStructureLinkLocalService.deleteStructureLink(this.classNameLocalService.getClassNameId(JournalFolder.class), folder.getFolderId(), originalDDMStructureId.longValue());
        }
    }

    public JournalFolder updateStatus(long userId, JournalFolder folder, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        folder.setStatus(status);
        folder.setStatusByUserId(userId);
        folder.setStatusByUserName(user.getFullName());
        folder.setStatusDate(new Date());
        folder = (JournalFolder)this.journalFolderPersistence.update((BaseModel)folder);
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), true);
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), false);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
        indexer.reindex((Object)folder);
        return folder;
    }

    public void validateFolderDDMStructures(long folderId, long parentFolderId) throws PortalException {
        JournalFolderModelValidator journalFolderModelValidator = this._getJournalFolderModelValidator();
        journalFolderModelValidator.validateFolderDDMStructures(folderId, parentFolderId);
    }

    protected JournalFolder doUpdateFolder(long userId, long folderId, long parentFolderId, String name, String description, long[] ddmStructureIds, int restrictionType, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        JournalFolder restrictedAncestorFolder;
        if (restrictionType != 1 && parentFolderId != 0L && (restrictedAncestorFolder = this._getRestrictedAncestorFolder(this.getFolder(parentFolderId))) != null) {
            List ancestorDDMStructureLinks = this._ddmStructureLinkLocalService.getStructureLinks(this.classNameLocalService.getClassNameId(JournalFolder.class), restrictedAncestorFolder.getFolderId());
            Stream ancestorDDMStructureLinksStream = ancestorDDMStructureLinks.stream();
            long[] ancestorDDMStructureIds = ancestorDDMStructureLinksStream.mapToLong(DDMStructureLinkModel::getStructureId).toArray();
            this.validateArticleDDMStructures(folderId, ancestorDDMStructureIds);
        }
        this.validateArticleDDMStructures(folderId, ddmStructureIds);
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        if (mergeWithParentFolder && folderId != parentFolderId) {
            this.mergeFolders(folder, parentFolderId);
            return folder;
        }
        this.validateFolder(folderId, folder.getGroupId(), parentFolderId, name);
        long oldParentFolderId = folder.getParentFolderId();
        if (oldParentFolderId != parentFolderId) {
            folder.setParentFolderId(parentFolderId);
            folder.setTreePath(folder.buildTreePath());
        }
        folder.setName(name);
        folder.setDescription(description);
        folder.setRestrictionType(restrictionType);
        folder.setExpandoBridgeAttributes(serviceContext);
        folder = (JournalFolder)this.journalFolderPersistence.update((BaseModel)folder);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        if (ddmStructureIds != null) {
            this.updateFolderDDMStructures(folder, ddmStructureIds);
        }
        if (oldParentFolderId != parentFolderId) {
            this.rebuildTree(folder.getCompanyId(), folderId, folder.getTreePath(), true);
            folder = this.journalFolderPersistence.findByPrimaryKey(folder.getPrimaryKey());
        }
        return folder;
    }

    protected Set<Long> getDDMStructureIds(List<DDMStructureLink> ddmStructureLinks) {
        HashSet<Long> ddmStructureIds = new HashSet<Long>();
        for (DDMStructureLink ddmStructureLink : ddmStructureLinks) {
            ddmStructureIds.add(ddmStructureLink.getStructureId());
        }
        return ddmStructureIds;
    }

    protected long getParentFolderId(JournalFolder folder, long parentFolderId) {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        JournalFolder parentFolder = this.journalFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) {
        JournalFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.journalFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void mergeFolders(JournalFolder fromFolder, long toFolderId) throws PortalException {
        List folders = this.journalFolderPersistence.findByG_P(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (JournalFolder folder : folders) {
            this.mergeFolders(folder, toFolderId);
        }
        List articles = this.journalArticlePersistence.findByG_F(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (JournalArticle article : articles) {
            article.setFolderId(toFolderId);
            article.setTreePath(article.buildTreePath());
            article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            indexer.reindex((Object)article);
        }
        this.journalFolderLocalService.deleteFolder(fromFolder);
    }

    protected void moveDependentsToTrash(List<Object> foldersAndArticles, long trashEntryId) throws PortalException {
        for (Object object : foldersAndArticles) {
            JournalFolder folder;
            if (object instanceof JournalArticle) {
                JournalArticle article = (JournalArticle)object;
                if (article.getStatus() == 8) continue;
                List articles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
                for (JournalArticle curArticle : articles) {
                    int curArticleOldStatus = curArticle.getStatus();
                    curArticle.setStatus(8);
                    curArticle = (JournalArticle)this.journalArticlePersistence.update((BaseModel)curArticle);
                    int status = curArticleOldStatus;
                    if (curArticleOldStatus == 1) {
                        status = 2;
                    }
                    if (curArticleOldStatus != 0) {
                        this.trashVersionLocalService.addTrashVersion(trashEntryId, JournalArticle.class.getName(), curArticle.getId(), status, null);
                    }
                    if (curArticleOldStatus != 1) continue;
                    this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(curArticle.getCompanyId(), curArticle.getGroupId(), JournalArticle.class.getName(), curArticle.getId());
                }
                this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
                indexer.reindex((Object)article);
                continue;
            }
            if (!(object instanceof JournalFolder) || (folder = (JournalFolder)object).isInTrashExplicitly()) continue;
            int oldStatus = folder.getStatus();
            folder.setStatus(8);
            folder = (JournalFolder)this.journalFolderPersistence.update((BaseModel)folder);
            if (oldStatus != 0) {
                this.trashVersionLocalService.addTrashVersion(trashEntryId, JournalFolder.class.getName(), folder.getFolderId(), oldStatus, null);
            }
            List<Object> curFoldersAndArticles = this.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId());
            this.moveDependentsToTrash(curFoldersAndArticles, trashEntryId);
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), false);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
            indexer.reindex((Object)folder);
        }
    }

    protected void restoreDependentsFromTrash(List<Object> foldersAndArticles) throws PortalException {
        for (Object object : foldersAndArticles) {
            JournalFolder folder;
            Indexer indexer;
            int oldStatus;
            TrashVersion trashVersion;
            if (object instanceof JournalArticle) {
                JournalArticle article = (JournalArticle)object;
                if (!article.isInTrashImplicitly()) continue;
                trashVersion = this.trashVersionLocalService.fetchVersion(JournalArticle.class.getName(), article.getId());
                oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                List articles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
                for (JournalArticle curArticle : articles) {
                    trashVersion = this.trashVersionLocalService.fetchVersion(JournalArticle.class.getName(), curArticle.getId());
                    int curArticleOldStatus = 0;
                    if (trashVersion != null) {
                        curArticleOldStatus = trashVersion.getStatus();
                    }
                    curArticle.setStatus(curArticleOldStatus);
                    this.journalArticlePersistence.update((BaseModel)curArticle);
                    if (trashVersion == null) continue;
                    this.trashVersionLocalService.deleteTrashVersion(trashVersion);
                }
                if (oldStatus == 0) {
                    this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), true);
                }
                indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
                indexer.reindex((Object)article);
                continue;
            }
            if (!(object instanceof JournalFolder) || !(folder = (JournalFolder)object).isInTrashImplicitly()) continue;
            trashVersion = this.trashVersionLocalService.fetchVersion(JournalFolder.class.getName(), folder.getFolderId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            folder.setStatus(oldStatus);
            folder = (JournalFolder)this.journalFolderPersistence.update((BaseModel)folder);
            List<Object> curFoldersAndArticles = this.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId(), 8);
            this.restoreDependentsFromTrash(curFoldersAndArticles);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), true);
            indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
            indexer.reindex((Object)folder);
        }
    }

    protected void validateArticleDDMStructures(long folderId, long[] ddmStructureIds) throws PortalException {
        JournalFolderModelValidator journalFolderModelValidator = this._getJournalFolderModelValidator();
        journalFolderModelValidator.validateArticleDDMStructures(folderId, ddmStructureIds);
    }

    protected void validateFolder(long folderId, long groupId, long parentFolderId, String name) throws PortalException {
        JournalFolderModelValidator journalFolderModelValidator = this._getJournalFolderModelValidator();
        journalFolderModelValidator.validateFolder(folderId, groupId, parentFolderId, name);
    }

    protected void validateParentFolder(JournalFolder folder, long parentFolderId) throws PortalException {
        JournalFolderModelValidator journalFolderModelValidator = this._getJournalFolderModelValidator();
        journalFolderModelValidator.validateParentFolder(folder, parentFolderId);
    }

    private JournalFolderModelValidator _getJournalFolderModelValidator() {
        ModelValidator modelValidator = ModelValidatorRegistryUtil.getModelValidator(JournalFolder.class);
        return (JournalFolderModelValidator)modelValidator;
    }

    private JournalFolder _getRestrictedAncestorFolder(JournalFolder folder) throws PortalException {
        if (folder.getRestrictionType() == 1) {
            return folder;
        }
        if (folder.isRoot()) {
            return null;
        }
        return this._getRestrictedAncestorFolder(folder.getParentFolder());
    }
}

