/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.util;

import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.internal.transformer.JournalTransformer;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portlet.ThemeDisplayModel;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class JournalUtil {
    public static final String[] SELECTED_FIELD_NAMES = new String[]{"articleId", "companyId", "groupId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(JournalUtil.class);
    private static Map<String, String> _customTokens;
    private static final JournalTransformer _journalTransformer;

    public static void addAllReservedEls(Element rootElement, Map<String, String> tokens, JournalArticle article, String languageId, ThemeDisplay themeDisplay) {
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-id", article.getArticleId());
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-version", article.getVersion());
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-title", article.getTitle(languageId));
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-url-title", article.getUrlTitle());
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-description", article.getDescription(languageId));
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-create-date", article.getCreateDate());
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-modified-date", article.getModifiedDate());
        if (article.getDisplayDate() != null) {
            JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-display-date", article.getDisplayDate());
        }
        String smallImageURL = "";
        if (Validator.isNotNull((String)article.getSmallImageURL())) {
            smallImageURL = article.getSmallImageURL();
        } else if (themeDisplay != null && article.isSmallImage()) {
            StringBundler sb = new StringBundler(5);
            sb.append(themeDisplay.getPathImage());
            sb.append("/journal/article?img_id=");
            sb.append(article.getSmallImageId());
            sb.append("&t=");
            sb.append(WebServerServletTokenUtil.getToken((long)article.getSmallImageId()));
            smallImageURL = sb.toString();
        }
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-small-image-url", smallImageURL);
        Object[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-asset-tag-names", StringUtil.merge((Object[])assetTagNames));
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-author-id", String.valueOf(article.getUserId()));
        String userName = "";
        String userEmailAddress = "";
        String userComments = "";
        String userJobTitle = "";
        User user = UserLocalServiceUtil.fetchUserById((long)article.getUserId());
        if (user != null) {
            userName = user.getFullName();
            userEmailAddress = user.getEmailAddress();
            userComments = user.getComments();
            userJobTitle = user.getJobTitle();
        }
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-author-name", userName);
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-author-email-address", userEmailAddress);
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-author-comments", userComments);
        JournalUtil._addReservedEl(rootElement, tokens, "reserved-article-author-job-title", userJobTitle);
    }

    public static String getJournalControlPanelLink(long folderId, long groupId, LiferayPortletResponse liferayPortletResponse) {
        if (liferayPortletResponse != null) {
            PortletURL portletURL = liferayPortletResponse.createRenderURL();
            portletURL.setParameter("groupId", String.valueOf(groupId));
            portletURL.setParameter("folderId", String.valueOf(folderId));
            return portletURL.toString();
        }
        try {
            String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
            String articleURL = PortalUtil.getControlPanelFullURL((long)groupId, (String)portletId, null);
            String namespace = PortalUtil.getPortletNamespace((String)"com_liferay_journal_web_portlet_JournalPortlet");
            articleURL = HttpUtil.addParameter((String)articleURL, (String)(namespace + "groupId"), (long)groupId);
            return HttpUtil.addParameter((String)articleURL, (String)(namespace + "folderId"), (long)folderId);
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return "";
        }
    }

    public static String getJournalControlPanelLink(PortletRequest portletRequest, long folderId) throws PortalException {
        PortletURL portletURL = PortletProviderUtil.getPortletURL((PortletRequest)portletRequest, (String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        portletURL.setParameter("folderId", String.valueOf(folderId));
        return portletURL.toString();
    }

    public static Map<String, String> getTokens(long articleGroupId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        HashMap<String, String> tokens;
        block5: {
            ThemeDisplayModel themeDisplayModel;
            tokens = new HashMap<String, String>();
            if (themeDisplay != null) {
                JournalUtil._populateTokens(tokens, articleGroupId, themeDisplay);
            } else if (portletRequestModel != null && (themeDisplayModel = portletRequestModel.getThemeDisplayModel()) != null) {
                try {
                    JournalUtil._populateTokens(tokens, articleGroupId, themeDisplayModel);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)exception, (Throwable)exception);
                }
            }
        }
        return tokens;
    }

    public static String getUrlTitle(long id, String title) {
        if (title == null) {
            return String.valueOf(id);
        }
        title = Validator.isNull((String)(title = StringUtil.toLowerCase((String)title.trim()))) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalizeWithEncoding((String)title);
        return ModelHintsUtil.trimString((String)JournalArticle.class.getName(), (String)"urlTitle", (String)title);
    }

    public static boolean isHead(JournalArticle article) {
        JournalArticle latestArticle = JournalArticleLocalServiceUtil.fetchLatestArticle((long)article.getResourcePrimKey(), (int[])new int[]{0, 8});
        if (latestArticle != null && !latestArticle.isIndexable()) {
            return false;
        }
        return latestArticle != null && article.getId() == latestArticle.getId();
    }

    public static boolean isHeadListable(JournalArticle article) {
        JournalArticle latestArticle = JournalArticleLocalServiceUtil.fetchLatestArticle((long)article.getResourcePrimKey(), (int[])new int[]{0, 8, 7});
        return latestArticle != null && article.getId() == latestArticle.getId();
    }

    public static boolean isLatestArticle(JournalArticle article) {
        JournalArticle latestArticle = JournalArticleLocalServiceUtil.fetchLatestArticle((long)article.getResourcePrimKey(), (int)-1, (boolean)false);
        return latestArticle != null && article.getId() == latestArticle.getId();
    }

    public static String removeArticleLocale(Document document, String content, String languageId) {
        try {
            Element rootElement = document.getRootElement();
            String availableLocales = rootElement.attributeValue("available-locales");
            if (availableLocales == null) {
                return content;
            }
            if ((availableLocales = StringUtil.removeFromList((String)availableLocales, (String)languageId)).endsWith(",")) {
                availableLocales = availableLocales.substring(0, availableLocales.length() - 1);
            }
            rootElement.addAttribute("available-locales", availableLocales);
            JournalUtil._removeArticleLocale(rootElement, languageId);
            content = XMLUtil.formatXML((Document)document);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return content;
    }

    public static String transform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, Document document, PortletRequestModel portletRequestModel, String script, String langType) throws Exception {
        return JournalUtil.transform(themeDisplay, tokens, viewMode, languageId, document, portletRequestModel, script, langType, false);
    }

    public static String transform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, Document document, PortletRequestModel portletRequestModel, String script, String langType, boolean propagateException) throws Exception {
        TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((String)JournalArticle.class.getName());
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        contextObjects.putAll(templateHandler.getCustomContextObjects());
        return _journalTransformer.transform(themeDisplay, contextObjects, tokens, viewMode, languageId, document, portletRequestModel, script, langType, propagateException);
    }

    private static void _addElementOptions(Element curContentElement, Element newContentElement) {
        List newElementOptions = newContentElement.elements("option");
        for (Element newElementOption : newElementOptions) {
            Element curElementOption = SAXReaderUtil.createElement((String)"option");
            curElementOption.addCDATA(newElementOption.getText());
            curContentElement.add(curElementOption);
        }
    }

    private static void _addReservedEl(Element rootElement, Map<String, String> tokens, String name, Date value) {
        JournalUtil._addReservedEl(rootElement, tokens, name, Time.getRFC822((Date)value));
    }

    private static void _addReservedEl(Element rootElement, Map<String, String> tokens, String name, double value) {
        JournalUtil._addReservedEl(rootElement, tokens, name, String.valueOf(value));
    }

    private static void _addReservedEl(Element rootElement, Map<String, String> tokens, String name, String value) {
        if (rootElement != null) {
            Element dynamicElementElement = rootElement.addElement("dynamic-element");
            dynamicElementElement.addAttribute("name", name);
            dynamicElementElement.addAttribute("type", "text");
            Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
            dynamicContentElement.setText(value);
        }
        tokens.put(StringUtil.replace((String)name, (char)'-', (char)'_'), value);
    }

    private static String _getCustomTokenValue(String tokenName, JournalServiceConfiguration journalServiceConfiguration) {
        for (String tokenValue : journalServiceConfiguration.customTokenValues()) {
            String[] tokenValueParts = tokenValue.split("\\=");
            if (tokenValueParts.length != 2 || !tokenValueParts[0].equals(tokenName)) continue;
            return tokenValueParts[1];
        }
        return null;
    }

    private static Element _getElementByInstanceId(Document document, String instanceId) {
        if (Validator.isNull((String)instanceId)) {
            return null;
        }
        XPath xPathSelector = SAXReaderUtil.createXPath((String)("//dynamic-element[@instance-id=" + HtmlUtil.escapeXPathAttribute((String)instanceId) + "]"));
        List nodes = xPathSelector.selectNodes((Object)document);
        if (nodes.size() == 1) {
            return (Element)nodes.get(0);
        }
        return null;
    }

    private static void _mergeArticleContentUpdate(Document curDocument, Element newParentElement, Element newElement, int pos, String defaultLocale) throws Exception {
        JournalUtil._mergeArticleContentUpdate(curDocument, newElement, defaultLocale);
        String instanceId = newElement.attributeValue("instance-id");
        Element curElement = JournalUtil._getElementByInstanceId(curDocument, instanceId);
        if (curElement != null) {
            JournalUtil._mergeArticleContentUpdate(curElement, newElement, defaultLocale);
        } else {
            String parentInstanceId = newParentElement.attributeValue("instance-id");
            if (Validator.isNull((String)parentInstanceId)) {
                Element curRoot = curDocument.getRootElement();
                List curRootElements = curRoot.elements();
                curRootElements.add(pos, newElement.createCopy());
            } else {
                Element curParentElement = JournalUtil._getElementByInstanceId(curDocument, parentInstanceId);
                if (curParentElement != null) {
                    List curParentElements = curParentElement.elements();
                    curParentElements.add(pos, newElement.createCopy());
                }
            }
        }
    }

    private static void _mergeArticleContentUpdate(Document curDocument, Element newParentElement, String defaultLocale) throws Exception {
        List newElements = newParentElement.elements("dynamic-element");
        for (int i = 0; i < newElements.size(); ++i) {
            Element newElement = (Element)newElements.get(i);
            JournalUtil._mergeArticleContentUpdate(curDocument, newParentElement, newElement, i, defaultLocale);
        }
    }

    private static void _mergeArticleContentUpdate(Element curElement, Element newElement, String defaultLocale) {
        List elements;
        Attribute curTypeAttribute = curElement.attribute("type");
        Attribute newTypeAttribute = newElement.attribute("type");
        curTypeAttribute.setValue(newTypeAttribute.getValue());
        Attribute newIndexTypeAttribute = newElement.attribute("index-type");
        if (newIndexTypeAttribute != null) {
            Attribute curIndexTypeAttribute = curElement.attribute("index-type");
            if (curIndexTypeAttribute == null) {
                curElement.addAttribute("index-type", newIndexTypeAttribute.getValue());
            } else {
                curIndexTypeAttribute.setValue(newIndexTypeAttribute.getValue());
            }
        }
        if (ListUtil.isEmpty((List)(elements = newElement.elements("dynamic-content")))) {
            return;
        }
        Element newContentElement = (Element)elements.get(0);
        String newLanguageId = newContentElement.attributeValue("language-id");
        String newValue = newContentElement.getText();
        String indexType = newElement.attributeValue("index-type");
        if (Validator.isNotNull((String)indexType)) {
            curElement.addAttribute("index-type", indexType);
        }
        List curContentElements = curElement.elements("dynamic-content");
        if (Validator.isNull((String)newLanguageId)) {
            for (Element curContentElement : curContentElements) {
                curContentElement.detach();
            }
            Element curContentElement = SAXReaderUtil.createElement((String)"dynamic-content");
            if (newContentElement.element("option") != null) {
                JournalUtil._addElementOptions(curContentElement, newContentElement);
            } else {
                curContentElement.addCDATA(newValue);
            }
            curElement.add(curContentElement);
        } else {
            boolean alreadyExists = false;
            for (Element curContentElement : curContentElements) {
                String curLanguageId = curContentElement.attributeValue("language-id");
                if (!newLanguageId.equals(curLanguageId)) continue;
                alreadyExists = true;
                curContentElement.clearContent();
                if (newContentElement.element("option") != null) {
                    JournalUtil._addElementOptions(curContentElement, newContentElement);
                    break;
                }
                curContentElement.addCDATA(newValue);
                break;
            }
            if (!alreadyExists) {
                Element curContentElement = (Element)curContentElements.get(0);
                String curLanguageId = curContentElement.attributeValue("language-id");
                if (Validator.isNull((String)curLanguageId)) {
                    if (newLanguageId.equals(defaultLocale)) {
                        curContentElement.clearContent();
                        if (newContentElement.element("option") != null) {
                            JournalUtil._addElementOptions(curContentElement, newContentElement);
                        } else {
                            curContentElement.addCDATA(newValue);
                        }
                    } else {
                        curElement.add(newContentElement.createCopy());
                    }
                    curContentElement.addAttribute("language-id", defaultLocale);
                } else {
                    curElement.add(newContentElement.createCopy());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void _populateCustomTokens(Map<String, String> tokens, long companyId) {
        JournalServiceConfiguration journalServiceConfiguration = null;
        try {
            journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)companyId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        if (journalServiceConfiguration == null) {
            return;
        }
        if (MapUtil.isEmpty(_customTokens)) {
            Class<JournalUtil> clazz = JournalUtil.class;
            // MONITORENTER : com.liferay.journal.internal.util.JournalUtil.class
            _customTokens = new HashMap<String, String>();
            for (String tokenName : journalServiceConfiguration.customTokenNames()) {
                String tokenValue = JournalUtil._getCustomTokenValue(tokenName, journalServiceConfiguration);
                if (Validator.isNull((String)tokenValue)) continue;
                _customTokens.put(tokenName, tokenValue);
            }
            // MONITOREXIT : clazz
        }
        if (_customTokens.isEmpty()) return;
        tokens.putAll(_customTokens);
    }

    private static void _populateTokens(Map<String, String> tokens, long articleGroupId, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplay.getPathFriendlyURLPublic() : (group.isUserGroup() ? themeDisplay.getPathFriendlyURLPrivateUser() : themeDisplay.getPathFriendlyURLPrivateGroup());
        String layoutSetFriendlyUrl = themeDisplay.getI18nPath();
        TreeMap virtualHostnames = layoutSet.getVirtualHostnames();
        if (virtualHostnames.isEmpty() || !virtualHostnames.containsKey(themeDisplay.getServerName())) {
            layoutSetFriendlyUrl = friendlyUrlCurrent + group.getFriendlyURL();
        }
        tokens.put("article_group_id", String.valueOf(articleGroupId));
        tokens.put("cdn_host", themeDisplay.getCDNHost());
        tokens.put("company_id", String.valueOf(themeDisplay.getCompanyId()));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplay.getPathFriendlyURLPrivateGroup());
        tokens.put("friendly_url_private_user", themeDisplay.getPathFriendlyURLPrivateUser());
        tokens.put("friendly_url_public", themeDisplay.getPathFriendlyURLPublic());
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("image_path", themeDisplay.getPathImage());
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplay.getPathMain());
        tokens.put("portal_ctx", themeDisplay.getPathContext());
        tokens.put("portal_url", HttpUtil.removeProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("protocol", HttpUtil.getProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("root_path", themeDisplay.getPathContext());
        tokens.put("scope_group_id", String.valueOf(themeDisplay.getScopeGroupId()));
        tokens.put("site_group_id", String.valueOf(themeDisplay.getSiteGroupId()));
        tokens.put("theme_image_path", themeDisplay.getPathThemeImages());
        JournalUtil._populateCustomTokens(tokens, themeDisplay.getCompanyId());
        tokens.put("friendly_url", themeDisplay.getPathFriendlyURLPublic());
        tokens.put("friendly_url_private", themeDisplay.getPathFriendlyURLPrivateGroup());
        tokens.put("group_id", String.valueOf(articleGroupId));
        tokens.put("page_url", themeDisplay.getPathFriendlyURLPublic());
    }

    private static void _populateTokens(Map<String, String> tokens, long articleGroupId, ThemeDisplayModel themeDisplayModel) throws Exception {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)themeDisplayModel.getPlid());
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplayModel.getPathFriendlyURLPublic() : (group.isUserGroup() ? themeDisplayModel.getPathFriendlyURLPrivateUser() : themeDisplayModel.getPathFriendlyURLPrivateGroup());
        String layoutSetFriendlyUrl = themeDisplayModel.getI18nPath();
        TreeMap virtualHostnames = layoutSet.getVirtualHostnames();
        if (virtualHostnames.isEmpty() || !virtualHostnames.containsKey(themeDisplayModel.getServerName())) {
            layoutSetFriendlyUrl = friendlyUrlCurrent + group.getFriendlyURL();
        }
        tokens.put("article_group_id", String.valueOf(articleGroupId));
        tokens.put("cdn_host", themeDisplayModel.getCdnHost());
        tokens.put("company_id", String.valueOf(themeDisplayModel.getCompanyId()));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplayModel.getPathFriendlyURLPrivateGroup());
        tokens.put("friendly_url_private_user", themeDisplayModel.getPathFriendlyURLPrivateUser());
        tokens.put("friendly_url_public", themeDisplayModel.getPathFriendlyURLPublic());
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("image_path", themeDisplayModel.getPathImage());
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplayModel.getPathMain());
        tokens.put("portal_ctx", themeDisplayModel.getPathContext());
        tokens.put("portal_url", HttpUtil.removeProtocol((String)themeDisplayModel.getURLPortal()));
        tokens.put("protocol", HttpUtil.getProtocol((String)themeDisplayModel.getURLPortal()));
        tokens.put("root_path", themeDisplayModel.getPathContext());
        tokens.put("scope_group_id", String.valueOf(themeDisplayModel.getScopeGroupId()));
        tokens.put("theme_image_path", themeDisplayModel.getPathThemeImages());
        JournalUtil._populateCustomTokens(tokens, themeDisplayModel.getCompanyId());
        tokens.put("friendly_url", themeDisplayModel.getPathFriendlyURLPublic());
        tokens.put("friendly_url_private", themeDisplayModel.getPathFriendlyURLPrivateGroup());
        tokens.put("group_id", String.valueOf(articleGroupId));
        tokens.put("page_url", themeDisplayModel.getPathFriendlyURLPublic());
    }

    private static void _removeArticleLocale(Element element, String languageId) throws PortalException {
        for (Element dynamicElementElement : element.elements("dynamic-element")) {
            for (Element dynamicContentElement : dynamicElementElement.elements("dynamic-content")) {
                String curLanguageId = GetterUtil.getString((String)dynamicContentElement.attributeValue("language-id"));
                if (!curLanguageId.equals(languageId)) continue;
                long id = GetterUtil.getLong((String)dynamicContentElement.attributeValue("id"));
                if (id > 0L) {
                    ImageLocalServiceUtil.deleteImage((long)id);
                }
                dynamicContentElement.detach();
            }
            JournalUtil._removeArticleLocale(dynamicElementElement, languageId);
        }
    }

    static {
        _journalTransformer = new JournalTransformer(true);
    }
}

