/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_8;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradeArticleSystemEvents
extends UpgradeProcess {
    private static final String _CLASS_NAME = "com.liferay.journal.model.JournalArticle";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeArticleSystemEvents.class);
    private final SystemEventLocalService _systemEventLocalService;

    public UpgradeArticleSystemEvents(SystemEventLocalService systemEventLocalService) {
        this._systemEventLocalService = systemEventLocalService;
    }

    protected void deleteJournalArticleSystemEvents() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DynamicQuery dynamicQuery = this._systemEventLocalService.dynamicQuery();
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.eq((Object)PortalUtil.getClassNameId((String)_CLASS_NAME)));
            Property typeProperty = PropertyFactoryUtil.forName((String)"type");
            dynamicQuery.add(typeProperty.eq((Object)1));
            List systemEvents = this._systemEventLocalService.dynamicQuery(dynamicQuery);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Processing ", systemEvents.size(), " delete system events for journal articles"}));
            }
            for (SystemEvent systemEvent : systemEvents) {
                Throwable throwable;
                ResultSet rs;
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)systemEvent.getExtraData());
                if (extraDataJSONObject.has("uuid") || !extraDataJSONObject.has("version")) continue;
                String articleId = null;
                try (PreparedStatement ps = this.connection.prepareStatement("select articleId from JournalArticleResource where JournalArticleResource.uuid_ = ? and JournalArticleResource.groupId = ?");){
                    ps.setString(1, systemEvent.getClassUuid());
                    ps.setLong(2, systemEvent.getGroupId());
                    rs = ps.executeQuery();
                    throwable = null;
                    try {
                        if (rs.next()) {
                            articleId = rs.getString(1);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                if (articleId == null) continue;
                ps = this.connection.prepareStatement("select 1 from JournalArticle where groupId = ? and articleId = ? and version = ? and status = ?");
                var12_14 = null;
                try {
                    ps.setLong(1, systemEvent.getGroupId());
                    ps.setString(2, articleId);
                    ps.setDouble(3, extraDataJSONObject.getDouble("version"));
                    ps.setInt(4, 8);
                    rs = ps.executeQuery();
                    throwable = null;
                    try {
                        if (!rs.next()) continue;
                        this._systemEventLocalService.deleteSystemEvent(systemEvent);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable6) {
                    var12_14 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (ps == null) continue;
                    if (var12_14 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable7) {
                            var12_14.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Delete system events verified for journal articles");
            }
        }
    }

    protected void doUpgrade() throws Exception {
        this.deleteJournalArticleSystemEvents();
    }
}

