/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_6;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradeImageTypeContentAttributes
extends UpgradeProcess {
    protected String addImageContentAttributes(String content) throws Exception {
        Document document = SAXReaderUtil.read((String)content);
        document = document.clone();
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPath.selectNodes((Object)document);
        for (Node imageNode : imageNodes) {
            Element imageElement = (Element)imageNode;
            List dynamicContentElements = imageElement.elements("dynamic-content");
            String id = null;
            for (Element dynamicContentElement : dynamicContentElements) {
                id = dynamicContentElement.attributeValue("id");
                dynamicContentElement.addAttribute("alt", "");
                dynamicContentElement.addAttribute("name", id);
                dynamicContentElement.addAttribute("title", id);
                dynamicContentElement.addAttribute("type", "journal");
            }
            if (!Validator.isNotNull(id)) continue;
            imageElement.addAttribute("instance-id", this.getImageInstanceId(id));
        }
        return document.formattedString();
    }

    protected void doUpgrade() throws Exception {
        this.updateContentImages();
    }

    protected String getImageInstanceId(String articleImageId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select elInstanceId from JournalArticleImage where articleImageId = ?");){
            ps.setLong(1, Long.valueOf(articleImageId));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = "";
            return string;
        }
    }

    protected void updateContentImages() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select content, id_ from JournalArticle where content like ?");){
            ps1.setString(1, "%type=\"image\"%");
            ResultSet rs = ps1.executeQuery();
            while (rs.next()) {
                String content = rs.getString(1);
                long id = rs.getLong(2);
                String newContent = this.addImageContentAttributes(content);
                PreparedStatement ps = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");
                Throwable throwable = null;
                try {
                    ps.setString(1, newContent);
                    ps.setLong(2, id);
                    ps.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps == null) continue;
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
        }
    }
}

