/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_5;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletId;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.portlet.PortletPreferences;

public class UpgradeJournalArticles
extends BaseUpgradePortletId {
    private static final String _PORTLET_ID_ASSET_PUBLISHER = "com_liferay_asset_publisher_web_AssetPublisherPortlet";
    private static final String _PORTLET_ID_JOURNAL_CONTENT_LIST = "62";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeJournalArticles.class);
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final GroupLocalService _groupLocalService;
    private final LayoutLocalService _layoutLocalService;

    public UpgradeJournalArticles(AssetCategoryLocalService assetCategoryLocalService, DDMStructureLocalService ddmStructureLocalService, GroupLocalService groupLocalService, LayoutLocalService layoutLocalService) {
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._groupLocalService = groupLocalService;
        this._layoutLocalService = layoutLocalService;
    }

    protected long getCategoryId(long companyId, String type) throws Exception {
        List assetCategories = this._assetCategoryLocalService.search(companyId, type, new String[0], -1, -1);
        if (!assetCategories.isEmpty()) {
            AssetCategory assetCategory = (AssetCategory)assetCategories.get(0);
            return assetCategory.getCategoryId();
        }
        return 0L;
    }

    protected String getNewPreferences(long plid, String preferences, String oldRootPortletId, String newRootPortletId) throws Exception {
        PortletPreferences oldPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)preferences);
        String ddmStructureKey = oldPortletPreferences.getValue("ddmStructureKey", "");
        long groupId = GetterUtil.getLong((String)oldPortletPreferences.getValue("groupId", ""));
        String orderByCol = oldPortletPreferences.getValue("orderByCol", "");
        String orderByType = oldPortletPreferences.getValue("orderByType", "");
        int pageDelta = GetterUtil.getInteger((String)oldPortletPreferences.getValue("pageDelta", ""));
        String pageUrl = oldPortletPreferences.getValue("pageUrl", "");
        String portletSetupCss = oldPortletPreferences.getValue("portletSetupCss", "");
        String type = oldPortletPreferences.getValue("type", "");
        PortletPreferencesImpl newPortletPreferences = new PortletPreferencesImpl();
        newPortletPreferences.setValue("anyAssetType", String.valueOf(PortalUtil.getClassNameId((String)JournalArticle.class.getName())));
        Layout layout = this._layoutLocalService.getLayout(plid);
        long structureId = this.getStructureId(layout.getCompanyId(), layout.getGroupId(), ddmStructureKey);
        if (structureId > 0L) {
            newPortletPreferences.setValue("anyClassTypeJournalArticleAssetRendererFactory", String.valueOf(structureId));
        }
        String assetLinkBehavior = "showFullContent";
        if (pageUrl.equals("viewInContext")) {
            assetLinkBehavior = "viewInPortlet";
        }
        newPortletPreferences.setValue("assetLinkBehavior", assetLinkBehavior);
        if (structureId > 0L) {
            newPortletPreferences.setValue("classTypeIds", String.valueOf(structureId));
        }
        newPortletPreferences.setValue("delta", String.valueOf(pageDelta));
        newPortletPreferences.setValue("displayStyle", "table");
        newPortletPreferences.setValue("metadataFields", "publish-date,author");
        newPortletPreferences.setValue("orderByColumn1", orderByCol);
        newPortletPreferences.setValue("orderByType1", orderByType);
        newPortletPreferences.setValue("paginationType", "none");
        portletSetupCss = StringUtil.replace((String)portletSetupCss, (String[])new String[]{"#p_p_id_" + oldRootPortletId, "#portlet_" + oldRootPortletId}, (String[])new String[]{"#p_p_id_" + newRootPortletId, "#portlet_" + newRootPortletId});
        newPortletPreferences.setValue("portletSetupCss", portletSetupCss);
        long categoryId = this.getCategoryId(layout.getCompanyId(), type);
        if (categoryId > 0L) {
            newPortletPreferences.setValue("queryAndOperator0", Boolean.TRUE.toString());
            newPortletPreferences.setValue("queryContains0", Boolean.TRUE.toString());
            newPortletPreferences.setValue("queryName0", "assetCategories");
            newPortletPreferences.setValue("queryValues0", String.valueOf(categoryId));
        }
        newPortletPreferences.setValue("showAddContentButton", Boolean.FALSE.toString());
        String groupName = String.valueOf(groupId);
        if (groupId == layout.getGroupId()) {
            groupName = "default";
        }
        newPortletPreferences.setValue("scopeIds", "Group_" + groupName);
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)newPortletPreferences);
    }

    protected String[][] getRenamePortletIdsArray() {
        return new String[][]{{_PORTLET_ID_JOURNAL_CONTENT_LIST, _PORTLET_ID_ASSET_PUBLISHER}};
    }

    protected long getStructureId(long companyId, long groupId, String ddmStructureKey) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, PortalUtil.getClassNameId((String)JournalArticle.class.getName()), ddmStructureKey);
        if (ddmStructure == null) {
            Group companyGroup = this._groupLocalService.getCompanyGroup(companyId);
            this._ddmStructureLocalService.fetchStructure(companyGroup.getGroupId(), PortalUtil.getClassNameId((String)JournalArticle.class.getName()), ddmStructureKey);
        }
        if (ddmStructure != null) {
            return ddmStructure.getStructureId();
        }
        return 0L;
    }

    protected void updateInstanceablePortletPreferences(String oldRootPortletId, String newRootPortletId) throws Exception {
        StringBundler sb = new StringBundler(8);
        sb.append("select portletPreferencesId, plid, portletId, preferences ");
        sb.append("from PortletPreferences where portletId = '");
        sb.append(oldRootPortletId);
        sb.append("' OR portletId like '");
        sb.append(oldRootPortletId);
        sb.append("_INSTANCE_%' OR portletId like '");
        sb.append(oldRootPortletId);
        sb.append("_USER_%_INSTANCE_%'");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String preferences = rs.getString("preferences");
                if (preferences.equals("<portlet-preferences />")) continue;
                long portletPreferencesId = rs.getLong("portletPreferencesId");
                long plid = rs.getLong("plid");
                String portletId = rs.getString("portletId");
                String newPreferences = this.getNewPreferences(plid, preferences, oldRootPortletId, newRootPortletId);
                long userId = PortletIdCodec.decodeUserId((String)portletId);
                String instanceId = PortletIdCodec.decodeInstanceId((String)portletId);
                String newPortletId = PortletIdCodec.encode((String)_PORTLET_ID_ASSET_PUBLISHER, (long)userId, (String)instanceId);
                this.updatePortletPreference(portletPreferencesId, newPortletId, newPreferences);
            }
        }
    }

    protected void updatePortlet(String oldRootPortletId, String newRootPortletId) throws Exception {
        block2: {
            try {
                this.updateResourcePermission(oldRootPortletId, newRootPortletId, true);
                this.updateInstanceablePortletPreferences(oldRootPortletId, newRootPortletId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
    }

    protected void updatePortletPreference(long portletPreferencesId, String newPortletId, String newPreferences) throws Exception {
        block14: {
            try (PreparedStatement ps = this.connection.prepareStatement("update PortletPreferences set preferences = ?, portletId = ? where portletPreferencesId = " + portletPreferencesId);){
                ps.setString(1, newPreferences);
                ps.setString(2, newPortletId);
                ps.executeUpdate();
            }
            catch (SQLException sqlException) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)sqlException, (Throwable)sqlException);
            }
        }
    }
}

