/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.model.listener;

import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.model.ChangesetEntry;
import com.liferay.changeset.service.ChangesetCollectionLocalService;
import com.liferay.changeset.service.ChangesetEntryLocalService;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.model.listener.StagingModelListener;
import java.util.HashSet;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class JournalArticleStagingModelListener
extends BaseModelListener<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleStagingModelListener.class);
    @Reference
    private ChangesetCollectionLocalService _changesetCollectionLocalService;
    @Reference
    private ChangesetEntryLocalService _changesetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private Staging _staging;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;
    @Reference
    private StagingModelListener<JournalArticle> _stagingModelListener;

    public void onAfterCreate(JournalArticle journalArticle) throws ModelListenerException {
        if (!this._isJournalArticleStaged(journalArticle)) {
            return;
        }
        this._stagingModelListener.onAfterCreate((BaseModel)journalArticle);
        this._addJournalArticleResourceToChangesetCollection(journalArticle);
    }

    public void onAfterRemove(JournalArticle journalArticle) throws ModelListenerException {
        if (!this._isJournalArticleStaged(journalArticle)) {
            return;
        }
        this._stagingModelListener.onAfterRemove((BaseModel)journalArticle);
        this._cleanUpJournalArticleResourceFromChangesetCollection(journalArticle);
    }

    public void onAfterUpdate(JournalArticle journalArticle) throws ModelListenerException {
        if (!this._isJournalArticleStaged(journalArticle)) {
            return;
        }
        this._stagingModelListener.onAfterUpdate((BaseModel)journalArticle);
        this._addJournalArticleResourceToChangesetCollection(journalArticle);
        this._cleanUpJournalArticleResourceFromChangesetCollection(journalArticle);
    }

    private void _addJournalArticleResourceToChangesetCollection(JournalArticle journalArticle) {
        block4: {
            if (journalArticle.getStatus() == 8) {
                return;
            }
            try {
                ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchOrAddChangesetCollection(journalArticle.getGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
                long journalArticleClassNameId = this._classNameLocalService.getClassNameId(journalArticle.getModelClass());
                ChangesetEntry changesetEntry = this._changesetEntryLocalService.fetchChangesetEntry(changesetCollection.getChangesetCollectionId(), journalArticleClassNameId, journalArticle.getId());
                if (changesetEntry == null) {
                    return;
                }
                JournalArticleResource journalArticleResource = journalArticle.getArticleResource();
                long journalArticleResourceClassNameId = this._classNameLocalService.getClassNameId(journalArticleResource.getModelClass());
                this._changesetEntryLocalService.fetchOrAddChangesetEntry(changesetCollection.getChangesetCollectionId(), journalArticleResourceClassNameId, journalArticleResource.getPrimaryKey());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to process journal article resource for article " + journalArticle.getArticleId()), (Throwable)portalException);
            }
        }
    }

    private void _cleanUpJournalArticleResourceFromChangesetCollection(JournalArticle journalArticle) {
        block4: {
            try {
                ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchOrAddChangesetCollection(journalArticle.getGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
                List journalArticleResourceArticles = this._journalArticleLocalService.getArticlesByResourcePrimKey(journalArticle.getResourcePrimKey());
                HashSet<Long> classPKs = new HashSet<Long>();
                StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)JournalArticle.class.getName());
                for (JournalArticle journalArticleResourceArticle : journalArticleResourceArticles) {
                    if (!ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)journalArticleResourceArticle.getStatus())) continue;
                    classPKs.add(journalArticleResourceArticle.getId());
                }
                long journalArticleClassNameId = this._classNameLocalService.getClassNameId(journalArticle.getModelClass());
                long journalArticleChangetEntriesCount = this._changesetEntryLocalService.getChangesetEntriesCount(changesetCollection.getChangesetCollectionId(), journalArticleClassNameId, classPKs);
                if (journalArticleChangetEntriesCount == 0L) {
                    long journalArticleResourceClassNameId = this._classNameLocalService.getClassNameId(JournalArticleResource.class);
                    this._changesetEntryLocalService.deleteEntry(changesetCollection.getChangesetCollectionId(), journalArticleResourceClassNameId, journalArticle.getResourcePrimKey());
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to process journal article resource for article " + journalArticle.getArticleId()), (Throwable)portalException);
            }
        }
    }

    private boolean _isJournalArticleStaged(JournalArticle journalArticle) {
        Group group = this._groupLocalService.fetchGroup(journalArticle.getGroupId());
        if (group == null) {
            return false;
        }
        return this._stagingGroupHelper.isStagingGroup(group);
    }
}

