/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.data.handler;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.service.ChangesetCollectionLocalService;
import com.liferay.changeset.service.ChangesetEntryLocalService;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.exception.ExportImportRuntimeException;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.journal.configuration.JournalGroupServiceConfiguration;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.internal.exportimport.creation.strategy.JournalCreationStrategy;
import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlEscapableObject;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={JournalArticleStagedModelDataHandler.class, StagedModelDataHandler.class})
public class JournalArticleStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalArticle> {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleStagedModelDataHandler.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private ChangesetCollectionLocalService _changesetCollectionLocalService;
    @Reference
    private ChangesetEntryLocalService _changesetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private ConfigurationProvider _configurationProvider;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference(target="(content.processor.type=DLReferences)")
    private ExportImportContentProcessor<String> _dlReferencesExportImportContentProcessor;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    private ImageLocalService _imageLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private volatile ExportImportContentProcessor<String> _journalArticleExportImportContentProcessor;
    private JournalArticleLocalService _journalArticleLocalService;
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    private JournalCreationStrategy _journalCreationStrategy;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public void deleteStagedModel(JournalArticle article) throws PortalException {
        this._journalArticleLocalService.deleteArticle(article);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.fetchJournalArticleResourceByUuidAndGroupId(uuid, groupId);
        if (articleResource == null) {
            return;
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)extraData);
        if (Validator.isNotNull((String)extraData) && extraDataJSONObject.has("uuid")) {
            String articleUuid = extraDataJSONObject.getString("uuid");
            JournalArticle article = this.fetchStagedModelByUuidAndGroupId(articleUuid, groupId);
            this.deleteStagedModel(article);
        } else {
            this._journalArticleLocalService.deleteArticle(groupId, articleResource.getArticleId(), null);
        }
    }

    public JournalArticle fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._journalArticleLocalService.fetchJournalArticleByUuidAndGroupId(uuid, groupId);
    }

    public List<JournalArticle> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._journalArticleLocalService.getJournalArticlesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(JournalArticle article) {
        if (article.getFolderId() == 0L) {
            return article.getTitleCurrentValue();
        }
        try {
            JournalFolder folder = article.getFolder();
            List ancestorFolders = folder.getAncestors();
            StringBundler sb = new StringBundler(4 * ancestorFolders.size() + 5);
            Collections.reverse(ancestorFolders);
            for (JournalFolder ancestorFolder : ancestorFolders) {
                sb.append(ancestorFolder.getName());
                sb.append(" ");
                sb.append(">");
                sb.append(" ");
            }
            sb.append(folder.getName());
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
            sb.append(article.getTitleCurrentValue());
            return sb.toString();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)portalException, (Throwable)portalException);
            }
            return article.getTitleCurrentValue();
        }
    }

    public int[] getExportableStatuses() {
        return new int[]{0, 3, 7};
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, JournalArticle article) {
        String articleResourceUuid = null;
        try {
            articleResourceUuid = article.getArticleResourceUuid();
        }
        catch (Exception exception) {
            ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException("", (Throwable)exception);
            exportImportRuntimeException.setMessageKey("unable-to-find-article-resource-x-while-gathering-reference-attributes");
            exportImportRuntimeException.setData(String.valueOf(article.getArticleId()));
            exportImportRuntimeException.setClassName(JournalArticleStagedModelDataHandler.class.getName());
            throw exportImportRuntimeException;
        }
        HashMap referenceAttributes = HashMapBuilder.put((Object)"article-id", (Object)article.getArticleId()).put((Object)"article-resource-uuid", (Object)articleResourceUuid).build();
        long defaultUserId = 0L;
        try {
            defaultUserId = this._userLocalService.getDefaultUserId(article.getCompanyId());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            return referenceAttributes;
        }
        boolean preloaded = this.isPreloadedArticle(defaultUserId, article);
        referenceAttributes.put("preloaded", String.valueOf(preloaded));
        referenceAttributes.put("resource-prim-key", String.valueOf(article.getResourcePrimKey()));
        return referenceAttributes;
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        String articleResourceUuid = referenceElement.attributeValue("article-resource-uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        String articleArticleId = referenceElement.attributeValue("article-id");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        if (!preloaded) {
            return super.validateMissingReference(uuid, groupId);
        }
        JournalArticle existingArticle = this.fetchExistingArticleWithParentGroups(uuid, articleResourceUuid, groupId, articleArticleId, null, 0.0, preloaded);
        return existingArticle != null;
    }

    protected boolean countStagedModel(PortletDataContext portletDataContext, JournalArticle article) {
        if (article.getClassNameId() == this._portal.getClassNameId(DDMStructure.class)) {
            return false;
        }
        return !portletDataContext.isModelCounted(JournalArticleResource.class.getName(), article.getResourcePrimKey());
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        JournalArticle latestArticle;
        Layout layout;
        JournalArticle latestArticle2;
        String versionHistoryControlName;
        Map parameterMap;
        ChangesetCollection changesetCollection;
        if (ExportImportThreadLocal.isStagingInProcess() && (changesetCollection = this._changesetCollectionLocalService.fetchChangesetCollection(portletDataContext.getGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME")) != null) {
            long classNameId = this._classNameLocalService.getClassNameId(JournalArticleResource.class);
            this._changesetEntryLocalService.deleteEntry(changesetCollection.getChangesetCollectionId(), classNameId, article.getResourcePrimKey());
        }
        if ((parameterMap = portletDataContext.getParameterMap()).get(versionHistoryControlName = PortletDataHandlerControl.getNamespacedControlName((String)"journal", (String)"version-history")) != null && !portletDataContext.getBooleanParameter("journal", "version-history") && (latestArticle2 = this._journalArticleLocalService.fetchLatestArticle(article.getResourcePrimKey(), this.getExportableStatuses())) != null && latestArticle2.getId() != article.getId()) {
            return;
        }
        Element articleElement = portletDataContext.getExportDataElement((ClassedModel)article);
        articleElement.addAttribute("article-resource-uuid", article.getArticleResourceUuid());
        if (article.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)article.getFolder(), (String)"parent");
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(article.getGroupId(), this._portal.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)ddmStructure, (String)"strong");
        if (article.getClassNameId() != this._portal.getClassNameId(DDMStructure.class) && Validator.isNotNull((String)article.getDDMTemplateKey())) {
            DDMTemplate ddmTemplate = this._ddmTemplateLocalService.getTemplate(article.getGroupId(), this._portal.getClassNameId(DDMStructure.class), article.getDDMTemplateKey(), true);
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)ddmTemplate, (String)"strong");
        }
        if ((layout = article.getLayout()) != null) {
            portletDataContext.addReferenceElement((ClassedModel)article, articleElement, (ClassedModel)layout, "disposable_dependency", true);
        }
        if (article.isSmallImage()) {
            if (Validator.isNotNull((String)article.getSmallImageURL())) {
                String smallImageURL = (String)((Object)this._dlReferencesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)article, (Serializable)((Object)article.getSmallImageURL()), true, false));
                article.setSmallImageURL(smallImageURL);
            } else {
                Image smallImage = this._imageLocalService.fetchImage(article.getSmallImageId());
                if (smallImage != null && smallImage.getTextObj() != null) {
                    String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)article, (String)(smallImage.getImageId() + "." + smallImage.getType()));
                    articleElement.addAttribute("small-image-path", smallImagePath);
                    article.setSmallImageType(smallImage.getType());
                    portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
                } else {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(4);
                        sb.append("Unable to export small image ");
                        sb.append(article.getSmallImageId());
                        sb.append(" to article ");
                        sb.append(article.getArticleId());
                        _log.warn((Object)sb.toString());
                    }
                    article.setSmallImage(false);
                    article.setSmallImageId(0L);
                }
            }
        }
        if ((latestArticle = this._journalArticleLocalService.fetchLatestArticle(article.getResourcePrimKey())) != null && latestArticle.getId() == article.getId()) {
            for (FileEntry fileEntry : article.getImagesFileEntries()) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)fileEntry, (String)"weak");
            }
        }
        article.setStatusByUserUuid(article.getStatusByUserUuid());
        String content = (String)((Object)this._journalArticleExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)article, (Serializable)((Object)article.getContent()), portletDataContext.getBooleanParameter("journal", "referenced-content"), false));
        article.setContent(content);
        long defaultUserId = this._userLocalService.getDefaultUserId(article.getCompanyId());
        if (this.isPreloadedArticle(defaultUserId, article)) {
            articleElement.addAttribute("preloaded", "true");
        }
        this._exportAssetDisplayPage(portletDataContext, article);
        this._exportFriendlyURLEntries(portletDataContext, article);
        portletDataContext.addClassedModel(articleElement, ExportImportPathUtil.getModelPath((StagedModel)article), (ClassedModel)article);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        String articleResourceUuid = referenceElement.attributeValue("article-resource-uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        String articleArticleId = referenceElement.attributeValue("article-id");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        JournalArticle existingArticle = !preloaded ? (JournalArticle)this.fetchMissingReference(uuid, groupId) : this.fetchExistingArticleWithParentGroups(uuid, articleResourceUuid, groupId, articleArticleId, null, 0.0, preloaded);
        if (existingArticle == null) {
            return;
        }
        Map articleArticleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
        articleArticleIds.put(articleArticleId, existingArticle.getArticleId());
        Map articleGroupIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".groupId");
        articleGroupIds.put(articleArticleId, existingArticle.getGroupId());
        Map articlePrimaryKeys = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".primaryKey");
        long classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        articlePrimaryKeys.put(classPK, existingArticle.getPrimaryKey());
        long articleResourcePrimKey = GetterUtil.getLong((String)referenceElement.attributeValue("resource-prim-key"));
        if (articleResourcePrimKey != 0L) {
            Map articleRecourcePrimKeys = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class);
            articleRecourcePrimKeys.put(articleResourcePrimKey, existingArticle.getResourcePrimKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        Map articleIds;
        String newArticleId;
        long userId = portletDataContext.getUserId(article.getUserUuid());
        long authorId = this._journalCreationStrategy.getAuthorUserId(portletDataContext, article);
        if (authorId != 0L) {
            userId = authorId;
        }
        User user = this._userLocalService.getUser(userId);
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(JournalFolder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)article.getFolderId(), (long)article.getFolderId());
        String articleId = article.getArticleId();
        boolean autoArticleId = false;
        List articles = this._journalArticleLocalService.getArticles(portletDataContext.getScopeGroupId(), articleId);
        if (!articles.isEmpty()) {
            autoArticleId = true;
        }
        if (Validator.isNotNull((String)(newArticleId = (String)(articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId")).get(articleId)))) {
            articleId = newArticleId;
            autoArticleId = false;
        }
        String content = article.getContent();
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        Map ddmStructureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        String parentDDMStructureKey = MapUtil.getString((Map)ddmStructureKeys, (String)article.getDDMStructureKey(), (String)article.getDDMStructureKey());
        long ddmStructureId = 0L;
        if (article.getClassNameId() != 0L) {
            Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
            ddmStructureId = (Long)ddmStructureIds.get(article.getClassPK());
        }
        Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
        String parentDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)article.getDDMTemplateKey(), (String)article.getDDMTemplateKey());
        File smallFile = null;
        try {
            JournalArticle latestArticle;
            Element articleElement = portletDataContext.getImportDataStagedModelElement((StagedModel)article);
            if (article.isSmallImage()) {
                byte[] bytes;
                String smallImagePath = articleElement.attributeValue("small-image-path");
                if (Validator.isNotNull((String)article.getSmallImageURL())) {
                    String smallImageURL = (String)((Object)this._dlReferencesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)article, (Serializable)((Object)article.getSmallImageURL())));
                    article.setSmallImageURL(smallImageURL);
                } else if (Validator.isNotNull((String)smallImagePath) && (bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath)) != null) {
                    smallFile = FileUtil.createTempFile((String)article.getSmallImageType());
                    FileUtil.write((File)smallFile, (byte[])bytes);
                }
            }
            if ((latestArticle = this._journalArticleLocalService.fetchLatestArticle(article.getResourcePrimKey())) != null && latestArticle.getId() == article.getId()) {
                List attachmentElements = portletDataContext.getReferenceDataElements((StagedModel)article, DLFileEntry.class, "weak");
                for (Element attachmentElement : attachmentElements) {
                    InputStream inputStream;
                    block46: {
                        String path = attachmentElement.attributeValue("path");
                        FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
                        inputStream = null;
                        try {
                            String binPath = attachmentElement.attributeValue("bin-path");
                            if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
                                try {
                                    inputStream = FileEntryUtil.getContentStream((FileEntry)fileEntry);
                                }
                                catch (NoSuchFileException noSuchFileException) {
                                    if (_log.isDebugEnabled()) {
                                        _log.debug((Object)("Unable to import attachment for file entry " + fileEntry.getFileEntryId()), (Throwable)noSuchFileException);
                                    }
                                }
                            } else {
                                inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
                            }
                            if (inputStream != null || !_log.isWarnEnabled()) break block46;
                            _log.warn((Object)("Unable to import attachment for file entry " + fileEntry.getFileEntryId()));
                        }
                        catch (Throwable throwable) {
                            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                            throw throwable;
                        }
                    }
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                }
            }
            Map friendlyURLMap = article.getFriendlyURLMap();
            friendlyURLMap.forEach((locale, url) -> friendlyURLMap.replace(locale, this._http.decodeURL(url)));
            String articleURL = null;
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)article);
            if (expirationDate != null && expirationDate.before(new Date())) {
                article.setStatus(3);
            }
            if (article.getStatus() != 0 && article.getStatus() != 7) {
                serviceContext.setWorkflowAction(2);
            }
            JournalArticle importedArticle = null;
            this._setLegacyValues(article);
            if (portletDataContext.isDataStrategyMirror()) {
                serviceContext.setUuid(article.getUuid());
                String articleResourceUuid = articleElement.attributeValue("article-resource-uuid");
                serviceContext.setAttribute("articleResourceUuid", (Serializable)((Object)articleResourceUuid));
                serviceContext.setAttribute("urlTitle", (Serializable)((Object)article.getUrlTitle()));
                boolean preloaded = GetterUtil.getBoolean((String)articleElement.attributeValue("preloaded"));
                JournalArticle existingArticle = this.fetchExistingArticle(articleResourceUuid, portletDataContext.getScopeGroupId(), articleId, newArticleId, preloaded);
                JournalArticle existingArticleVersion = null;
                if (existingArticle != null) {
                    existingArticleVersion = this.fetchExistingArticleVersion(article.getUuid(), portletDataContext.getScopeGroupId(), existingArticle.getArticleId(), article.getVersion());
                }
                if (existingArticle != null && existingArticleVersion == null) {
                    autoArticleId = false;
                    articleId = existingArticle.getArticleId();
                }
                if (existingArticleVersion == null) {
                    importedArticle = this._journalArticleLocalService.addArticle(userId, portletDataContext.getScopeGroupId(), folderId, article.getClassNameId(), ddmStructureId, articleId, autoArticleId, article.getVersion(), article.getTitleMap(), article.getDescriptionMap(), friendlyURLMap, article.getContent(), parentDDMStructureKey, parentDDMTemplateKey, article.getLayoutUuid(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), smallFile, null, articleURL, serviceContext);
                } else {
                    String importedArticleUuid;
                    importedArticle = this._journalArticleLocalService.updateArticle(userId, existingArticle.getGroupId(), folderId, existingArticle.getArticleId(), article.getVersion(), article.getTitleMap(), article.getDescriptionMap(), friendlyURLMap, article.getContent(), parentDDMStructureKey, parentDDMTemplateKey, article.getLayoutUuid(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), smallFile, null, articleURL, serviceContext);
                    String articleUuid = article.getUuid();
                    if (!articleUuid.equals(importedArticleUuid = importedArticle.getUuid())) {
                        importedArticle.setUuid(articleUuid);
                        this._journalArticleLocalService.updateJournalArticle(importedArticle);
                    }
                }
            } else {
                JournalArticle existingArticle = this._journalArticleLocalService.fetchArticle(portletDataContext.getScopeGroupId(), articleId, article.getVersion());
                importedArticle = existingArticle == null ? this._journalArticleLocalService.addArticle(userId, portletDataContext.getScopeGroupId(), folderId, article.getClassNameId(), ddmStructureId, articleId, autoArticleId, article.getVersion(), article.getTitleMap(), article.getDescriptionMap(), friendlyURLMap, article.getContent(), parentDDMStructureKey, parentDDMTemplateKey, article.getLayoutUuid(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), smallFile, null, articleURL, serviceContext) : this._journalArticleLocalService.updateArticle(userId, portletDataContext.getScopeGroupId(), folderId, articleId, article.getVersion(), article.getTitleMap(), article.getDescriptionMap(), friendlyURLMap, article.getContent(), parentDDMStructureKey, parentDDMTemplateKey, article.getLayoutUuid(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), smallFile, null, articleURL, serviceContext);
            }
            Map primaryKeys = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class);
            primaryKeys.put(article.getResourcePrimKey(), importedArticle.getResourcePrimKey());
            if (!StringUtil.equals((String)article.getArticleId(), (String)importedArticle.getArticleId())) {
                articleIds.put(article.getArticleId(), importedArticle.getArticleId());
            }
            StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)article, Layout.class);
            content = (String)((Object)this._journalArticleExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)article, (Serializable)((Object)content)));
            String newContent = this._journalCreationStrategy.getTransformedContent(portletDataContext, article);
            if (newContent != JournalCreationStrategy.ARTICLE_CONTENT_UNCHANGED) {
                content = newContent;
            }
            if (!StringUtil.equals((String)importedArticle.getContent(), (String)content)) {
                importedArticle = this._journalArticleLocalService.updateArticle(userId, importedArticle.getGroupId(), folderId, importedArticle.getArticleId(), article.getVersion(), article.getTitleMap(), article.getDescriptionMap(), friendlyURLMap, content, parentDDMStructureKey, parentDDMTemplateKey, article.getLayoutUuid(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), smallFile, null, articleURL, serviceContext);
            }
            this._journalArticleLocalService.updateAsset(userId, importedArticle, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), Double.valueOf(serviceContext.getAssetPriority()));
            if (article.isExpired() || importedArticle.isExpired()) {
                this._journalArticleLocalService.expireArticle(userId, importedArticle.getGroupId(), importedArticle.getArticleId(), importedArticle.getVersion(), articleURL, serviceContext);
            }
            serviceContext.setModifiedDate(importedArticle.getModifiedDate());
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            try {
                if (ExportImportThreadLocal.isInitialLayoutStagingInProcess() && article.getStatus() == 2) {
                    this._journalArticleLocalService.deleteArticle(article);
                }
                boolean exportVersionHistory = portletDataContext.getBooleanParameter("journal", "version-history");
                if (!ExportImportThreadLocal.isStagingInProcess() || !exportVersionHistory) {
                    this.updateArticleVersions(importedArticle);
                }
                if (Validator.isNull((String)newArticleId)) {
                    articleIds.put(article.getArticleId(), importedArticle.getArticleId());
                }
                Map articlePrimaryKeys = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".primaryKey");
                articlePrimaryKeys.put(article.getPrimaryKey(), importedArticle.getPrimaryKey());
                this._importAssetDisplayPage(portletDataContext, article, importedArticle);
                this._importFriendlyURLEntries(portletDataContext, article, importedArticle);
                this._sendUndeliveredUserNotificationEvents(article, importedArticle, serviceContext);
            }
            finally {
                ServiceContextThreadLocal.popServiceContext();
            }
            portletDataContext.importClassedModel((ClassedModel)article, (ClassedModel)importedArticle);
        }
        finally {
            if (smallFile != null) {
                smallFile.delete();
            }
        }
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        long userId = portletDataContext.getUserId(article.getUserUuid());
        Element articleElement = portletDataContext.getImportDataStagedModelElement((StagedModel)article);
        String articleResourceUuid = articleElement.attributeValue("article-resource-uuid");
        boolean preloaded = GetterUtil.getBoolean((String)articleElement.attributeValue("preloaded"));
        JournalArticle existingArticle = this.fetchExistingArticle(article.getUuid(), articleResourceUuid, portletDataContext.getScopeGroupId(), article.getArticleId(), article.getArticleId(), article.getVersion(), preloaded);
        if (existingArticle == null || !existingArticle.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingArticle.getTrashHandler();
        if (trashHandler.isRestorable(existingArticle.getResourcePrimKey())) {
            trashHandler.restoreTrashEntry(userId, existingArticle.getResourcePrimKey());
        }
    }

    protected void exportAssetCategories(PortletDataContext portletDataContext, JournalArticle stagedModel) throws PortletDataException {
        List assetCategories = this._assetCategoryLocalService.getCategories(ExportImportClassedModelUtil.getClassNameId((ClassedModel)stagedModel), this._getClassPK(stagedModel));
        for (AssetCategory assetCategory : assetCategories) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)assetCategory, (String)"weak");
        }
    }

    protected void exportAssetTags(PortletDataContext portletDataContext, JournalArticle stagedModel) throws PortletDataException {
        List assetTags = this._assetTagLocalService.getTags(ExportImportClassedModelUtil.getClassNameId((ClassedModel)stagedModel), this._getClassPK(stagedModel));
        for (AssetTag assetTag : assetTags) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)assetTag, (String)"weak");
        }
    }

    protected JournalArticle fetchExistingArticle(String articleResourceUuid, long groupId, String articleId, String newArticleId, boolean preloaded) {
        JournalArticleResource journalArticleResource = this._journalArticleResourceLocalService.fetchJournalArticleResourceByUuidAndGroupId(articleResourceUuid, groupId);
        if (journalArticleResource != null) {
            return this._journalArticleLocalService.fetchLatestArticle(journalArticleResource.getResourcePrimKey());
        }
        if (!preloaded) {
            return null;
        }
        JournalArticle existingArticle = null;
        if (Validator.isNotNull((String)newArticleId)) {
            existingArticle = this._journalArticleLocalService.fetchArticle(groupId, newArticleId);
        }
        if (existingArticle == null && Validator.isNull((String)newArticleId)) {
            existingArticle = this._journalArticleLocalService.fetchArticle(groupId, articleId);
        }
        return existingArticle;
    }

    protected JournalArticle fetchExistingArticle(String articleUuid, String articleResourceUuid, long groupId, String articleId, String newArticleId, double version, boolean preloaded) {
        JournalArticle article = this.fetchExistingArticle(articleResourceUuid, groupId, articleId, newArticleId, preloaded);
        if (article != null) {
            article = this.fetchExistingArticleVersion(article.getUuid(), groupId, article.getArticleId(), version);
        }
        return article;
    }

    protected JournalArticle fetchExistingArticleVersion(String articleUuid, long groupId, String articleId, double version) {
        JournalArticle existingArticle = this.fetchStagedModelByUuidAndGroupId(articleUuid, groupId);
        if (existingArticle != null) {
            return existingArticle;
        }
        if (version == 0.0) {
            return this._journalArticleLocalService.fetchArticle(groupId, articleId);
        }
        return this._journalArticleLocalService.fetchArticle(groupId, articleId, version);
    }

    protected JournalArticle fetchExistingArticleWithParentGroups(String articleUuid, String articleResourceUuid, long groupId, String articleId, String newArticleId, double version, boolean preloaded) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return null;
        }
        long companyId = group.getCompanyId();
        while (group != null) {
            JournalArticle article = this.fetchExistingArticle(articleUuid, articleResourceUuid, group.getGroupId(), articleId, newArticleId, version, preloaded);
            if (article != null) {
                return article;
            }
            group = group.getParentGroup();
        }
        Group companyGroup = this._groupLocalService.fetchCompanyGroup(companyId);
        if (companyGroup == null) {
            return null;
        }
        return this.fetchExistingArticle(articleUuid, articleResourceUuid, companyGroup.getGroupId(), articleId, newArticleId, version, preloaded);
    }

    protected String[] getSkipImportReferenceStagedModelNames() {
        return new String[]{AssetDisplayPageEntry.class.getName(), FriendlyURLEntry.class.getName(), Layout.class.getName()};
    }

    protected boolean isExpireAllArticleVersions(long companyId) throws PortalException {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this._configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
        return journalServiceConfiguration.expireAllArticleVersionsEnabled();
    }

    protected boolean isPreloadedArticle(long defaultUserId, JournalArticle article) {
        if (defaultUserId == article.getUserId()) {
            return true;
        }
        JournalArticle firstArticle = this._journalArticleLocalService.fetchArticle(article.getGroupId(), article.getArticleId(), 1.0);
        return firstArticle != null && defaultUserId == firstArticle.getUserId();
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setImageLocalService(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleResourceLocalService(JournalArticleResourceLocalService journalArticleResourceLocalService) {
        this._journalArticleResourceLocalService = journalArticleResourceLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalCreationStrategy(JournalCreationStrategy journalCreationStrategy) {
        this._journalCreationStrategy = journalCreationStrategy;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected void updateArticleVersions(JournalArticle article) throws PortalException {
        boolean expireAllArticleVersions = this.isExpireAllArticleVersions(article.getCompanyId());
        List articles = this._journalArticleLocalService.getArticles(article.getGroupId(), article.getArticleId());
        for (JournalArticle curArticle : articles) {
            boolean update = false;
            if ((article.isApproved() || article.isExpired()) && article.getExpirationDate() != null && expireAllArticleVersions && !Objects.equals(curArticle.getExpirationDate(), article.getExpirationDate())) {
                Date expirationDate = article.getExpirationDate();
                curArticle.setExpirationDate(expirationDate);
                if (expirationDate.before(new Date())) {
                    curArticle.setStatus(3);
                }
                update = true;
            }
            if (curArticle.getFolderId() != article.getFolderId()) {
                curArticle.setFolderId(article.getFolderId());
                curArticle.setTreePath(article.getTreePath());
                update = true;
            }
            if (!update) continue;
            this._journalArticleLocalService.updateJournalArticle(curArticle);
        }
    }

    private void _exportAssetDisplayPage(PortletDataContext portletDataContext, JournalArticle article) throws PortletDataException {
        AssetDisplayPageEntry assetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(article.getGroupId(), this._portal.getClassNameId(JournalArticle.class), article.getResourcePrimKey());
        if (assetDisplayPageEntry != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)assetDisplayPageEntry, (String)"dependency");
        }
    }

    private void _exportFriendlyURLEntries(PortletDataContext portletDataContext, JournalArticle article) throws PortletDataException {
        List friendlyURLEntries = this._friendlyURLEntryLocalService.getFriendlyURLEntries(article.getGroupId(), this._portal.getClassNameId(JournalArticle.class), article.getResourcePrimKey());
        for (FriendlyURLEntry friendlyURLEntry : friendlyURLEntries) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)friendlyURLEntry);
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)friendlyURLEntry, (String)"dependency");
        }
    }

    private long _getClassPK(JournalArticle article) {
        if (article.isScheduled() && article.getVersion() != 1.0) {
            return article.getPrimaryKey();
        }
        return article.getResourcePrimKey();
    }

    private void _importAssetDisplayPage(PortletDataContext portletDataContext, JournalArticle article, JournalArticle importedArticle) throws PortalException {
        List assetDisplayPageEntryElements = portletDataContext.getReferenceDataElements((StagedModel)article, AssetDisplayPageEntry.class);
        Map articleNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class);
        articleNewPrimaryKeys.put(article.getResourcePrimKey(), importedArticle.getResourcePrimKey());
        for (Element assetDisplayPageEntryElement : assetDisplayPageEntryElements) {
            String path = assetDisplayPageEntryElement.attributeValue("path");
            AssetDisplayPageEntry assetDisplayPageEntry = (AssetDisplayPageEntry)portletDataContext.getZipEntryAsObject(path);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)assetDisplayPageEntryElement);
            Map assetDisplayPageEntries = portletDataContext.getNewPrimaryKeysMap(AssetDisplayPageEntry.class);
            long assetDisplayPageEntryId = MapUtil.getLong((Map)assetDisplayPageEntries, (long)assetDisplayPageEntry.getAssetDisplayPageEntryId(), (long)assetDisplayPageEntry.getAssetDisplayPageEntryId());
            AssetDisplayPageEntry existingAssetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(assetDisplayPageEntryId);
            if (existingAssetDisplayPageEntry == null) continue;
            existingAssetDisplayPageEntry.setClassPK(importedArticle.getResourcePrimKey());
            this._assetDisplayPageEntryLocalService.updateAssetDisplayPageEntry(existingAssetDisplayPageEntry);
        }
    }

    private void _importFriendlyURLEntries(PortletDataContext portletDataContext, JournalArticle article, JournalArticle importedArticle) throws PortalException {
        List friendlyURLEntryElements = portletDataContext.getReferenceDataElements((StagedModel)article, FriendlyURLEntry.class);
        Map articleNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class);
        articleNewPrimaryKeys.put(article.getResourcePrimKey(), importedArticle.getResourcePrimKey());
        for (Element friendlyURLEntryElement : friendlyURLEntryElements) {
            String path = friendlyURLEntryElement.attributeValue("path");
            FriendlyURLEntry friendlyURLEntry = (FriendlyURLEntry)portletDataContext.getZipEntryAsObject(path);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)friendlyURLEntryElement);
            Map friendlyURLEntries = portletDataContext.getNewPrimaryKeysMap(FriendlyURLEntry.class);
            long friendlyURLEntryId = MapUtil.getLong((Map)friendlyURLEntries, (long)friendlyURLEntry.getFriendlyURLEntryId(), (long)friendlyURLEntry.getFriendlyURLEntryId());
            FriendlyURLEntry existingFriendlyURLEntry = this._friendlyURLEntryLocalService.fetchFriendlyURLEntry(friendlyURLEntryId);
            if (existingFriendlyURLEntry == null) continue;
            existingFriendlyURLEntry.setClassPK(importedArticle.getResourcePrimKey());
            this._friendlyURLEntryLocalService.updateFriendlyURLEntry(existingFriendlyURLEntry);
        }
    }

    private void _sendUndeliveredUserNotificationEvents(JournalArticle article, JournalArticle importedArticle, ServiceContext serviceContext) {
        block2: {
            ActionableDynamicQuery actionableDynamicQuery = this._userNotificationEventLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property delivered = PropertyFactoryUtil.forName((String)"delivered");
                dynamicQuery.add(delivered.eq((Object)false));
                Property payload = PropertyFactoryUtil.forName((String)"payload");
                dynamicQuery.add(payload.like((Object)("%" + article.getId() + "%")));
            });
            actionableDynamicQuery.setCompanyId(article.getCompanyId());
            actionableDynamicQuery.setPerformActionMethod(userNotificationEvent -> {
                block4: {
                    userNotificationEvent.setDelivered(true);
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
                    SubscriptionSender subscriptionSender = new SubscriptionSender();
                    subscriptionSender.setClassName(jsonObject.getString("className"));
                    subscriptionSender.setClassPK(jsonObject.getLong("classPK"));
                    subscriptionSender.setCompanyId(userNotificationEvent.getCompanyId());
                    Map contextMap = (Map)JSONFactoryUtil.looseDeserialize((String)String.valueOf(jsonObject.get("context")));
                    String articleURL = JournalUtil.getJournalControlPanelLink(importedArticle.getFolderId(), importedArticle.getGroupId(), serviceContext.getLiferayPortletResponse());
                    contextMap.put("[$ARTICLE_URL$]", HashMapBuilder.put((Object)"escape", (Object)true).put((Object)"escapedValue", () -> {
                        HtmlEscapableObject escapedObject = new HtmlEscapableObject((Object)articleURL, true);
                        return escapedObject.getEscapedValue();
                    }).put((Object)"originalValue", (Object)articleURL).build());
                    contextMap.forEach((key, value) -> subscriptionSender.setContextAttribute(key, value.get("originalValue")));
                    jsonObject.put("context", (Object)contextMap).put("entryURL", articleURL);
                    userNotificationEvent.setPayload(jsonObject.toString());
                    userNotificationEvent.setTimestamp(System.currentTimeMillis());
                    this._userNotificationEventLocalService.updateUserNotificationEvent(userNotificationEvent);
                    JournalGroupServiceConfiguration journalGroupServiceConfiguration = (JournalGroupServiceConfiguration)this._configurationProvider.getConfiguration(JournalGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(article.getGroupId(), "com.liferay.journal"));
                    String fromAddress = journalGroupServiceConfiguration.emailFromAddress();
                    String fromName = journalGroupServiceConfiguration.emailFromName();
                    subscriptionSender.setFrom(fromAddress, fromName);
                    subscriptionSender.setHtmlFormat(true);
                    Map localizedJsonBodyMap = (Map)JSONFactoryUtil.looseDeserialize((String)String.valueOf(jsonObject.get("localizedBodyMap")));
                    HashMap localizedBodyMap = new HashMap();
                    for (Map.Entry entry : localizedJsonBodyMap.entrySet()) {
                        localizedBodyMap.put(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), entry.getValue());
                    }
                    subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
                    Map localizedJsonSubjectMap = (Map)JSONFactoryUtil.looseDeserialize((String)String.valueOf(jsonObject.get("localizedSubjectMap")));
                    HashMap localizedSubjectMap = new HashMap();
                    for (Map.Entry entry : localizedJsonSubjectMap.entrySet()) {
                        localizedSubjectMap.put(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), entry.getValue());
                    }
                    subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
                    subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
                    subscriptionSender.setNotificationType(jsonObject.getInt("notificationType"));
                    subscriptionSender.setPortletId(jsonObject.getString("portletId"));
                    subscriptionSender.setReplyToAddress(fromAddress);
                    try {
                        subscriptionSender.sendEmailNotification(userNotificationEvent.getUserId());
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) break block4;
                        _log.warn((Object)("Unable to send email notification for article " + article.getArticleId()));
                    }
                }
            });
            try {
                actionableDynamicQuery.performActions();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to send email notification for article " + article.getArticleId()));
            }
        }
    }

    @Deprecated
    private void _setLegacyValues(JournalArticle article) {
        if (MapUtil.isEmpty((Map)article.getTitleMap()) && Validator.isNotNull((String)article.getLegacyTitle())) {
            article.setTitleMap(LocalizationUtil.getLocalizationMap((String)article.getLegacyTitle()));
        }
        if (MapUtil.isEmpty((Map)article.getDescriptionMap()) && Validator.isNotNull((String)article.getLegacyDescription())) {
            article.setDescriptionMap(LocalizationUtil.getLocalizationMap((String)article.getLegacyDescription()));
        }
    }
}

