/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.journal.exception.NoSuchFeedException;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFeedLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"content.processor.type=JournalFeedReferences"}, service={ExportImportContentProcessor.class})
public class JournalFeedReferencesExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String _JOURNAL_FEED_FRIENDLY_URL = "/-/journal/rss/";
    private static final char[] _JOURNAL_FEED_REFERENCE_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '#', '?', '\"', ' '};
    private static final Log _log = LogFactoryUtil.getLog(JournalFeedReferencesExportImportContentProcessor.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    private ConfigurationProvider _configurationProvider;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalFeedLocalService _journalFeedLocalService;
    @Reference
    private Portal _portal;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        return this.replaceExportJournalFeedReferences(portletDataContext, stagedModel, content, exportReferencedContent);
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        return this.replaceImportJournalFeedReferences(portletDataContext, stagedModel, content);
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        if (this._isValidateJournalFeedReferences()) {
            this.validateJournalFeedReferences(groupId, content);
        }
    }

    protected JournalFeed getJournalFeed(Map<String, String> map) {
        JournalFeed journalFeed;
        block5: {
            if (MapUtil.isEmpty(map)) {
                return null;
            }
            journalFeed = null;
            try {
                String feedId = MapUtil.getString(map, (String)"feedId");
                if (Validator.isNotNull((String)feedId)) {
                    long groupId = MapUtil.getLong(map, (String)"groupId");
                    journalFeed = this._journalFeedLocalService.getFeed(groupId, feedId);
                }
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)exception, (Throwable)exception);
                }
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)exception.getMessage());
            }
        }
        return journalFeed;
    }

    protected Map<String, String> getJournalFeedReferenceParameters(long groupId, String content, int beginPos, int endPos) {
        if ((endPos = StringUtil.indexOfAny((String)content, (char[])_JOURNAL_FEED_REFERENCE_STOP_CHARS, (int)beginPos, (int)endPos)) == -1) {
            return null;
        }
        String journalFeedReference = content.substring(beginPos + _JOURNAL_FEED_FRIENDLY_URL.length(), endPos);
        String[] pathArray = journalFeedReference.split("/");
        if (pathArray.length < 2) {
            return null;
        }
        HashMap map = HashMapBuilder.put((Object)"endPos", (Object)String.valueOf(endPos)).put((Object)"feedId", (Object)pathArray[1]).put((Object)"groupId", (Object)pathArray[0]).build();
        String groupIdString = MapUtil.getString((Map)map, (String)"groupId");
        if (groupIdString.equals("@group_id@")) {
            groupIdString = String.valueOf(groupId);
            map.put("groupId", groupIdString);
        }
        return map;
    }

    protected String replaceExportJournalFeedReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent) throws Exception {
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_journal_web_portlet_JournalPortlet")) {
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        String[] patterns = new String[]{_JOURNAL_FEED_FRIENDLY_URL};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            block9: {
                Map<String, String> journalFeedReferenceParameters = this.getJournalFeedReferenceParameters(portletDataContext.getScopeGroupId(), content, beginPos, endPos);
                JournalFeed journalFeed = this.getJournalFeed(journalFeedReferenceParameters);
                if (journalFeed == null) {
                    endPos = beginPos - 1;
                    continue;
                }
                endPos = MapUtil.getInteger(journalFeedReferenceParameters, (String)"endPos");
                try {
                    if (exportReferencedContent) {
                        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)journalFeed, (String)"dependency");
                    } else {
                        Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                        String referenceType = "dependency";
                        portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)journalFeed, referenceType, true);
                    }
                    String path = ExportImportPathUtil.getModelPath((StagedModel)journalFeed);
                    StringBundler exportedReferenceSB = new StringBundler(4);
                    exportedReferenceSB.append("/-/");
                    exportedReferenceSB.append("[$journalfeed-reference=");
                    exportedReferenceSB.append(path);
                    exportedReferenceSB.append("$]");
                    sb.replace(beginPos, endPos, exportedReferenceSB.toString());
                }
                catch (Exception exception) {
                    StringBundler exceptionSB = new StringBundler(6);
                    exceptionSB.append("Unable to process journal feed ");
                    exceptionSB.append(journalFeed.getFeedId());
                    exceptionSB.append(" for staged model ");
                    exceptionSB.append(stagedModel.getModelClassName());
                    exceptionSB.append(" with primary key ");
                    exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                    ExportImportContentProcessorException exportImportContentProcessorException = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)exception);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)exceptionSB.toString(), (Throwable)exportImportContentProcessorException);
                    }
                    if (!_log.isWarnEnabled()) break block9;
                    _log.warn((Object)exceptionSB.toString());
                }
            }
            endPos = beginPos - 1;
        }
        return sb.toString();
    }

    protected String replaceImportJournalFeedReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        List referenceElements = portletDataContext.getReferenceElements(stagedModel, JournalFeed.class);
        for (Element referenceElement : referenceElements) {
            String exportedReference;
            Long classPK;
            block9: {
                classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
                Element referenceDataElement = portletDataContext.getReferenceDataElement(stagedModel, JournalFeed.class, classPK.longValue());
                String path = null;
                if (referenceDataElement != null) {
                    path = referenceDataElement.attributeValue("path");
                }
                if (Validator.isNull(path)) {
                    long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
                    String className = referenceElement.attributeValue("class-name");
                    path = ExportImportPathUtil.getModelPath((long)groupId, (String)className, (Serializable)classPK);
                }
                if (!content.contains(exportedReference = StringBundler.concat((String[])new String[]{"/-/", "[$journalfeed-reference=", path, "$]"}))) continue;
                try {
                    StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, JournalFeed.class, (Serializable)classPK);
                }
                catch (Exception exception) {
                    StringBundler exceptionSB = new StringBundler(6);
                    exceptionSB.append("Unable to process journal feed ");
                    exceptionSB.append((Object)classPK);
                    exceptionSB.append(" for ");
                    exceptionSB.append(stagedModel.getModelClassName());
                    exceptionSB.append(" with primary key ");
                    exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                    ExportImportContentProcessorException exportImportContentProcessorException = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)exception);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)exceptionSB.toString(), (Throwable)exportImportContentProcessorException);
                    }
                    if (!_log.isWarnEnabled()) break block9;
                    _log.warn((Object)exceptionSB.toString());
                }
            }
            Map journalFeedIds = portletDataContext.getNewPrimaryKeysMap(JournalFeed.class);
            long journalFeedId = MapUtil.getLong((Map)journalFeedIds, (long)classPK, (long)classPK);
            JournalFeed importedJournalFeed = null;
            try {
                importedJournalFeed = this._journalFeedLocalService.getFeed(journalFeedId);
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)portalException, (Throwable)portalException);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)portalException.getMessage());
                continue;
            }
            String url = StringBundler.concat((Object[])new Object[]{_JOURNAL_FEED_FRIENDLY_URL, importedJournalFeed.getGroupId(), "/", importedJournalFeed.getFeedId()});
            content = StringUtil.replace((String)content, (String)exportedReference, (String)url);
        }
        return content;
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    protected void validateJournalFeedReferences(long groupId, String content) throws PortalException {
        String[] patterns = new String[]{_JOURNAL_FEED_FRIENDLY_URL};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            Map<String, String> journalFeedReferenceParameters = this.getJournalFeedReferenceParameters(groupId, content, beginPos, endPos);
            JournalFeed journalFeed = this.getJournalFeed(journalFeedReferenceParameters);
            if (journalFeed == null) {
                ExportImportContentValidationException exportImportContentValidationException = new ExportImportContentValidationException(JournalFeedReferencesExportImportContentProcessor.class.getName(), (Throwable)new NoSuchFeedException());
                exportImportContentValidationException.setJournalArticleFeedURL(this._getJournalFeedReferenceURL(content, beginPos, endPos));
                exportImportContentValidationException.setStagedModelClassName(JournalFeed.class.getName());
                exportImportContentValidationException.setType(7);
                throw exportImportContentValidationException;
            }
            endPos = beginPos - 1;
        }
    }

    private String _getJournalFeedReferenceURL(String content, int beginPos, int endPos) {
        if ((endPos = StringUtil.indexOfAny((String)content, (char[])_JOURNAL_FEED_REFERENCE_STOP_CHARS, (int)beginPos, (int)endPos)) == -1) {
            return null;
        }
        return content.substring(beginPos, endPos);
    }

    private boolean _isValidateJournalFeedReferences() {
        try {
            ExportImportServiceConfiguration configuration = (ExportImportServiceConfiguration)this._configurationProvider.getCompanyConfiguration(ExportImportServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return configuration.validateJournalFeedReferences();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return true;
        }
    }
}

