/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;

public class ImageImportDDMFormFieldValueTransformer
implements DDMFormFieldValueTransformer {
    private static final Log _log = LogFactoryUtil.getLog(ImageImportDDMFormFieldValueTransformer.class);
    private final DLAppLocalService _dlAppLocalService;
    private final PortletDataContext _portletDataContext;
    private final StagedModel _stagedModel;

    public ImageImportDDMFormFieldValueTransformer(DLAppLocalService dlAppLocalService, PortletDataContext portletDataContext, StagedModel stagedModel) {
        this._dlAppLocalService = dlAppLocalService;
        this._portletDataContext = portletDataContext;
        this._stagedModel = stagedModel;
    }

    public String getFieldType() {
        return "ddm-image";
    }

    public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
        Value value = ddmFormFieldValue.getValue();
        for (Locale locale : value.getAvailableLocales()) {
            JSONObject jsonObject = null;
            try {
                jsonObject = JSONFactoryUtil.createJSONObject((String)value.getString(locale));
            }
            catch (JSONException jsonException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                continue;
            }
            FileEntry importedFileEntry = this.fetchImportedFileEntry(this._portletDataContext, jsonObject.getLong("fileEntryId"), jsonObject.getString("uuid"));
            if (importedFileEntry == null) continue;
            value.addString(locale, this.toJSON(importedFileEntry, jsonObject.getString("type"), jsonObject.getString("alt")));
        }
    }

    protected FileEntry fetchImportedFileEntry(PortletDataContext portletDataContext, long oldClassPK, String uuid) throws PortalException {
        try {
            Map fileEntryPKs = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
            Long classPK = (Long)fileEntryPKs.get(oldClassPK);
            if (classPK == null) {
                if (Validator.isNotNull((String)uuid)) {
                    return this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, portletDataContext.getScopeGroupId());
                }
                return null;
            }
            return this._dlAppLocalService.getFileEntry(classPK.longValue());
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to find file entry", (Throwable)portalException);
            }
            return null;
        }
    }

    protected String toJSON(FileEntry fileEntry, String type, String alt) {
        JournalArticle article = (JournalArticle)this._stagedModel;
        JSONObject jsonObject = JSONUtil.put((String)"alt", (Object)alt).put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("name", fileEntry.getFileName()).put("resourcePrimKey", article.getResourcePrimKey()).put("title", fileEntry.getTitle()).put("type", type).put("uuid", fileEntry.getUuid());
        return jsonObject.toString();
    }
}

