/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.asset.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.model.AssetEntryUsage;
import com.liferay.asset.service.AssetEntryUsageLocalService;
import com.liferay.asset.util.AssetEntryUsageRecorder;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalContentSearch;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={AssetEntryUsageRecorder.class})
public class JournalArticleAssetEntryUsageRecorder
implements AssetEntryUsageRecorder {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetEntryUsageLocalService _assetEntryUsageLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    public void record(AssetEntry assetEntry) throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        JournalArticle article = (JournalArticle)assetRenderer.getAssetObject();
        if (!article.isApproved()) {
            assetEntry = this._assetEntryLocalService.fetchEntry(this._portal.getClassNameId(JournalArticle.class), article.getResourcePrimKey());
        }
        if (this._assetEntryUsageLocalService.hasDefaultAssetEntryUsage(assetEntry.getEntryId())) {
            return;
        }
        this._recordJournalContentSearches(assetEntry);
        this._recordPortletPreferences(assetEntry, true);
        this._recordPortletPreferences(assetEntry, false);
        this._assetEntryUsageLocalService.addDefaultAssetEntryUsage(assetEntry.getGroupId(), assetEntry.getEntryId(), ServiceContextThreadLocal.getServiceContext());
    }

    private void _recordJournalContentSearches(AssetEntry assetEntry) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        JournalArticle article = (JournalArticle)assetRenderer.getAssetObject();
        List contentSearches = this._journalContentSearchLocalService.getArticleContentSearches(article.getGroupId(), article.getArticleId());
        for (JournalContentSearch contentSearch : contentSearches) {
            Layout layout = this._layoutLocalService.fetchLayout(contentSearch.getGroupId(), contentSearch.isPrivateLayout(), contentSearch.getLayoutId());
            AssetEntryUsage assetEntryUsage = this._assetEntryUsageLocalService.fetchAssetEntryUsage(assetEntry.getEntryId(), this._portal.getClassNameId(Portlet.class), contentSearch.getPortletId(), layout.getPlid());
            if (assetEntryUsage != null) continue;
            this._assetEntryUsageLocalService.addAssetEntryUsage(contentSearch.getGroupId(), assetEntry.getEntryId(), this._portal.getClassNameId(Portlet.class), contentSearch.getPortletId(), layout.getPlid(), serviceContext);
        }
    }

    private void _recordPortletPreferences(AssetEntry assetEntry, boolean privateLayout) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(assetEntry.getCompanyId(), assetEntry.getGroupId(), 0L, 3, "com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet", privateLayout);
        for (com.liferay.portal.kernel.model.PortletPreferences portletPreferences : portletPreferencesList) {
            AssetEntryUsage assetEntryUsage;
            String assetEntryXml;
            PortletPreferences jxPortletPreferences;
            String selectionStyle;
            String preferencesXML = portletPreferences.getPreferences();
            if (Validator.isNull((String)preferencesXML) || !StringUtil.equals((String)(selectionStyle = (jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)preferencesXML)).getValue("selectionStyle", "dynamic")), (String)"manual") || !(assetEntryXml = jxPortletPreferences.getValue("assetEntryXml", "")).contains(assetEntry.getClassUuid()) || (assetEntryUsage = this._assetEntryUsageLocalService.fetchAssetEntryUsage(assetEntry.getEntryId(), this._portal.getClassNameId(Portlet.class), portletPreferences.getPortletId(), portletPreferences.getPlid())) != null) continue;
            this._assetEntryUsageLocalService.addAssetEntryUsage(assetEntry.getGroupId(), assetEntry.getEntryId(), this._portal.getClassNameId(Portlet.class), portletPreferences.getPortletId(), portletPreferences.getPlid(), serviceContext);
        }
    }
}

